/*
 * Decompiled with CFR 0.152.
 */
package neqsim.blackoil;

import neqsim.blackoil.BlackOilFlash;
import neqsim.blackoil.BlackOilFlashResult;
import neqsim.blackoil.BlackOilPVTTable;

public class SystemBlackOil {
    private final BlackOilPVTTable pvt;
    private final BlackOilFlash flash;
    private double P;
    private double T;
    private double Otot_std;
    private double Gtot_std;
    private double W_std;
    private BlackOilFlashResult last;

    public SystemBlackOil(BlackOilPVTTable pvt, double rho_o_sc, double rho_g_sc, double rho_w_sc) {
        this.pvt = pvt;
        this.flash = new BlackOilFlash(pvt, rho_o_sc, rho_g_sc, rho_w_sc);
    }

    public SystemBlackOil copyShallow() {
        SystemBlackOil s = new SystemBlackOil(this.pvt, 800.0, 1.2, 1000.0);
        s.P = this.P;
        s.T = this.T;
        s.Otot_std = this.Otot_std;
        s.Gtot_std = this.Gtot_std;
        s.W_std = this.W_std;
        s.last = null;
        return s;
    }

    public void setPressure(double P) {
        this.P = P;
        this.last = null;
    }

    public void setTemperature(double T) {
        this.T = T;
        this.last = null;
    }

    public void setStdTotals(double Otot_std, double Gtot_std, double W_std) {
        this.Otot_std = Math.max(0.0, Otot_std);
        this.Gtot_std = Math.max(0.0, Gtot_std);
        this.W_std = Math.max(0.0, W_std);
        this.last = null;
    }

    public double getPressure() {
        return this.P;
    }

    public double getTemperature() {
        return this.T;
    }

    public double getOilStdTotal() {
        return this.Otot_std;
    }

    public double getGasStdTotal() {
        return this.Gtot_std;
    }

    public double getWaterStd() {
        return this.W_std;
    }

    public BlackOilFlashResult flash() {
        if (this.last == null) {
            this.last = this.flash.flash(this.P, this.T, this.Otot_std, this.Gtot_std, this.W_std);
        }
        return this.last;
    }

    public double getBo() {
        return this.pvt.Bo(this.P);
    }

    public double getBg() {
        return this.pvt.Bg(this.P);
    }

    public double getBw() {
        return this.pvt.Bw(this.P);
    }

    public double getRs() {
        return this.pvt.RsEffective(this.P);
    }

    public double getRv() {
        return this.pvt.Rv(this.P);
    }

    public double getOilDensity() {
        return this.flash().rho_o;
    }

    public double getGasDensity() {
        return this.flash().rho_g;
    }

    public double getWaterDensity() {
        return this.flash().rho_w;
    }

    public double getOilViscosity() {
        return this.flash().mu_o;
    }

    public double getGasViscosity() {
        return this.flash().mu_g;
    }

    public double getWaterViscosity() {
        return this.flash().mu_w;
    }

    public double getOilReservoirVolume() {
        return this.flash().V_o;
    }

    public double getGasReservoirVolume() {
        return this.flash().V_g;
    }

    public double getWaterReservoirVolume() {
        return this.flash().V_w;
    }
}

