/*
 * Decompiled with CFR 0.152.
 */
package neqsim.blackoil.io;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import neqsim.blackoil.BlackOilPVTTable;
import neqsim.blackoil.SystemBlackOil;

public class EclipseBlackOilImporter {
    public static Result fromFile(Path deckPath) throws IOException {
        try (BufferedReader br = Files.newBufferedReader(deckPath);){
            Result result = EclipseBlackOilImporter.parse(br);
            return result;
        }
    }

    public static Result fromReader(Reader reader) throws IOException {
        return EclipseBlackOilImporter.parse(new BufferedReader(reader));
    }

    private static Result parse(BufferedReader br) throws IOException {
        String line;
        Objects.requireNonNull(br, "reader == null");
        Units units = Units.METRIC;
        ArrayList<PVTOCurve> pvto = new ArrayList<PVTOCurve>();
        ArrayList<PVTGCurve> pvtg = new ArrayList<PVTGCurve>();
        ArrayList<PVTWRow> pvtw = new ArrayList<PVTWRow>();
        double rho_o_sc = Double.NaN;
        double rho_w_sc = Double.NaN;
        double rho_g_sc = Double.NaN;
        block0: while ((line = br.readLine()) != null) {
            String string;
            Object rr;
            List<Double> row;
            String data;
            boolean end;
            String lc;
            Iterator<PVTOCurve.Row> r0;
            String h2;
            List<Double> hdr;
            if ((line = EclipseBlackOilImporter.stripComments(line)).trim().isEmpty()) continue;
            Object u = line.toUpperCase(Locale.ROOT).trim();
            if (((String)u).startsWith("UNITS")) {
                if (((String)u).contains("FIELD")) {
                    units = Units.FIELD;
                    continue;
                }
                if (((String)u).contains("LAB")) {
                    units = Units.LAB;
                    continue;
                }
                units = Units.METRIC;
                continue;
            }
            if (((String)u).startsWith("DENSITY")) {
                String l23;
                ArrayList<Double> arrayList = new ArrayList<Double>();
                arrayList.addAll(EclipseBlackOilImporter.numbersFromLine(((String)u).substring("DENSITY".length())));
                while (!((String)u).contains("/") && (l23 = br.readLine()) != null) {
                    u = EclipseBlackOilImporter.stripComments(l23).toUpperCase(Locale.ROOT);
                    arrayList.addAll(EclipseBlackOilImporter.numbersFromLine((String)u));
                }
                if (arrayList.size() < 3) continue;
                rho_o_sc = (Double)arrayList.get(0);
                rho_w_sc = (Double)arrayList.get(1);
                rho_g_sc = (Double)arrayList.get(2);
                if (units != Units.FIELD) continue;
                double f = 16.01846337;
                rho_o_sc *= f;
                rho_w_sc *= f;
                rho_g_sc *= f;
                continue;
            }
            if (((String)u).startsWith("PVTO")) {
                String string2;
                while ((string2 = br.readLine()) != null) {
                    String string3 = EclipseBlackOilImporter.stripComments(string2);
                    if (string3.trim().isEmpty()) continue;
                    if (string3.trim().startsWith("/")) continue block0;
                    boolean headerEnds = string3.contains("/");
                    String string4 = string3.split("/", 2)[0];
                    hdr = EclipseBlackOilImporter.numbersFromLine(string4);
                    if (hdr.size() < 4) {
                        h2 = br.readLine();
                        if (h2 == null) continue block0;
                        h2 = EclipseBlackOilImporter.stripComments(h2);
                        String hc = string4 + " " + h2.split("/", 2)[0];
                        hdr = EclipseBlackOilImporter.numbersFromLine(hc);
                    }
                    if (hdr.size() < 4) {
                        throw new IOException("PVTO header needs at least 4 numbers: Rs Pb Bo mu");
                    }
                    PVTOCurve c2 = new PVTOCurve();
                    c2.Rs = hdr.get(0);
                    double Pb = hdr.get(1);
                    r0 = new PVTOCurve.Row();
                    ((PVTOCurve.Row)((Object)r0)).P = Pb;
                    ((PVTOCurve.Row)((Object)r0)).Bo = hdr.get(2);
                    ((PVTOCurve.Row)((Object)r0)).mu = hdr.get(3);
                    c2.rows.add((PVTOCurve.Row)((Object)r0));
                    if (!headerEnds) {
                        String l22;
                        while ((l22 = br.readLine()) != null) {
                            lc = EclipseBlackOilImporter.stripComments(l22);
                            if (lc.trim().isEmpty()) continue;
                            end = lc.contains("/");
                            data = lc.split("/", 2)[0];
                            row = EclipseBlackOilImporter.numbersFromLine(data);
                            if (row.size() >= 3) {
                                rr = new PVTOCurve.Row();
                                ((PVTOCurve.Row)rr).P = row.get(0);
                                ((PVTOCurve.Row)rr).Bo = row.get(1);
                                ((PVTOCurve.Row)rr).mu = row.get(2);
                                c2.rows.add((PVTOCurve.Row)rr);
                            }
                            if (!end) continue;
                            break;
                        }
                    }
                    pvto.add(c2);
                }
                continue;
            }
            if (((String)u).startsWith("PVTG")) {
                String string5;
                while ((string5 = br.readLine()) != null) {
                    String string6 = EclipseBlackOilImporter.stripComments(string5);
                    if (string6.trim().isEmpty()) continue;
                    if (string6.trim().startsWith("/")) continue block0;
                    boolean headerEnds = string6.contains("/");
                    String string7 = string6.split("/", 2)[0];
                    hdr = EclipseBlackOilImporter.numbersFromLine(string7);
                    if (hdr.size() < 4) {
                        h2 = br.readLine();
                        if (h2 == null) continue block0;
                        h2 = EclipseBlackOilImporter.stripComments(h2);
                        String hc = string7 + " " + h2.split("/", 2)[0];
                        hdr = EclipseBlackOilImporter.numbersFromLine(hc);
                    }
                    if (hdr.size() < 4) {
                        throw new IOException("PVTG header needs at least 4 numbers: Rv Pd Bg mu");
                    }
                    PVTGCurve c2 = new PVTGCurve();
                    c2.Rv = hdr.get(0);
                    double Pd = hdr.get(1);
                    r0 = new PVTGCurve.Row();
                    ((PVTGCurve.Row)((Object)r0)).P = Pd;
                    ((PVTGCurve.Row)((Object)r0)).Bg = hdr.get(2);
                    ((PVTGCurve.Row)((Object)r0)).mu = hdr.get(3);
                    c2.rows.add((PVTGCurve.Row)((Object)r0));
                    if (!headerEnds) {
                        String l2;
                        while ((l2 = br.readLine()) != null) {
                            lc = EclipseBlackOilImporter.stripComments(l2);
                            if (lc.trim().isEmpty()) continue;
                            end = lc.contains("/");
                            data = lc.split("/", 2)[0];
                            row = EclipseBlackOilImporter.numbersFromLine(data);
                            if (row.size() >= 3) {
                                rr = new PVTGCurve.Row();
                                ((PVTGCurve.Row)rr).P = row.get(0);
                                ((PVTGCurve.Row)rr).Bg = row.get(1);
                                ((PVTGCurve.Row)rr).mu = row.get(2);
                                c2.rows.add((PVTGCurve.Row)rr);
                            }
                            if (!end) continue;
                            break;
                        }
                    }
                    pvtg.add(c2);
                }
                continue;
            }
            if (!((String)u).startsWith("PVTW")) continue;
            while ((string = br.readLine()) != null) {
                String lc2 = EclipseBlackOilImporter.stripComments(string);
                if (lc2.trim().isEmpty()) continue;
                if (lc2.trim().startsWith("/")) continue block0;
                boolean bl = lc2.contains("/");
                String data2 = lc2.split("/", 2)[0];
                List<Double> row2 = EclipseBlackOilImporter.numbersFromLine(data2);
                if (row2.size() >= 3) {
                    PVTWRow r = new PVTWRow();
                    r.P = row2.get(0);
                    r.Bw = row2.get(1);
                    r.mu = row2.get(2);
                    pvtw.add(r);
                }
                if (!bl) continue;
                continue block0;
            }
        }
        if (units == Units.FIELD) {
            for (PVTOCurve pVTOCurve : pvto) {
                pVTOCurve.Rs *= 0.17810760667903525;
                for (PVTOCurve.Row row : pVTOCurve.rows) {
                    row.P *= 0.06894757293168;
                    row.mu *= 0.001;
                }
            }
            for (PVTGCurve pVTGCurve : pvtg) {
                pVTGCurve.Rv *= 5.614583333333334;
                for (PVTGCurve.Row row : pVTGCurve.rows) {
                    row.P *= 0.06894757293168;
                    row.Bg *= 5.614583333333334;
                    row.mu *= 0.001;
                }
            }
            for (PVTWRow pVTWRow : pvtw) {
                pVTWRow.P *= 0.06894757293168;
                pVTWRow.mu *= 0.001;
            }
        } else {
            for (PVTOCurve pVTOCurve : pvto) {
                for (PVTOCurve.Row row : pVTOCurve.rows) {
                    row.mu *= 0.001;
                }
            }
            for (PVTGCurve pVTGCurve : pvtg) {
                for (PVTGCurve.Row row : pVTGCurve.rows) {
                    row.mu *= 0.001;
                }
            }
            for (PVTWRow pVTWRow : pvtw) {
                pVTWRow.mu *= 0.001;
            }
        }
        if (pvto.isEmpty()) {
            throw new IOException("PVTO not found in deck");
        }
        if (Double.isNaN(rho_o_sc)) {
            rho_o_sc = 800.0;
        }
        if (Double.isNaN(rho_w_sc)) {
            rho_w_sc = 1000.0;
        }
        if (Double.isNaN(rho_g_sc)) {
            rho_g_sc = 1.2;
        }
        PVTOCurve base = Collections.max(pvto, Comparator.comparingDouble(c -> c.Rs));
        class SatPoint {
            double P;
            double Rs;
            double Bo;
            double mu;

            SatPoint(double P, double Rs, double Bo, double mu) {
                this.P = P;
                this.Rs = Rs;
                this.Bo = Bo;
                this.mu = mu;
            }
        }
        ArrayList<SatPoint> arrayList = new ArrayList<SatPoint>();
        for (PVTOCurve pVTOCurve : pvto) {
            if (pVTOCurve.rows.isEmpty()) continue;
            PVTOCurve.Row r0 = pVTOCurve.rows.get(0);
            arrayList.add(new SatPoint(r0.P, pVTOCurve.Rs, r0.Bo, r0.mu));
        }
        arrayList.sort(Comparator.comparingDouble(sp -> sp.P));
        double Pb = base.rows.get((int)0).P;
        ArrayList<Double> Pg = new ArrayList<Double>();
        ArrayList<Double> RsOfP = new ArrayList<Double>();
        ArrayList<Double> BoOfP = new ArrayList<Double>();
        ArrayList<Double> muoOfP = new ArrayList<Double>();
        for (SatPoint sp2 : arrayList) {
            if (!(sp2.P <= Pb)) continue;
            Pg.add(sp2.P);
            RsOfP.add(sp2.Rs);
            BoOfP.add(sp2.Bo);
            muoOfP.add(sp2.mu);
        }
        if (Pg.stream().noneMatch(p -> Math.abs(p - Pb) < 1.0E-9)) {
            Pg.add(Pb);
            RsOfP.add(base.Rs);
            BoOfP.add(base.rows.get((int)0).Bo);
            muoOfP.add(base.rows.get((int)0).mu);
        }
        for (PVTOCurve.Row r : base.rows) {
            if (!(r.P >= Pb + 1.0E-9)) continue;
            Pg.add(r.P);
            RsOfP.add(base.Rs);
            BoOfP.add(r.Bo);
            muoOfP.add(r.mu);
        }
        EclipseBlackOilImporter.sortParallel(Pg, RsOfP, BoOfP, muoOfP);
        ArrayList<Double> BgOfP = new ArrayList<Double>();
        ArrayList<Double> mugOfP = new ArrayList<Double>();
        PVTGCurve gas0 = EclipseBlackOilImporter.findRvZero(pvtg);
        for (double p2 : Pg) {
            if (gas0 != null) {
                double[] bmu = EclipseBlackOilImporter.interpBgMu(gas0, p2);
                BgOfP.add(bmu[0]);
                mugOfP.add(bmu[1]);
                continue;
            }
            BgOfP.add(0.005);
            mugOfP.add(1.0E-5);
        }
        ArrayList<Double> BwOfP = new ArrayList<Double>();
        ArrayList<Double> muwOfP = new ArrayList<Double>();
        for (double p3 : Pg) {
            if (!pvtw.isEmpty()) {
                double[] bwmu = EclipseBlackOilImporter.interpBwMu(pvtw, p3);
                BwOfP.add(bwmu[0]);
                muwOfP.add(bwmu[1]);
                continue;
            }
            BwOfP.add(1.0);
            muwOfP.add(5.0E-4);
        }
        ArrayList<BlackOilPVTTable.Record> recs = new ArrayList<BlackOilPVTTable.Record>();
        for (int i = 0; i < Pg.size(); ++i) {
            recs.add(new BlackOilPVTTable.Record(Pg.get(i), RsOfP.get(i), BoOfP.get(i), muoOfP.get(i), (Double)BgOfP.get(i), (Double)mugOfP.get(i), 0.0, (Double)BwOfP.get(i), (Double)muwOfP.get(i)));
        }
        BlackOilPVTTable table = new BlackOilPVTTable(recs, Pb);
        SystemBlackOil sys = new SystemBlackOil(table, rho_o_sc, rho_g_sc, rho_w_sc);
        sys.setStdTotals(1.0, table.Rs(Pb) * 1.0, 0.0);
        sys.setPressure(Pb);
        sys.setTemperature(350.0);
        Result out = new Result();
        out.pvt = table;
        out.system = sys;
        out.rho_o_sc = rho_o_sc;
        out.rho_w_sc = rho_w_sc;
        out.rho_g_sc = rho_g_sc;
        out.bubblePoint = Pb;
        out.log.add("Units detected: " + (Object)((Object)units));
        out.log.add("PVTO blocks: " + pvto.size());
        out.log.add("PVTG blocks: " + pvtg.size());
        out.log.add("PVTW rows : " + pvtw.size());
        return out;
    }

    private static String stripComments(String s) {
        if (s == null) {
            return "";
        }
        int i = s.indexOf("--");
        if (i >= 0) {
            s = s.substring(0, i);
        }
        return s.replace('\t', ' ').trim();
    }

    private static List<Double> numbersFromLine(String s) {
        String clean = s.replace(',', ' ').replace('\t', ' ').replace("/", " ");
        String[] tok = clean.trim().split("\\s+");
        ArrayList<Double> out = new ArrayList<Double>();
        for (String t : tok) {
            if (t.isEmpty()) continue;
            try {
                out.add(Double.parseDouble(t));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return out;
    }

    private static void sortParallel(List<Double> P, List<Double> Rs, List<Double> Bo, List<Double> mu) {
        ArrayList<Integer> idx = new ArrayList<Integer>();
        for (int i = 0; i < P.size(); ++i) {
            idx.add(i);
        }
        idx.sort(Comparator.comparingDouble(P::get));
        EclipseBlackOilImporter.reorder(P, idx);
        EclipseBlackOilImporter.reorder(Rs, idx);
        EclipseBlackOilImporter.reorder(Bo, idx);
        EclipseBlackOilImporter.reorder(mu, idx);
    }

    private static void reorder(List<Double> a, List<Integer> idx) {
        ArrayList<Double> c = new ArrayList<Double>(a);
        for (int i = 0; i < idx.size(); ++i) {
            a.set(i, c.get(idx.get(i)));
        }
    }

    private static PVTGCurve findRvZero(List<PVTGCurve> pvtg) {
        if (pvtg.isEmpty()) {
            return null;
        }
        PVTGCurve best = null;
        double bestAbs = Double.POSITIVE_INFINITY;
        for (PVTGCurve c : pvtg) {
            double ab = Math.abs(c.Rv);
            if (!(ab < bestAbs)) continue;
            bestAbs = ab;
            best = c;
            if (!(ab < 1.0E-9)) continue;
            break;
        }
        return best;
    }

    private static double[] interpBgMu(PVTGCurve curve, double p) {
        List<PVTGCurve.Row> rows = curve.rows;
        if (rows.isEmpty()) {
            return new double[]{0.005, 1.0E-5};
        }
        rows.sort(Comparator.comparingDouble(r -> r.P));
        if (p <= rows.get((int)0).P) {
            return new double[]{rows.get((int)0).Bg, rows.get((int)0).mu};
        }
        if (p >= rows.get((int)(rows.size() - 1)).P) {
            return new double[]{rows.get((int)(rows.size() - 1)).Bg, rows.get((int)(rows.size() - 1)).mu};
        }
        for (int i = 0; i < rows.size() - 1; ++i) {
            PVTGCurve.Row a = rows.get(i);
            PVTGCurve.Row b = rows.get(i + 1);
            if (!(p >= a.P) || !(p <= b.P)) continue;
            double t = (p - a.P) / (b.P - a.P);
            double Bg = a.Bg * (1.0 - t) + b.Bg * t;
            double mu = a.mu * (1.0 - t) + b.mu * t;
            return new double[]{Bg, mu};
        }
        return new double[]{rows.get((int)(rows.size() - 1)).Bg, rows.get((int)(rows.size() - 1)).mu};
    }

    private static double[] interpBwMu(List<PVTWRow> rows, double p) {
        rows.sort(Comparator.comparingDouble(r -> r.P));
        if (p <= rows.get((int)0).P) {
            return new double[]{rows.get((int)0).Bw, rows.get((int)0).mu};
        }
        if (p >= rows.get((int)(rows.size() - 1)).P) {
            return new double[]{rows.get((int)(rows.size() - 1)).Bw, rows.get((int)(rows.size() - 1)).mu};
        }
        for (int i = 0; i < rows.size() - 1; ++i) {
            PVTWRow a = rows.get(i);
            PVTWRow b = rows.get(i + 1);
            if (!(p >= a.P) || !(p <= b.P)) continue;
            double t = (p - a.P) / (b.P - a.P);
            double Bw = a.Bw * (1.0 - t) + b.Bw * t;
            double mu = a.mu * (1.0 - t) + b.mu * t;
            return new double[]{Bw, mu};
        }
        return new double[]{rows.get((int)(rows.size() - 1)).Bw, rows.get((int)(rows.size() - 1)).mu};
    }

    private static class PVTWRow {
        double P;
        double Bw;
        double mu;

        private PVTWRow() {
        }
    }

    private static class PVTGCurve {
        double Rv;
        final List<Row> rows = new ArrayList<Row>();

        private PVTGCurve() {
        }

        static class Row {
            double P;
            double Bg;
            double mu;

            Row() {
            }
        }
    }

    private static class PVTOCurve {
        double Rs;
        final List<Row> rows = new ArrayList<Row>();

        private PVTOCurve() {
        }

        static class Row {
            double P;
            double Bo;
            double mu;

            Row() {
            }
        }
    }

    public static class Result {
        public BlackOilPVTTable pvt;
        public SystemBlackOil system;
        public double rho_o_sc;
        public double rho_w_sc;
        public double rho_g_sc;
        public double bubblePoint;
        public List<String> log = new ArrayList<String>();
    }

    public static enum Units {
        METRIC,
        FIELD,
        LAB;

    }
}

