/*
 * Decompiled with CFR 0.152.
 */
package neqsim.chemicalreactions;

import Jama.Matrix;
import java.util.HashSet;
import java.util.Iterator;
import neqsim.chemicalreactions.chemicalequilibrium.ChemicalEquilibrium;
import neqsim.chemicalreactions.chemicalequilibrium.LinearProgrammingChemicalEquilibrium;
import neqsim.chemicalreactions.chemicalreaction.ChemicalReactionList;
import neqsim.chemicalreactions.kinetics.Kinetics;
import neqsim.thermo.ThermodynamicConstantsInterface;
import neqsim.thermo.component.ComponentInterface;
import neqsim.thermo.phase.PhaseInterface;
import neqsim.thermo.system.SystemInterface;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ChemicalReactionOperations
implements ThermodynamicConstantsInterface,
Cloneable {
    private static final long serialVersionUID = 1000L;
    static Logger logger = LogManager.getLogger(ChemicalReactionOperations.class);
    SystemInterface system;
    ComponentInterface[] components;
    ChemicalReactionList reactionList = new ChemicalReactionList();
    String[] componentNames;
    String[] allComponentNames;
    String[] elements;
    double[][] Amatrix;
    double[] nVector;
    int iter = 0;
    double[] bVector;
    int phase = 1;
    double[] chemRefPot;
    double[] newMoles;
    double inertMoles = 0.0;
    ChemicalEquilibrium solver;
    double deltaReactionHeat = 0.0;
    boolean firsttime = false;
    Kinetics kineticsSolver;
    LinearProgrammingChemicalEquilibrium initCalc;

    public ChemicalReactionOperations(SystemInterface system) {
        boolean newcomps = true;
        int old = system.getPhase(0).getNumberOfComponents();
        this.system = system;
        while (newcomps) {
            this.componentNames = system.getComponentNames();
            this.reactionList.readReactions(system);
            this.reactionList.removeJunkReactions(this.componentNames);
            this.allComponentNames = this.reactionList.getAllComponents();
            this.addNewComponents();
            if (system.getPhase(0).getNumberOfComponents() == old) {
                newcomps = false;
            }
            old = system.getPhase(0).getNumberOfComponents();
            if (newcomps) continue;
        }
        this.components = new ComponentInterface[this.allComponentNames.length];
        if (this.components.length > 0) {
            this.setReactiveComponents();
            this.reactionList.checkReactions(system.getPhase(1));
            this.chemRefPot = this.calcChemRefPot(1);
            this.elements = this.getAllElements();
            try {
                this.initCalc = new LinearProgrammingChemicalEquilibrium(this.chemRefPot, this.components, this.elements, this, 1);
            }
            catch (Exception ex) {
                logger.error(ex.getMessage(), (Throwable)ex);
            }
            this.setComponents();
            this.Amatrix = this.initCalc.getA();
            this.nVector = this.calcNVector();
            this.bVector = this.calcBVector();
        } else {
            system.isChemicalSystem(false);
        }
        this.kineticsSolver = new Kinetics(this);
    }

    public void setSystem(SystemInterface system) {
        this.system = system;
    }

    public ChemicalReactionOperations clone() {
        ChemicalReactionOperations clonedSystem = null;
        try {
            clonedSystem = (ChemicalReactionOperations)super.clone();
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
        return clonedSystem;
    }

    public void setComponents() {
        for (int j = 0; j < this.components.length; ++j) {
            this.system.getPhase((int)this.phase).getComponents()[this.components[j].getComponentNumber()] = this.components[j];
        }
    }

    public void setComponents(int phaseNum) {
        for (int j = 0; j < this.components.length; ++j) {
            this.system.getPhase((int)phaseNum).getComponents()[this.components[j].getComponentNumber()] = this.components[j];
        }
    }

    public void setReactiveComponents(int phaseNum) {
        for (int j = 0; j < this.components.length; ++j) {
            this.components[j] = this.system.getPhase(phaseNum).getComponent(this.components[j].getComponentNumber());
        }
    }

    public void setReactiveComponents() {
        int k = 0;
        for (int j = 0; j < this.componentNames.length; ++j) {
            String name = this.componentNames[j];
            for (int i = 0; i < this.allComponentNames.length; ++i) {
                if (!name.equals(this.allComponentNames[i])) continue;
                this.components[k++] = this.system.getPhase(this.phase).getComponent(j);
            }
        }
    }

    public double calcInertMoles(int phaseNum) {
        double reactiveMoles = 0.0;
        for (int j = 0; j < this.components.length; ++j) {
            reactiveMoles += this.components[j].getNumberOfMolesInPhase();
        }
        this.inertMoles = this.system.getPhase(phaseNum).getNumberOfMolesInPhase() - reactiveMoles;
        if (this.inertMoles < 0.0) {
            this.inertMoles = 1.0E-30;
        }
        return this.inertMoles;
    }

    public void sortReactiveComponents() {
        for (int i = 0; i < this.components.length; ++i) {
            for (int j = i + 1; j < this.components.length; ++j) {
                if (!(this.components[j].getGibbsEnergyOfFormation() < this.components[i].getGibbsEnergyOfFormation())) continue;
                ComponentInterface tempComp = this.components[i];
                this.components[i] = this.components[j];
                this.components[j] = tempComp;
            }
        }
    }

    public void addNewComponents() {
        for (int i = 0; i < this.allComponentNames.length; ++i) {
            String name = this.allComponentNames[i];
            boolean newComp = true;
            for (int j = 0; j < this.componentNames.length; ++j) {
                if (!name.equals(this.componentNames[j])) continue;
                newComp = false;
                break;
            }
            if (!newComp) continue;
            this.system.addComponent(name, 1.0E-40);
        }
    }

    public String[] getAllElements() {
        HashSet<String> elementsLocal = new HashSet<String>();
        for (int j = 0; j < this.components.length; ++j) {
            for (int i = 0; i < this.components[j].getElements().getElementNames().length; ++i) {
                elementsLocal.add(this.components[j].getElements().getElementNames()[i]);
            }
        }
        String[] elementList = new String[elementsLocal.size()];
        int k = 0;
        Iterator newe = elementsLocal.iterator();
        while (newe.hasNext()) {
            elementList[k++] = (String)newe.next();
        }
        return elementList;
    }

    public boolean hasReactions() {
        return this.components.length > 0;
    }

    public double[] calcNVector() {
        double[] nvec = new double[this.components.length];
        for (int i = 0; i < this.components.length; ++i) {
            nvec[i] = this.components[i].getNumberOfMolesInPhase();
        }
        return nvec;
    }

    public double[] calcBVector() {
        Matrix tempA = new Matrix(this.Amatrix);
        Matrix tempB = new Matrix(this.nVector, 1);
        Matrix tempN = tempA.times(tempB.transpose()).transpose();
        return tempN.getArray()[0];
    }

    public double[] calcChemRefPot(int phaseNum) {
        double[] referencePotentials = new double[this.components.length];
        this.reactionList.createReactionMatrix(this.system.getPhase(phaseNum), this.components);
        double[] newreferencePotentials = this.reactionList.updateReferencePotentials(this.system.getPhase(phaseNum), this.components);
        if (newreferencePotentials != null) {
            for (int i = 0; i < newreferencePotentials.length; ++i) {
                referencePotentials[i] = newreferencePotentials[i];
                this.components[i].setReferencePotential(referencePotentials[i]);
            }
            return referencePotentials;
        }
        return null;
    }

    public void updateMoles(int phaseNum) {
        double changeMoles = 0.0;
        for (int i = 0; i < this.components.length; ++i) {
            if (!(Math.abs(this.newMoles[i]) > 1.0E-45)) continue;
            changeMoles += this.newMoles[i] - this.system.getPhase(phaseNum).getComponents()[this.components[i].getComponentNumber()].getNumberOfMolesInPhase();
            this.system.getPhase(phaseNum).addMolesChemReac(this.components[i].getComponentNumber(), this.newMoles[i] - this.system.getPhase(phaseNum).getComponents()[this.components[i].getComponentNumber()].getNumberOfMolesInPhase());
        }
        this.system.initTotalNumberOfMoles(changeMoles);
        this.system.initBeta();
        this.system.init_x_y();
        this.system.init(1);
    }

    public boolean solveChemEq(int type) {
        return this.solveChemEq(1, type);
    }

    public boolean solveChemEq(int phaseNum, int type) {
        if (this.phase != phaseNum) {
            this.setReactiveComponents(phaseNum);
            this.chemRefPot = this.calcChemRefPot(phaseNum);
        }
        this.phase = phaseNum;
        if (!this.system.isChemicalSystem()) {
            System.out.println("no chemical reactions will occur...continue");
            return false;
        }
        this.calcChemRefPot(phaseNum);
        if (this.firsttime || type == 0) {
            try {
                this.nVector = this.calcNVector();
                this.bVector = this.calcBVector();
                this.calcInertMoles(phaseNum);
                this.newMoles = this.initCalc.generateInitialEstimates(this.system, this.bVector, this.inertMoles, phaseNum);
                this.updateMoles(phaseNum);
                this.firsttime = false;
                return true;
            }
            catch (Exception ex) {
                logger.error("error in chem eq", (Throwable)ex);
                this.solver = new ChemicalEquilibrium(this.Amatrix, this.bVector, this.system, this.components, phaseNum);
                return this.solver.solve();
            }
        }
        this.nVector = this.calcNVector();
        this.bVector = this.calcBVector();
        try {
            this.solver = new ChemicalEquilibrium(this.Amatrix, this.bVector, this.system, this.components, phaseNum);
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
        return this.solver.solve();
    }

    public double solveKinetics(int phaseNum, PhaseInterface interPhase, int component) {
        return this.kineticsSolver.calcReacMatrix(this.system.getPhase(phaseNum), interPhase, component);
    }

    public Kinetics getKinetics() {
        return this.kineticsSolver;
    }

    public ChemicalReactionList getReactionList() {
        return this.reactionList;
    }

    public double reacHeat(int phaseNum, String component) {
        return this.reactionList.reacHeat(this.system.getPhase(phaseNum), component);
    }

    public double getDeltaReactionHeat() {
        return this.deltaReactionHeat;
    }

    public void setDeltaReactionHeat(double deltaReactionHeat) {
        this.deltaReactionHeat = deltaReactionHeat;
    }
}

