/*
 * Decompiled with CFR 0.152.
 */
package neqsim.chemicalreactions.chemicalreaction;

import java.sql.ResultSet;
import java.util.ArrayList;
import neqsim.chemicalreactions.chemicalreaction.ChemicalReaction;
import neqsim.util.database.NeqSimDataBase;
import neqsim.util.exception.InvalidInputException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class ChemicalReactionFactory {
    static Logger logger = LogManager.getLogger(ChemicalReactionFactory.class);

    private ChemicalReactionFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ChemicalReaction getChemicalReaction(String name) {
        ArrayList<String> names = new ArrayList<String>();
        ArrayList<String> stocCoef = new ArrayList<String>();
        double[] K = new double[4];
        double refT = 0.0;
        double rateFactor = 0.0;
        double activationEnergy = 0.0;
        try (NeqSimDataBase database = new NeqSimDataBase();
             ResultSet dataSet = database.getResultSet("SELECT * FROM reactiondata where name='" + name + "'");){
            if (!dataSet.next()) throw new RuntimeException(new InvalidInputException("ChemicalReactionFactory", "getChemicalReaction", "reacname", "- found no data in table REACTIONDATA for component named " + name));
            String reacname = dataSet.getString("name");
            K[0] = Double.parseDouble(dataSet.getString("K1"));
            K[1] = Double.parseDouble(dataSet.getString("K2"));
            K[2] = Double.parseDouble(dataSet.getString("K3"));
            K[3] = Double.parseDouble(dataSet.getString("K4"));
            refT = Double.parseDouble(dataSet.getString("Tref"));
            rateFactor = Double.parseDouble(dataSet.getString("r"));
            activationEnergy = Double.parseDouble(dataSet.getString("ACTENERGY"));
            try {
                block41: {
                    ResultSet dataSet2;
                    block42: {
                        dataSet2 = database.getResultSet("SELECT * FROM stoccoefdata where reacname='" + reacname + "'");
                        Throwable throwable = null;
                        try {
                            while (dataSet2.next()) {
                                names.add(dataSet2.getString("compname").trim());
                                stocCoef.add(dataSet2.getString("stoccoef").trim());
                            }
                            if (dataSet2 == null) break block41;
                            if (throwable == null) break block42;
                        }
                        catch (Throwable throwable3) {
                            try {
                                throwable = throwable3;
                                throw throwable3;
                            }
                            catch (Throwable throwable4) {
                                if (dataSet2 == null) throw throwable4;
                                if (throwable == null) {
                                    dataSet2.close();
                                    throw throwable4;
                                }
                                try {
                                    dataSet2.close();
                                    throw throwable4;
                                }
                                catch (Throwable throwable5) {
                                    throwable.addSuppressed(throwable5);
                                    throw throwable4;
                                }
                            }
                        }
                        try {
                            dataSet2.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    dataSet2.close();
                }
            }
            finally {
                if (names.size() == 0) {
                    throw new RuntimeException(new InvalidInputException("ChemicalReactionFactory", "getChemicalReaction", "reacname", "- found no data in table stoccoefdata for component named " + reacname));
                }
            }
        }
        catch (Exception ex) {
            logger.error("Failed getting data from REACTIONDATA for component named " + name + ":\n\t" + ex.getMessage());
        }
        String[] nameArray = new String[names.size()];
        double[] stocCoefArray = new double[names.size()];
        int i = 0;
        while (i < names.size()) {
            nameArray[i] = (String)names.get(i);
            stocCoefArray[i] = Double.parseDouble((String)stocCoef.get(i));
            ++i;
        }
        return new ChemicalReaction(name, nameArray, stocCoefArray, K, rateFactor, activationEnergy, refT);
    }

    public static String[] getChemicalReactionNames() {
        ArrayList<String> nameList = new ArrayList<String>();
        try (NeqSimDataBase database = new NeqSimDataBase();
             ResultSet dataSet = database.getResultSet("SELECT name FROM REACTIONDATA");){
            dataSet.next();
            do {
                nameList.add(dataSet.getString("name").trim());
            } while (dataSet.next());
        }
        catch (Exception ex) {
            logger.error("Failed reading from database.");
        }
        return nameList.toArray(new String[0]);
    }
}

