/*
 * Decompiled with CFR 0.152.
 */
package neqsim.datapresentation;

import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.text.DecimalFormat;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DataHandling {
    static Logger logger = LogManager.getLogger(DataHandling.class);

    public int getItemCount(int series) {
        return 81;
    }

    public int getLegendItemCount() {
        return 2;
    }

    public String[] getLegendItemLabels() {
        String[] str = new String[2];
        str[1] = "";
        str[2] = "";
        return str;
    }

    public int getSeriesCount() {
        return 2;
    }

    public String getSeriesName(int series) {
        if (series == 0) {
            return "y = cosine(x)";
        }
        if (series == 1) {
            return "y = 2*sine(x)";
        }
        return "Error";
    }

    public Number getXValue(int series, int item) {
        return -10.0 + (double)item * 0.2;
    }

    public Number getYValue(int series, int item) {
        if (series == 0) {
            return Math.cos(-10.0 + (double)item * 0.2);
        }
        return 2.0 * Math.sin(-10.0 + (double)item * 0.2);
    }

    public void printToFile(double[][] points, String filename) {
        DecimalFormat nf = new DecimalFormat();
        nf.setMaximumFractionDigits(5);
        nf.applyPattern("#.####E0");
        try (DataOutputStream rt = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(new File("c:/temp/" + filename))));){
            for (int i = 0; i < points.length; ++i) {
                for (int j = 0; j < points[i].length; ++j) {
                    rt.writeBytes(nf.format(points[i][j]) + "\t");
                    if (j != points[i].length - 1) continue;
                    rt.writeBytes("\n");
                }
            }
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
    }
}

