/*
 * Decompiled with CFR 0.152.
 */
package neqsim.fluidmechanics.flownode.fluidboundary.heatmasstransfercalc.nonequilibriumfluidboundary.filmmodelboundary;

import Jama.Matrix;
import neqsim.fluidmechanics.flownode.FlowNodeInterface;
import neqsim.fluidmechanics.flownode.fluidboundary.heatmasstransfercalc.nonequilibriumfluidboundary.NonEquilibriumFluidBoundary;
import neqsim.fluidmechanics.flownode.twophasenode.twophasepipeflownode.AnnularFlow;
import neqsim.fluidmechanics.geometrydefinitions.pipe.PipeData;
import neqsim.thermo.ThermodynamicConstantsInterface;
import neqsim.thermo.system.SystemInterface;
import neqsim.thermo.system.SystemSrkEos;
import neqsim.thermodynamicoperations.ThermodynamicOperations;
import neqsim.util.ExcludeFromJacocoGeneratedReport;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class KrishnaStandartFilmModel
extends NonEquilibriumFluidBoundary
implements ThermodynamicConstantsInterface {
    private static final long serialVersionUID = 1000L;
    static Logger logger = LogManager.getLogger(KrishnaStandartFilmModel.class);
    Matrix phiMatrix;
    Matrix redPhiMatrix;
    Matrix redCorrectionMatrix;
    Matrix betaMatrix;

    public KrishnaStandartFilmModel(SystemInterface system) {
        super(system);
        this.binaryMassTransferCoefficient = new double[2][this.getBulkSystem().getPhases()[0].getNumberOfComponents()][this.getBulkSystem().getPhases()[0].getNumberOfComponents()];
        this.binarySchmidtNumber = new double[2][this.getBulkSystem().getPhases()[0].getNumberOfComponents()][this.getBulkSystem().getPhases()[0].getNumberOfComponents()];
        this.uMassTrans = new Matrix(this.neq, 1);
        this.Xgij = new Matrix(this.neq, 4);
        this.setuMassTrans();
        this.uMassTransold = this.uMassTrans.copy();
    }

    public KrishnaStandartFilmModel(FlowNodeInterface flowNode) {
        super(flowNode);
        this.binaryMassTransferCoefficient = new double[2][this.getBulkSystem().getPhases()[0].getNumberOfComponents()][this.getBulkSystem().getPhases()[0].getNumberOfComponents()];
        this.binarySchmidtNumber = new double[2][this.getBulkSystem().getPhases()[0].getNumberOfComponents()][this.getBulkSystem().getPhases()[0].getNumberOfComponents()];
        this.uMassTrans = new Matrix(this.neq, 1);
        this.Xgij = new Matrix(this.neq, 4);
        this.setuMassTrans();
        this.uMassTransold = this.uMassTrans.copy();
        this.phiMatrix = new Matrix(this.getBulkSystem().getPhases()[0].getNumberOfComponents() - 1, this.getBulkSystem().getPhases()[0].getNumberOfComponents() - 1);
        this.redCorrectionMatrix = new Matrix(this.getBulkSystem().getPhases()[0].getNumberOfComponents() - 1, 1);
    }

    @Override
    public KrishnaStandartFilmModel clone() {
        KrishnaStandartFilmModel clonedSystem = null;
        try {
            clonedSystem = (KrishnaStandartFilmModel)super.clone();
        }
        catch (Exception ex) {
            logger.error(ex.getMessage());
        }
        return clonedSystem;
    }

    public double calcBinarySchmidtNumbers(int phaseNum) {
        for (int i = 0; i < this.getBulkSystem().getPhase(phaseNum).getNumberOfComponents(); ++i) {
            for (int j = 0; j < this.getBulkSystem().getPhase(phaseNum).getNumberOfComponents(); ++j) {
                this.binarySchmidtNumber[phaseNum][i][j] = this.getBulkSystem().getPhase(phaseNum).getPhysicalProperties().getKinematicViscosity() / this.getBulkSystem().getPhase(phaseNum).getPhysicalProperties().getDiffusionCoefficient(i, j);
            }
        }
        return 1.0;
    }

    public double calcBinaryMassTransferCoefficients(int phaseNum) {
        for (int i = 0; i < this.getBulkSystem().getPhase(phaseNum).getNumberOfComponents(); ++i) {
            for (int j = 0; j < this.getBulkSystem().getPhase(phaseNum).getNumberOfComponents(); ++j) {
                this.binaryMassTransferCoefficient[phaseNum][i][j] = this.flowNode.getInterphaseTransportCoefficient().calcInterphaseMassTransferCoefficient(phaseNum, this.binarySchmidtNumber[phaseNum][i][j], this.flowNode);
            }
        }
        return 1.0;
    }

    public double calcMassTransferCoefficients(int phaseNum) {
        int n = this.getBulkSystem().getPhase(phaseNum).getNumberOfComponents() - 1;
        for (int i = 0; i < this.getBulkSystem().getPhase(phaseNum).getNumberOfComponents() - 1; ++i) {
            double tempVar = 0.0;
            for (int j = 0; j < this.getBulkSystem().getPhase(phaseNum).getNumberOfComponents(); ++j) {
                if (i != j) {
                    tempVar += this.getBulkSystem().getPhase(phaseNum).getComponent(j).getx() / this.binaryMassTransferCoefficient[phaseNum][i][j];
                }
                if (j >= n) continue;
                this.massTransferCoefficientMatrix[phaseNum].set(i, j, -this.getBulkSystem().getPhase(phaseNum).getComponent(i).getx() * (1.0 / this.binaryMassTransferCoefficient[phaseNum][i][j] - 1.0 / this.binaryMassTransferCoefficient[phaseNum][i][n]));
            }
            this.massTransferCoefficientMatrix[phaseNum].set(i, i, tempVar + this.getBulkSystem().getPhase(phaseNum).getComponent(i).getx() / this.binaryMassTransferCoefficient[phaseNum][i][n]);
        }
        this.massTransferCoefficientMatrix[phaseNum] = this.massTransferCoefficientMatrix[phaseNum].inverse();
        return 1.0;
    }

    public void calcPhiMatrix(int phaseNum) {
        int n = this.getBulkSystem().getPhase(phaseNum).getNumberOfComponents() - 1;
        for (int i = 0; i < this.getBulkSystem().getPhase(phaseNum).getNumberOfComponents() - 1; ++i) {
            double tempVar = 0.0;
            for (int j = 0; j < this.getBulkSystem().getPhase(phaseNum).getNumberOfComponents(); ++j) {
                if (i != j || i == n) {
                    tempVar += this.nFlux.get(i, 0) / (1.0 / (this.getBulkSystem().getPhase(phaseNum).getMolarVolume() * 1.0E-5) * this.binaryMassTransferCoefficient[phaseNum][i][j]);
                }
                if (j >= n) continue;
                this.phiMatrix.set(i, j, -this.nFlux.get(i, 0) * (1.0 / (1.0 / (this.getBulkSystem().getPhase(phaseNum).getMolarVolume() * 1.0E-5) * this.binaryMassTransferCoefficient[phaseNum][i][j]) - 1.0 / (1.0 / (this.getBulkSystem().getPhase(phaseNum).getMolarVolume() * 1.0E-5) * this.binaryMassTransferCoefficient[phaseNum][i][n])));
            }
            this.phiMatrix.set(i, i, tempVar + this.nFlux.get(i, 0) / (1.0 / (this.getBulkSystem().getPhase(phaseNum).getMolarVolume() * 1.0E-5) * this.binaryMassTransferCoefficient[phaseNum][i][n]));
        }
    }

    public void calcRedPhiMatrix(int phase) {
        this.redPhiMatrix = new Matrix(this.phiMatrix.eig().getRealEigenvalues(), 1);
    }

    public void calcRedCorrectionMatrix(int phaseNum) {
        for (int i = 0; i < this.getBulkSystem().getPhase(phaseNum).getNumberOfComponents() - 1; ++i) {
            this.redCorrectionMatrix.set(i, 0, this.redPhiMatrix.get(0, i) * Math.exp(this.redPhiMatrix.get(0, i)) / (Math.exp(this.redPhiMatrix.get(0, i)) - 0.999999999999999));
        }
    }

    public void calcCorrectionMatrix(int phaseNum) {
        Matrix modalPhiMatrix = this.phiMatrix.eig().getV();
        Matrix diagonalRedCorrectionMatrix = new Matrix(this.getBulkSystem().getPhase(phaseNum).getNumberOfComponents() - 1, this.getBulkSystem().getPhase(phaseNum).getNumberOfComponents() - 1);
        for (int i = 0; i < this.getBulkSystem().getPhase(phaseNum).getNumberOfComponents() - 1; ++i) {
            diagonalRedCorrectionMatrix.set(i, i, this.redCorrectionMatrix.get(i, 0));
        }
        this.rateCorrectionMatrix[phaseNum] = modalPhiMatrix.times(diagonalRedCorrectionMatrix.times(modalPhiMatrix.inverse()));
    }

    public void calcTotalMassTransferCoefficientMatrix(int phase) {
        this.totalMassTransferCoefficientMatrix[phase] = this.massTransferCoefficientMatrix[phase];
        this.totalMassTransferCoefficientMatrix[phase] = Math.abs(this.totalFlux) > 1.0E-30 ? (this.useFiniteFluxCorrection(phase) && this.useThermodynamicCorrections(phase) ? this.rateCorrectionMatrix[phase].times(this.nonIdealCorrections[phase].times(this.massTransferCoefficientMatrix[phase])) : (this.useFiniteFluxCorrection(phase) ? this.rateCorrectionMatrix[phase].times(this.massTransferCoefficientMatrix[phase]) : (this.useThermodynamicCorrections(phase) ? this.massTransferCoefficientMatrix[phase].times(this.nonIdealCorrections[phase]) : this.massTransferCoefficientMatrix[phase]))) : this.massTransferCoefficientMatrix[phase];
    }

    public void initCorrections(int phase) {
        this.calcPhiMatrix(phase);
        this.calcRedPhiMatrix(phase);
        this.calcRedCorrectionMatrix(phase);
        this.calcCorrectionMatrix(phase);
    }

    @Override
    public void initMassTransferCalc() {
        super.initMassTransferCalc();
        for (int phaseNum = 0; phaseNum < 2; ++phaseNum) {
            this.calcBinarySchmidtNumbers(phaseNum);
            this.calcBinaryMassTransferCoefficients(phaseNum);
            this.calcMassTransferCoefficients(phaseNum);
            this.initCorrections(phaseNum);
            this.calcNonIdealCorrections(phaseNum);
            this.calcTotalMassTransferCoefficientMatrix(phaseNum);
        }
    }

    @Override
    public void initHeatTransferCalc() {
        super.initHeatTransferCalc();
        for (int phaseNum = 0; phaseNum < 2; ++phaseNum) {
            this.calcHeatTransferCoefficients(phaseNum);
            this.calcHeatTransferCorrection(phaseNum);
        }
    }

    @Override
    public void init() {
        super.init();
        if (this.massTransferCalc) {
            this.initMassTransferCalc();
        }
        if (this.heatTransferCalc) {
            this.initHeatTransferCalc();
        }
    }

    @Override
    public void solve() {
        super.solve();
    }

    @ExcludeFromJacocoGeneratedReport
    public static void main(String[] args) {
        System.out.println("Starter.....");
        SystemSrkEos testSystem = new SystemSrkEos(295.3, 3.0);
        ThermodynamicOperations testOps = new ThermodynamicOperations(testSystem);
        PipeData pipe1 = new PipeData(0.1, 0.025);
        testSystem.addComponent("methane", 0.0071152181, 0);
        testSystem.addComponent("ethane", 0.0071152181, 0);
        testSystem.addComponent("water", 0.00362204876, 1);
        testSystem.createDatabase(true);
        testSystem.setMixingRule(2);
        testSystem.initPhysicalProperties();
        AnnularFlow test = new AnnularFlow(testSystem, pipe1);
        test.initFlowCalc();
        test.init();
        KrishnaStandartFilmModel test2 = new KrishnaStandartFilmModel(test);
        test2.solve();
        test2.calcFluxes();
        test2.getInterphaseSystem().display();
        test2.display("");
    }
}

