/*
 * Decompiled with CFR 0.152.
 */
package neqsim.fluidmechanics.flownode.fluidboundary.interphasetransportcoefficient.interphasetwophase.stirredcell;

import neqsim.fluidmechanics.flownode.FlowNodeInterface;
import neqsim.fluidmechanics.flownode.fluidboundary.interphasetransportcoefficient.interphasetwophase.interphasepipeflow.InterphaseStratifiedFlow;

public class InterphaseStirredCellFlow
extends InterphaseStratifiedFlow {
    private static final long serialVersionUID = 1000L;

    public InterphaseStirredCellFlow() {
    }

    public InterphaseStirredCellFlow(FlowNodeInterface node) {
    }

    @Override
    public double calcWallHeatTransferCoefficient(int phaseNum, double prandtlNumber, FlowNodeInterface node) {
        if (Math.abs(node.getReynoldsNumber(phaseNum)) < 2000.0) {
            return 3.66 / node.getHydraulicDiameter(phaseNum) * node.getBulkSystem().getPhase(phaseNum).getPhysicalProperties().getConductivity();
        }
        double temp = node.getBulkSystem().getPhase(phaseNum).getCp() / node.getBulkSystem().getPhase(phaseNum).getMolarMass() / node.getBulkSystem().getPhase(phaseNum).getNumberOfMolesInPhase() * node.getBulkSystem().getPhase(phaseNum).getPhysicalProperties().getDensity() * node.getVelocity(phaseNum);
        return 0.5 * this.calcWallFrictionFactor(phaseNum, node) * Math.pow(prandtlNumber, -0.6666666666666666) * temp;
    }

    @Override
    public double calcInterphaseHeatTransferCoefficient(int phaseNum, double prandtlNumber, FlowNodeInterface node) {
        if (Math.abs(node.getReynoldsNumber()) < 2000.0) {
            return 3.66 / node.getHydraulicDiameter(phaseNum) * node.getBulkSystem().getPhase(phaseNum).getPhysicalProperties().getConductivity();
        }
        double temp = node.getBulkSystem().getPhase(phaseNum).getCp() / node.getBulkSystem().getPhase(phaseNum).getMolarMass() / node.getBulkSystem().getPhase(phaseNum).getNumberOfMolesInPhase() * node.getBulkSystem().getPhase(phaseNum).getPhysicalProperties().getDensity() * node.getVelocity(phaseNum);
        return 0.5 * this.calcWallFrictionFactor(phaseNum, node) * Math.pow(prandtlNumber, -0.6666666666666666) * temp;
    }

    @Override
    public double calcWallMassTransferCoefficient(int phaseNum, double schmidtNumber, FlowNodeInterface node) {
        if (Math.abs(node.getReynoldsNumber()) < 2000.0) {
            return 3.66 / node.getHydraulicDiameter(phaseNum) / schmidtNumber * node.getBulkSystem().getPhase(phaseNum).getPhysicalProperties().getKinematicViscosity();
        }
        double temp = node.getVelocity(phaseNum);
        return 0.5 * this.calcWallFrictionFactor(phaseNum, node) * Math.pow(schmidtNumber, -0.6666666666666666) * temp;
    }

    @Override
    public double calcInterphaseMassTransferCoefficient(int phaseNum, double schmidtNumber, FlowNodeInterface node) {
        double c4;
        double c3;
        double c2;
        double redMassTrans = 0.0;
        double massTrans = 0.0;
        if (phaseNum == 0) {
            c2 = 0.46;
            c3 = 0.68;
            c4 = 0.5;
            redMassTrans = c2 * Math.pow(node.getReynoldsNumber(phaseNum), c3) * Math.pow(schmidtNumber, c4);
            massTrans = redMassTrans * node.getBulkSystem().getPhase(phaseNum).getPhysicalProperties().getKinematicViscosity() / schmidtNumber / node.getGeometry().getDiameter();
        }
        if (phaseNum == 1) {
            c2 = 0.181;
            c3 = 0.72;
            c4 = 0.33;
            redMassTrans = c2 * Math.pow(node.getReynoldsNumber(phaseNum), c3) * Math.pow(schmidtNumber, c4);
            massTrans = redMassTrans * node.getBulkSystem().getPhase(phaseNum).getPhysicalProperties().getKinematicViscosity() / schmidtNumber / node.getGeometry().getDiameter();
        }
        return massTrans;
    }
}

