/*
 * Decompiled with CFR 0.152.
 */
package neqsim.fluidmechanics.flowsolver.twophaseflowsolver.twophasepipeflowsolver;

import Jama.Matrix;
import neqsim.fluidmechanics.flowsolver.onephaseflowsolver.OnePhaseFlowSolver;
import neqsim.fluidmechanics.flowsystem.FlowSystemInterface;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TwoPhasePipeFlowSolver
extends OnePhaseFlowSolver {
    private static final long serialVersionUID = 1000L;
    static Logger logger = LogManager.getLogger(TwoPhasePipeFlowSolver.class);
    protected double[] PbArray;
    protected Matrix[] solMatrix;
    protected Matrix[][] solMolFracMatrix;
    protected Matrix[] solPhaseConsMatrix;
    protected Matrix sol2Matrix;
    protected Matrix[] sol3Matrix;
    protected Matrix[] sol4Matrix;
    protected double[] a;
    protected double[] b;
    protected double[] c;
    protected double[] r;
    protected double length;
    protected FlowSystemInterface pipe;
    protected int numberOfNodes;

    public TwoPhasePipeFlowSolver() {
    }

    public TwoPhasePipeFlowSolver(FlowSystemInterface pipe, double length, int nodes) {
        this.pipe = pipe;
        this.length = length;
        this.numberOfNodes = nodes;
        this.PbArray = new double[nodes];
        this.solMatrix = new Matrix[2];
        this.sol3Matrix = new Matrix[2];
        this.solPhaseConsMatrix = new Matrix[2];
        this.solMolFracMatrix = new Matrix[2][pipe.getNode(0).getBulkSystem().getPhases()[0].getNumberOfComponents()];
        this.solMatrix[0] = new Matrix(this.PbArray, 1).transpose();
        this.solMatrix[1] = new Matrix(this.PbArray, 1).transpose();
        for (int phaseNum = 0; phaseNum < 2; ++phaseNum) {
            for (int i = 0; i < pipe.getNode(0).getBulkSystem().getPhases()[0].getNumberOfComponents(); ++i) {
                this.solMolFracMatrix[phaseNum][i] = new Matrix(this.PbArray, 1).transpose();
            }
        }
        this.sol3Matrix[0] = new Matrix(this.PbArray, 1).transpose();
        this.sol3Matrix[1] = new Matrix(this.PbArray, 1).transpose();
        this.solPhaseConsMatrix[0] = new Matrix(this.PbArray, 1).transpose();
        this.solPhaseConsMatrix[1] = new Matrix(this.PbArray, 1).transpose();
        this.sol2Matrix = new Matrix(this.PbArray, 1).transpose();
        this.a = new double[nodes];
        this.b = new double[nodes];
        this.c = new double[nodes];
        this.r = new double[nodes];
    }

    public TwoPhasePipeFlowSolver clone() {
        TwoPhasePipeFlowSolver clonedSystem = null;
        try {
            clonedSystem = (TwoPhasePipeFlowSolver)super.clone();
        }
        catch (Exception ex) {
            logger.error(ex.getMessage());
        }
        return clonedSystem;
    }
}

