/*
 * Decompiled with CFR 0.152.
 */
package neqsim.fluidmechanics.flowsystem;

import java.io.Serializable;
import java.util.UUID;
import neqsim.fluidmechanics.flowleg.FlowLegInterface;
import neqsim.fluidmechanics.flownode.FlowNodeInterface;
import neqsim.fluidmechanics.flowsolver.FlowSolverInterface;
import neqsim.fluidmechanics.flowsystem.FlowSystemInterface;
import neqsim.fluidmechanics.geometrydefinitions.GeometryDefinitionInterface;
import neqsim.fluidmechanics.util.fluidmechanicsvisualization.flowsystemvisualization.FlowSystemVisualizationInterface;
import neqsim.fluidmechanics.util.timeseries.TimeSeries;
import neqsim.thermo.system.SystemInterface;
import neqsim.thermodynamicoperations.ThermodynamicOperations;

public abstract class FlowSystem
implements FlowSystemInterface,
Serializable {
    private static final long serialVersionUID = 1000L;
    protected UUID calcIdentifier;
    protected FlowNodeInterface[] flowNode;
    protected FlowLegInterface[] flowLeg;
    protected String initFlowPattern = "annular";
    protected FlowSystemVisualizationInterface display;
    protected TimeSeries timeSeries = new TimeSeries();
    protected GeometryDefinitionInterface[] equipmentGeometry;
    protected SystemInterface thermoSystem;
    protected ThermodynamicOperations thermoOperations;
    protected double inletTemperature = 0.0;
    protected double inletPressure = 0.0;
    protected double endPressure = 0.0;
    protected double systemLength = 0.0;
    protected int numberOfFlowLegs = 0;
    protected int totalNumberOfNodes = 25;
    int[] numberOfNodesInLeg;
    double[] legHeights;
    double[] legPositions;
    double[] legOuterTemperatures;
    double[] legOuterHeatTransferCoefficients;
    double[] legWallHeatTransferCoefficients;
    protected FlowSolverInterface flowSolver;
    double inletMolarLiquidFlowRate = 0.0;
    double inletMolarGasFlowRate = 0.0;
    boolean equilibriumHeatTransfer = true;
    boolean equilibriumMassTransfer = false;

    public FlowSystem() {
    }

    public FlowSystem(SystemInterface system) {
        this.setInletThermoSystem(system);
    }

    @Override
    public void init() {
    }

    @Override
    public void createSystem() {
        this.thermoOperations = new ThermodynamicOperations(this.thermoSystem);
        this.flowLegInit();
    }

    @Override
    public FlowSolverInterface getSolver() {
        return this.flowSolver;
    }

    @Override
    public TimeSeries getTimeSeries() {
        return this.timeSeries;
    }

    public void flowLegInit() {
        for (int i = 0; i < this.numberOfFlowLegs; ++i) {
            this.flowLeg[i].setThermoSystem(this.thermoSystem);
            this.flowLeg[i].setEquipmentGeometry(this.equipmentGeometry[i]);
            this.flowLeg[i].setNumberOfNodes(this.numberOfNodesInLeg[i]);
            this.flowLeg[i].setHeightCoordinates(this.legHeights[i], this.legHeights[i + 1]);
            this.flowLeg[i].setOuterTemperatures(this.legOuterTemperatures[i], this.legOuterTemperatures[i + 1]);
            this.flowLeg[i].setLongitudionalCoordinates(this.legPositions[i], this.legPositions[i + 1]);
            this.flowLeg[i].setOuterHeatTransferCoefficients(this.legOuterHeatTransferCoefficients[i], this.legOuterHeatTransferCoefficients[i + 1]);
            this.flowLeg[i].setWallHeatTransferCoefficients(this.legWallHeatTransferCoefficients[i], this.legWallHeatTransferCoefficients[i + 1]);
            this.flowLeg[i].createFlowNodes(this.flowNode[0]);
        }
        this.totalNumberOfNodes = this.calcTotalNumberOfNodes();
    }

    @Override
    public void setNodes() {
        this.flowNode[0].setDistanceToCenterOfNode(0.0);
        this.flowNode[0].setVerticalPositionOfNode(this.legHeights[0]);
        this.flowNode[0].setLengthOfNode(this.systemLength / 1000.0);
        this.flowNode[0].init();
        int k = 1;
        for (int i = 0; i < this.numberOfFlowLegs; ++i) {
            for (int j = 0; j < this.getNumberOfNodesInLeg(i); ++j) {
                this.flowNode[k++] = this.flowLeg[i].getNode(j);
            }
        }
        this.flowNode[this.totalNumberOfNodes - 1] = this.flowNode[this.totalNumberOfNodes - 2].getNextNode();
        this.flowNode[this.totalNumberOfNodes - 1].setLengthOfNode(this.systemLength / 1000.0);
        this.flowNode[this.totalNumberOfNodes - 1].setDistanceToCenterOfNode(this.legPositions[this.numberOfFlowLegs] + this.flowNode[this.totalNumberOfNodes - 1].getLengthOfNode() / 2.0);
        this.flowNode[this.totalNumberOfNodes - 1].setVerticalPositionOfNode(this.legHeights[this.numberOfFlowLegs]);
        if (this.endPressure != 0.0) {
            this.flowNode[this.totalNumberOfNodes - 1].getBulkSystem().setPressure(this.endPressure);
        }
        this.flowNode[this.totalNumberOfNodes - 1].init();
    }

    @Override
    public void setInletThermoSystem(SystemInterface thermoSystem) {
        this.thermoSystem = thermoSystem;
        this.inletPressure = thermoSystem.getPressure();
        this.inletTemperature = thermoSystem.getTemperature();
    }

    @Override
    public double getSystemLength() {
        return this.systemLength;
    }

    public int calcTotalNumberOfNodes() {
        int number = 0;
        for (int i = 0; i < this.numberOfFlowLegs; ++i) {
            number += this.flowLeg[i].getNumberOfNodes();
        }
        this.totalNumberOfNodes = number + 2;
        return this.totalNumberOfNodes;
    }

    @Override
    public int getTotalNumberOfNodes() {
        return this.totalNumberOfNodes;
    }

    @Override
    public double getInletTemperature() {
        return this.inletTemperature;
    }

    @Override
    public void setEquipmentGeometry(GeometryDefinitionInterface[] equipmentGeometry) {
        this.equipmentGeometry = equipmentGeometry;
    }

    @Override
    public void setEndPressure(double endPressure) {
        this.endPressure = endPressure;
    }

    @Override
    public double getInletPressure() {
        return this.inletPressure;
    }

    @Override
    public void setNumberOfLegs(int numberOfFlowLegs) {
        this.numberOfFlowLegs = numberOfFlowLegs;
    }

    @Override
    public FlowNodeInterface getNode(int i) {
        return this.flowNode[i];
    }

    @Override
    public FlowNodeInterface[] getFlowNodes() {
        return this.flowNode;
    }

    @Override
    public int getNumberOfLegs() {
        return this.numberOfFlowLegs;
    }

    @Override
    public FlowSystemVisualizationInterface getDisplay() {
        return this.display;
    }

    @Override
    public void setNumberOfNodesInLeg(int numberOfNodesInLeg) {
        this.numberOfNodesInLeg = new int[this.getNumberOfLegs()];
        for (int i = 0; i < this.getNumberOfLegs(); ++i) {
            this.numberOfNodesInLeg[i] = numberOfNodesInLeg;
        }
        this.totalNumberOfNodes = numberOfNodesInLeg * this.getNumberOfLegs() + 2;
    }

    @Override
    public int getNumberOfNodesInLeg(int i) {
        return this.numberOfNodesInLeg[i];
    }

    @Override
    public void setLegHeights(double[] legHeights) {
        this.legHeights = legHeights;
    }

    @Override
    public void setLegPositions(double[] legPositions) {
        this.legPositions = legPositions;
        this.systemLength = legPositions[legPositions.length - 1];
    }

    @Override
    public void setLegOuterTemperatures(double[] temps) {
        this.legOuterTemperatures = temps;
    }

    @Override
    public void setLegOuterHeatTransferCoefficients(double[] coefs) {
        this.legOuterHeatTransferCoefficients = coefs;
    }

    @Override
    public void setLegWallHeatTransferCoefficients(double[] coefs) {
        this.legWallHeatTransferCoefficients = coefs;
    }

    @Override
    public double[] getLegHeights() {
        return this.legHeights;
    }

    @Override
    public void print() {
        for (int i = 0; i < this.getTotalNumberOfNodes() - 1; ++i) {
            System.out.println("node " + this.flowNode[i].getDistanceToCenterOfNode() + " pressure: " + this.flowNode[i].getBulkSystem().getPhases()[0].getPressure() + " temperature: " + this.flowNode[i].getBulkSystem().getPhases()[1].getTemperature() + "  flow: " + this.flowNode[i].getMassFlowRate(0) + " velocity: " + this.flowNode[i].getVelocity() + " reynolds number " + this.flowNode[i].getReynoldsNumber() + " friction : " + this.flowNode[i].getWallFrictionFactor() + " x1 : " + this.flowNode[i].getBulkSystem().getPhases()[0].getComponent(1).getx());
        }
    }

    @Override
    public void calcFluxes() {
    }

    @Override
    public double getTotalMolarMassTransferRate(int component) {
        double tot = 0.0;
        for (int i = 0; i < this.getTotalNumberOfNodes() - 1; ++i) {
            tot += this.flowNode[i].getFluidBoundary().getInterphaseMolarFlux(component) * this.flowNode[i].getInterphaseContactArea();
        }
        return tot;
    }

    @Override
    public double getTotalMolarMassTransferRate(int component, int lastNode) {
        double tot = 0.0;
        for (int i = 0; i < lastNode; ++i) {
            tot += this.flowNode[i].getFluidBoundary().getInterphaseMolarFlux(component) * this.flowNode[i].getInterphaseContactArea();
        }
        return tot;
    }

    @Override
    public double getTotalPressureDrop() {
        return this.flowNode[0].getBulkSystem().getPressure() - this.flowNode[this.getTotalNumberOfNodes() - 1].getBulkSystem().getPressure();
    }

    @Override
    public double getTotalPressureDrop(int lastNode) {
        return this.flowNode[0].getBulkSystem().getPressure() - this.flowNode[lastNode].getBulkSystem().getPressure();
    }

    @Override
    public void setInitialFlowPattern(String flowPattern) {
        this.initFlowPattern = flowPattern;
    }

    @Override
    public void setFlowPattern(String flowPattern) {
        this.initFlowPattern = flowPattern;
        for (int i = 0; i < this.getNumberOfLegs(); ++i) {
            this.flowLeg[i].setFlowPattern(flowPattern);
        }
    }

    public void setEquilibriumMassTransferModel(int startNode, int endNode) {
        for (int i = startNode; i < endNode; ++i) {
            if (this.flowNode[i].getBulkSystem().isChemicalSystem()) {
                this.flowNode[i].setInterphaseModelType(0);
            } else {
                this.flowNode[i].setInterphaseModelType(0);
            }
            this.flowNode[i].getFluidBoundary().setMassTransferCalc(false);
        }
    }

    public void setNonEquilibriumMassTransferModel(int startNode, int endNode) {
        for (int i = startNode; i < endNode; ++i) {
            if (this.flowNode[i].getBulkSystem().isChemicalSystem()) {
                this.flowNode[i].setInterphaseModelType(10);
            } else {
                this.flowNode[i].setInterphaseModelType(1);
            }
            this.flowNode[i].getFluidBoundary().setMassTransferCalc(true);
        }
    }

    public void setNonEquilibriumHeatTransferModel(int startNode, int endNode) {
        for (int i = startNode; i < endNode; ++i) {
            this.flowNode[i].getFluidBoundary().setHeatTransferCalc(true);
        }
    }

    public void setEquilibriumHeatTransferModel(int startNode, int endNode) {
        for (int i = startNode; i < endNode; ++i) {
            this.flowNode[i].getFluidBoundary().setHeatTransferCalc(false);
        }
    }

    @Override
    public void setEquilibriumMassTransfer(boolean test) {
        this.equilibriumMassTransfer = test;
        if (this.equilibriumMassTransfer) {
            this.setEquilibriumMassTransferModel(0, this.getTotalNumberOfNodes());
        } else {
            this.setNonEquilibriumMassTransferModel(0, this.getTotalNumberOfNodes());
        }
    }

    @Override
    public void setEquilibriumHeatTransfer(boolean test) {
        this.equilibriumHeatTransfer = test;
        if (this.equilibriumHeatTransfer) {
            this.setEquilibriumHeatTransferModel(0, this.getTotalNumberOfNodes());
        } else {
            this.setNonEquilibriumHeatTransferModel(0, this.getTotalNumberOfNodes());
        }
    }
}

