/*
 * Decompiled with CFR 0.152.
 */
package neqsim.fluidmechanics.flowsystem;

import java.util.UUID;
import neqsim.fluidmechanics.flownode.FlowNodeInterface;
import neqsim.fluidmechanics.flowsolver.FlowSolverInterface;
import neqsim.fluidmechanics.geometrydefinitions.GeometryDefinitionInterface;
import neqsim.fluidmechanics.util.fluidmechanicsvisualization.flowsystemvisualization.FlowSystemVisualizationInterface;
import neqsim.fluidmechanics.util.timeseries.TimeSeries;
import neqsim.thermo.system.SystemInterface;

public interface FlowSystemInterface {
    public void init();

    public void setNodes();

    default public void solveTransient(int type) {
        this.solveTransient(type, UUID.randomUUID());
    }

    public void solveTransient(int var1, UUID var2);

    public TimeSeries getTimeSeries();

    public FlowSystemVisualizationInterface getDisplay();

    public FlowSolverInterface getSolver();

    public double getInletTemperature();

    public double getInletPressure();

    public void setNumberOfLegs(int var1);

    public int getNumberOfLegs();

    public void setNumberOfNodesInLeg(int var1);

    public int getNumberOfNodesInLeg(int var1);

    public void setLegHeights(double[] var1);

    public double[] getLegHeights();

    public void setLegPositions(double[] var1);

    public void createSystem();

    public FlowNodeInterface getNode(int var1);

    public double getSystemLength();

    public void setLegOuterHeatTransferCoefficients(double[] var1);

    public void setLegWallHeatTransferCoefficients(double[] var1);

    public void setEquipmentGeometry(GeometryDefinitionInterface[] var1);

    public int getTotalNumberOfNodes();

    public void calcFluxes();

    public void setEndPressure(double var1);

    public void setInletThermoSystem(SystemInterface var1);

    default public void solveSteadyState(int type) {
        this.solveSteadyState(type, UUID.randomUUID());
    }

    public void solveSteadyState(int var1, UUID var2);

    public FlowNodeInterface[] getFlowNodes();

    public void print();

    public void setLegOuterTemperatures(double[] var1);

    public double getTotalMolarMassTransferRate(int var1);

    public double getTotalMolarMassTransferRate(int var1, int var2);

    public double getTotalPressureDrop();

    public double getTotalPressureDrop(int var1);

    public void setInitialFlowPattern(String var1);

    public void setFlowPattern(String var1);

    public void setEquilibriumMassTransfer(boolean var1);

    public void setEquilibriumHeatTransfer(boolean var1);
}

