/*
 * Decompiled with CFR 0.152.
 */
package neqsim.fluidmechanics.flowsystem.onephaseflowsystem.pipeflowsystem;

import java.util.UUID;
import neqsim.fluidmechanics.flowleg.pipeleg.PipeLeg;
import neqsim.fluidmechanics.flownode.onephasenode.onephasepipeflownode.onePhasePipeFlowNode;
import neqsim.fluidmechanics.flowsolver.onephaseflowsolver.onephasepipeflowsolver.OnePhaseFixedStaggeredGrid;
import neqsim.fluidmechanics.flowsystem.onephaseflowsystem.OnePhaseFlowSystem;
import neqsim.fluidmechanics.util.fluidmechanicsvisualization.flowsystemvisualization.onephaseflowvisualization.pipeflowvisualization.PipeFlowVisualization;
import neqsim.thermo.system.SystemInterface;

public class PipeFlowSystem
extends OnePhaseFlowSystem {
    private static final long serialVersionUID = 1000L;

    @Override
    public void createSystem() {
        this.thermoSystem.init(0);
        this.thermoSystem.init(1);
        this.flowLeg = new PipeLeg[this.getNumberOfLegs()];
        for (int i = 0; i < this.getNumberOfLegs(); ++i) {
            this.flowLeg[i] = new PipeLeg();
        }
        this.flowNode = new onePhasePipeFlowNode[this.totalNumberOfNodes];
        this.flowNode[0] = new onePhasePipeFlowNode(this.thermoSystem, this.equipmentGeometry[0]);
        this.flowNode[0].initFlowCalc();
        super.createSystem();
        this.setNodes();
    }

    @Override
    public void init() {
        for (int j = 0; j < this.getTotalNumberOfNodes(); ++j) {
            this.flowNode[j].initFlowCalc();
            this.flowNode[j].setVelocityIn(this.flowNode[j].getVelocity());
        }
        for (int k = 0; k < this.getTotalNumberOfNodes() - 1; ++k) {
            this.flowNode[k].setVelocityOut(this.flowNode[k + 1].getVelocityIn());
        }
    }

    @Override
    public void solveSteadyState(int type, UUID id) {
        double[] times = new double[]{0.0};
        this.display = new PipeFlowVisualization(this.getTotalNumberOfNodes(), 1);
        this.getTimeSeries().setTimes(times);
        SystemInterface[] systems = new SystemInterface[]{this.flowNode[0].getBulkSystem()};
        this.getTimeSeries().setInletThermoSystems(systems);
        this.getTimeSeries().setNumberOfTimeStepsInInterval(1);
        double[] outletFlowRates = new double[]{0.0, 0.0};
        this.getTimeSeries().setOutletMolarFlowRate(outletFlowRates);
        this.flowSolver = new OnePhaseFixedStaggeredGrid(this, this.getSystemLength(), this.getTotalNumberOfNodes(), false);
        this.flowSolver.setSolverType(type);
        this.flowSolver.solveTDMA();
        this.getTimeSeries().init(this);
        this.display.setNextData(this);
        this.calcIdentifier = id;
    }

    @Override
    public void solveTransient(int type, UUID id) {
        this.getTimeSeries().init(this);
        this.display = new PipeFlowVisualization(this.getTotalNumberOfNodes(), this.getTimeSeries().getTime().length);
        this.flowSolver.setDynamic(true);
        this.flowSolver.setSolverType(type);
        for (int i = 0; i < this.getTimeSeries().getTime().length; ++i) {
            this.getNode(0).setBulkSystem(this.getTimeSeries().getThermoSystem()[i]);
            this.getNode(0).initFlowCalc();
            this.getNode(0).setVelocityIn(this.getNode(0).getVelocity());
            this.flowNode[0].setVelocityOut(this.flowNode[0].getVelocity());
            System.out.println("vel: " + this.flowNode[0].getVelocity());
            this.getSolver().setTimeStep(this.getTimeSeries().getTimeStep()[i]);
            this.display.setNextData(this, this.getTimeSeries().getTime(i));
        }
        this.calcIdentifier = id;
    }
}

