/*
 * Decompiled with CFR 0.152.
 */
package neqsim.physicalproperties.interfaceproperties;

import java.io.Serializable;
import neqsim.physicalproperties.interfaceproperties.InterphasePropertiesInterface;
import neqsim.physicalproperties.interfaceproperties.solidadsorption.AdsorptionInterface;
import neqsim.physicalproperties.interfaceproperties.solidadsorption.PotentialTheoryAdsorption;
import neqsim.physicalproperties.interfaceproperties.surfacetension.FirozabadiRamleyInterfaceTension;
import neqsim.physicalproperties.interfaceproperties.surfacetension.GTSurfaceTension;
import neqsim.physicalproperties.interfaceproperties.surfacetension.GTSurfaceTensionSimple;
import neqsim.physicalproperties.interfaceproperties.surfacetension.LGTSurfaceTension;
import neqsim.physicalproperties.interfaceproperties.surfacetension.ParachorSurfaceTension;
import neqsim.physicalproperties.interfaceproperties.surfacetension.SurfaceTension;
import neqsim.physicalproperties.interfaceproperties.surfacetension.SurfaceTensionInterface;
import neqsim.thermo.phase.PhaseType;
import neqsim.thermo.system.SystemInterface;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class InterfaceProperties
implements InterphasePropertiesInterface,
Serializable {
    private static final long serialVersionUID = 1000L;
    static Logger logger = LogManager.getLogger(InterfaceProperties.class);
    SystemInterface system;
    SurfaceTensionInterface gasLiquidSurfaceTensionCalc = null;
    SurfaceTensionInterface gasAqueousSurfaceTensionCalc = null;
    SurfaceTensionInterface liquidLiquidSurfaceTensionCalc = null;
    private AdsorptionInterface[] adsorptionCalc;
    double[] surfaceTension;
    int numberOfInterfaces = 1;
    private int interfacialTensionModel = 0;

    public InterfaceProperties() {
    }

    public InterfaceProperties(SystemInterface system) {
        this.numberOfInterfaces = system.getNumberOfPhases() - 1;
        this.system = system;
    }

    @Override
    public InterfaceProperties clone() {
        InterfaceProperties clonedSystem = null;
        return clonedSystem;
    }

    @Override
    public void init(SystemInterface system) {
        this.system = system;
        this.init();
    }

    @Override
    public void init() {
        this.numberOfInterfaces = this.system.getNumberOfPhases() - 1;
        this.surfaceTension = new double[this.numberOfInterfaces + 1];
        if (this.gasLiquidSurfaceTensionCalc == null || this.gasAqueousSurfaceTensionCalc == null || this.liquidLiquidSurfaceTensionCalc == null) {
            this.setInterfacialTensionModel(this.interfacialTensionModel);
        }
    }

    @Override
    public void initAdsorption() {
        this.setAdsorptionCalc(new AdsorptionInterface[this.system.getNumberOfPhases()]);
        for (int i = 0; i < this.system.getNumberOfPhases(); ++i) {
            this.getAdsorptionCalc()[i] = new PotentialTheoryAdsorption(this.system);
        }
    }

    @Override
    public void setSolidAdsorbentMaterial(String material) {
        for (int i = 0; i < this.system.getNumberOfPhases(); ++i) {
            this.getAdsorptionCalc()[i].setSolidMaterial(material);
        }
    }

    @Override
    public void calcAdsorption() {
        for (int i = 0; i < this.system.getNumberOfPhases(); ++i) {
            this.getAdsorptionCalc()[i].calcAdsorption(i);
        }
    }

    @Override
    public double getSurfaceTension(int numb1, int numb2) {
        if (this.system.getPhase(numb1).getType() == PhaseType.GAS && this.system.getPhase(numb2).getType() == PhaseType.OIL) {
            return this.gasLiquidSurfaceTensionCalc.calcSurfaceTension(numb1, numb2);
        }
        if (this.system.getPhase(numb1).getType() == PhaseType.GAS && this.system.getPhase(numb2).getType() == PhaseType.AQUEOUS) {
            return this.gasAqueousSurfaceTensionCalc.calcSurfaceTension(numb1, numb2);
        }
        return this.liquidLiquidSurfaceTensionCalc.calcSurfaceTension(numb1, numb2);
    }

    @Override
    public double getSurfaceTension(int numb1, int numb2, String unit) {
        double val = this.getSurfaceTension(numb1, numb2);
        return val;
    }

    @Override
    public SurfaceTensionInterface getSurfaceTensionModel(int i) {
        if (this.system.getPhase(i).getType() == PhaseType.GAS) {
            return this.gasLiquidSurfaceTensionCalc;
        }
        return this.gasLiquidSurfaceTensionCalc;
    }

    @Override
    public int getInterfacialTensionModel() {
        return this.interfacialTensionModel;
    }

    @Override
    public void setInterfacialTensionModel(String phase1, String phase2, String model) {
        SurfaceTension surfTensModel = null;
        surfTensModel = "Linear Gradient Theory".equals(model) ? new LGTSurfaceTension(this.system) : ("Simple Gradient Theory".equals(model) ? new GTSurfaceTensionSimple(this.system) : ("Full Gradient Theory".equals(model) ? new GTSurfaceTension(this.system) : ("Firozabadi Ramley".equals(model) ? new FirozabadiRamleyInterfaceTension(this.system) : ("Parachor".equals(model) || "Weinaug-Katz".equals(model) ? new ParachorSurfaceTension(this.system) : new ParachorSurfaceTension(this.system)))));
        if (phase1.equals("gas") && phase2.equals("oil")) {
            this.gasLiquidSurfaceTensionCalc = surfTensModel;
        } else if (phase1.equals("gas") && phase2.equals("aqueous")) {
            this.gasAqueousSurfaceTensionCalc = surfTensModel;
        } else if (phase1.equals("oil") && phase2.equals("aqueous")) {
            this.liquidLiquidSurfaceTensionCalc = surfTensModel;
        }
    }

    @Override
    public void setInterfacialTensionModel(int interfacialTensionModel) {
        this.interfacialTensionModel = interfacialTensionModel;
        if (interfacialTensionModel == 0) {
            this.gasLiquidSurfaceTensionCalc = new ParachorSurfaceTension(this.system);
            this.gasAqueousSurfaceTensionCalc = new ParachorSurfaceTension(this.system);
            this.liquidLiquidSurfaceTensionCalc = new FirozabadiRamleyInterfaceTension(this.system);
        } else if (interfacialTensionModel == 1) {
            this.gasLiquidSurfaceTensionCalc = new GTSurfaceTension(this.system);
            this.gasAqueousSurfaceTensionCalc = new GTSurfaceTensionSimple(this.system);
            this.liquidLiquidSurfaceTensionCalc = new GTSurfaceTensionSimple(this.system);
        } else if (interfacialTensionModel == 2) {
            this.gasLiquidSurfaceTensionCalc = new LGTSurfaceTension(this.system);
            this.liquidLiquidSurfaceTensionCalc = new LGTSurfaceTension(this.system);
            this.gasAqueousSurfaceTensionCalc = new LGTSurfaceTension(this.system);
        } else if (interfacialTensionModel == 3) {
            this.gasLiquidSurfaceTensionCalc = new ParachorSurfaceTension(this.system);
            this.gasAqueousSurfaceTensionCalc = new ParachorSurfaceTension(this.system);
            this.liquidLiquidSurfaceTensionCalc = new FirozabadiRamleyInterfaceTension(this.system);
        } else if (interfacialTensionModel == 4) {
            this.gasLiquidSurfaceTensionCalc = new GTSurfaceTensionSimple(this.system);
            this.liquidLiquidSurfaceTensionCalc = new LGTSurfaceTension(this.system);
            this.gasAqueousSurfaceTensionCalc = new ParachorSurfaceTension(this.system);
        } else if (interfacialTensionModel == 5) {
            this.gasLiquidSurfaceTensionCalc = new ParachorSurfaceTension(this.system);
            this.gasAqueousSurfaceTensionCalc = new ParachorSurfaceTension(this.system);
            this.liquidLiquidSurfaceTensionCalc = new FirozabadiRamleyInterfaceTension(this.system);
        } else {
            this.gasLiquidSurfaceTensionCalc = new ParachorSurfaceTension(this.system);
            this.gasAqueousSurfaceTensionCalc = new ParachorSurfaceTension(this.system);
            this.liquidLiquidSurfaceTensionCalc = new ParachorSurfaceTension(this.system);
        }
    }

    @Override
    public AdsorptionInterface[] getAdsorptionCalc() {
        return this.adsorptionCalc;
    }

    @Override
    public AdsorptionInterface getAdsorptionCalc(String phaseName) {
        return this.adsorptionCalc[this.system.getPhaseNumberOfPhase(phaseName)];
    }

    @Override
    public void setAdsorptionCalc(AdsorptionInterface[] adsorptionCalc) {
        this.adsorptionCalc = adsorptionCalc;
    }
}

