/*
 * Decompiled with CFR 0.152.
 */
package neqsim.physicalproperties.interfaceproperties.surfacetension;

import neqsim.physicalproperties.interfaceproperties.surfacetension.GTSurfaceTensionUtils;
import neqsim.thermo.system.SystemInterface;
import org.apache.commons.math3.ode.FirstOrderDifferentialEquations;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;
import org.ejml.dense.row.NormOps_DDRM;
import org.ejml.dense.row.SingularOps_DDRM;
import org.ejml.dense.row.factory.DecompositionFactory_DDRM;
import org.ejml.interfaces.decomposition.SingularValueDecomposition_F64;

public class GTSurfaceTensionODE
implements FirstOrderDifferentialEquations {
    static Logger logger = LogManager.getLogger(GTSurfaceTensionODE.class);
    private boolean initialized = false;
    private int ncomp;
    private SystemInterface sys;
    private double[] ci;
    private double[] mueq;
    private double[] rho_ph1;
    private double[] rho_ph2;
    private double rhoref_span;
    private double[] rho_k;
    private double t;
    private double[] p0;
    private int refcomp;
    private int[] algidx;
    private static final double Pa = 1.0E-5;
    private static final double m3 = 1.0E-5;
    private double yscale;
    public double normtol = 1.0E-11;
    public double reltol = 1.0E-6;
    public double abstol = 1.0E-6;
    public int maxit = 40;

    public GTSurfaceTensionODE(SystemInterface flashedSystem, int phase1, int phase2, int referenceComponent, double yscale) {
        int i;
        int idx = 0;
        this.yscale = yscale;
        this.sys = flashedSystem.clone();
        this.refcomp = referenceComponent;
        this.ncomp = this.sys.getPhase(0).getNumberOfComponents();
        this.t = this.sys.getPhase(0).getTemperature();
        this.rho_ph1 = new double[this.ncomp];
        this.rho_ph2 = new double[this.ncomp];
        this.rho_k = new double[this.ncomp];
        this.algidx = new int[this.ncomp - 1];
        this.p0 = new double[1];
        this.ci = new double[this.ncomp];
        this.mueq = new double[this.ncomp];
        for (i = 0; i < this.ncomp; ++i) {
            if (i == this.refcomp) continue;
            this.algidx[idx] = i;
            ++idx;
        }
        for (i = 0; i < this.ncomp; ++i) {
            this.ci[i] = this.sys.getPhase(0).getComponent(i).getSurfaceTenisionInfluenceParameter(this.t);
            this.rho_ph1[i] = this.sys.getPhase(phase1).getComponent(i).getx() / this.sys.getPhase(phase1).getMolarVolume() / 1.0E-5;
            this.rho_ph2[i] = this.sys.getPhase(phase2).getComponent(i).getx() / this.sys.getPhase(phase2).getMolarVolume() / 1.0E-5;
            this.rho_k[i] = this.rho_ph1[i];
        }
        this.rhoref_span = Math.abs(this.rho_ph2[this.refcomp] - this.rho_ph1[this.refcomp]);
        this.sys.setBeta(1.0);
        this.sys.init(0);
        this.sys.setUseTVasIndependentVariables(true);
        this.sys.setNumberOfPhases(1);
        this.sys.getPhase(0).setTotalVolume(1.0);
        this.sys.useVolumeCorrection(false);
        this.sys.setEmptyFluid();
        double[] nv = new double[this.ncomp];
        for (i = 0; i < this.ncomp; ++i) {
            nv[i] = this.rho_ph1[i] * 1.0E-5;
        }
        this.sys.setMolarComposition(nv);
        this.sys.setMolarComposition(nv);
        this.sys.setMolarComposition(nv);
        this.sys.init_x_y();
        this.sys.setBeta(1.0);
        this.sys.init(3);
    }

    public void initmu() {
        double maxerr = 0.0;
        double[][] dmu_drho1 = new double[this.ncomp][this.ncomp];
        double[][] dmu_drho2 = new double[this.ncomp][this.ncomp];
        double[] mueq2 = new double[this.ncomp];
        double[] p0 = new double[1];
        GTSurfaceTensionUtils.mufun(this.sys, this.ncomp, this.t, this.rho_ph1, this.mueq, dmu_drho1, this.p0);
        GTSurfaceTensionUtils.mufun(this.sys, this.ncomp, this.t, this.rho_ph2, mueq2, dmu_drho2, p0);
        for (int i = 0; i < this.ncomp; ++i) {
            maxerr = Math.max(maxerr, Math.abs(this.mueq[i] / mueq2[i] - 1.0));
        }
        if (maxerr > this.reltol) {
            logger.error("Flash is not properly solved.  Maximum relative error in chemical potential:  " + maxerr + " > " + this.reltol);
            throw new RuntimeException("Flash not solved!");
        }
        this.initialized = true;
    }

    @Override
    public int getDimension() {
        return 1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void computeDerivatives(double t, double[] y, double[] yDot) {
        int i;
        int i2;
        double[] mu = new double[this.ncomp];
        double[][] dmu_drho = new double[this.ncomp][this.ncomp];
        double[] p = new double[1];
        double[] f = new double[this.ncomp];
        double[][] jac = new double[this.ncomp][this.ncomp];
        double[] rho = new double[this.ncomp];
        if (!this.initialized) {
            this.initmu();
        }
        double rho0 = this.rho_ph1[this.refcomp];
        rho[this.refcomp] = t * this.rhoref_span + rho0;
        for (i2 = 0; i2 < this.ncomp - 1; ++i2) {
            rho[this.algidx[i2]] = this.rho_k[this.algidx[i2]];
        }
        this.solveRho(rho, mu, dmu_drho, p, f, jac);
        for (i2 = 0; i2 < this.ncomp; ++i2) {
            this.rho_k[i2] = rho[i2];
        }
        DMatrixRMaj df = new DMatrixRMaj(jac);
        DMatrixRMaj ms = new DMatrixRMaj(df.numRows, 1);
        SingularValueDecomposition_F64<DMatrixRMaj> svd = DecompositionFactory_DDRM.svd(df.numRows, df.numCols, true, true, true);
        if (!svd.decompose(df)) {
            throw new RuntimeException("Decomposition failed");
        }
        DMatrixRMaj dn_dnref = SingularOps_DDRM.nullSpace(svd, ms, 1.0E-12);
        CommonOps_DDRM.divide(dn_dnref.get(this.refcomp, 0), dn_dnref);
        double delta_omega = -(p[0] - this.p0[0]);
        for (i = 0; i < this.ncomp; ++i) {
            delta_omega += (mu[i] - this.mueq[i]) * rho[i];
        }
        double dsigma = 0.0;
        for (i = 0; i < this.ncomp; ++i) {
            for (int j = 0; j < this.ncomp; ++j) {
                double cij = Math.sqrt(this.ci[i] * this.ci[j]);
                dsigma += cij * dn_dnref.get(i, 0) * dn_dnref.get(j, 0);
            }
        }
        if (delta_omega * dsigma < 0.0) {
            if (!(t > 0.9)) throw new RuntimeException("Negative discriminant");
            dsigma = 0.0;
        } else {
            dsigma = Math.sqrt(2.0 * delta_omega * dsigma);
        }
        yDot[0] = dsigma * this.rhoref_span * this.yscale;
        if (!(y[0] < 0.0)) return;
        y[0] = 0.0;
    }

    private void solveRho(double[] rho, double[] mu, double[][] dmu_drho, double[] p, double[] f, double[][] jac) {
        int iter;
        int j;
        int i;
        DMatrixRMaj A = new DMatrixRMaj(this.ncomp - 1, this.ncomp - 1);
        DMatrixRMaj b = new DMatrixRMaj(this.ncomp - 1, 1);
        DMatrixRMaj x = new DMatrixRMaj(this.ncomp - 1, 1);
        DMatrixRMaj x0 = new DMatrixRMaj(this.ncomp - 1, 1);
        DMatrixRMaj c = new DMatrixRMaj(this.ncomp - 1, 1);
        GTSurfaceTensionUtils.mufun(this.sys, this.ncomp, this.t, rho, mu, dmu_drho, p);
        this.fjacfun(mu, dmu_drho, f, jac);
        for (i = 0; i < this.ncomp - 1; ++i) {
            int idx1 = this.algidx[i];
            b.set(i, 0, -f[idx1]);
            x0.set(i, 0, rho[idx1]);
            for (j = 0; j < this.ncomp - 1; ++j) {
                int idx2 = this.algidx[j];
                A.set(i, j, jac[idx1][idx2]);
            }
        }
        double normf = NormOps_DDRM.normP2(b);
        if (normf < this.abstol) {
            return;
        }
        CommonOps_DDRM.solve(A, b, x);
        for (i = 1; i < this.ncomp - 1; ++i) {
            double xi = x.get(i, 0);
            if (!Double.isNaN(xi)) continue;
            throw new RuntimeException("Update is NaN");
        }
        double s = 0.8;
        double norm = 1.0E16;
        for (iter = 0; iter < this.maxit; ++iter) {
            CommonOps_DDRM.elementDiv(x, x0, c);
            double norm0 = norm;
            norm = NormOps_DDRM.normP2(c);
            if (norm < norm0) {
                s = Math.min(0.8, 1.2 * s);
            }
            if (norm < this.normtol || normf < this.abstol || normf < this.reltol) break;
            for (i = 0; i < this.ncomp - 1; ++i) {
                double delta = x.get(i, 0);
                if (!(rho[this.algidx[i]] + s * delta < 0.0)) continue;
                s = Math.min(s, -0.5 * rho[this.algidx[i]] / delta);
            }
            for (i = 0; i < this.ncomp - 1; ++i) {
                double delta = x.get(i, 0);
                int n = this.algidx[i];
                rho[n] = rho[n] + s * delta;
                x0.set(i, 0, rho[this.algidx[i]]);
            }
            GTSurfaceTensionUtils.mufun(this.sys, this.ncomp, this.t, rho, mu, dmu_drho, p);
            this.fjacfun(mu, dmu_drho, f, jac);
            for (i = 0; i < this.ncomp - 1; ++i) {
                int idx1 = this.algidx[i];
                b.set(i, 0, -f[idx1]);
                for (j = 0; j < this.ncomp - 1; ++j) {
                    int idx2 = this.algidx[j];
                    A.set(i, j, jac[idx1][idx2]);
                }
            }
            CommonOps_DDRM.solve(A, b, x);
            normf = NormOps_DDRM.normP2(b);
        }
        if (iter >= this.maxit) {
            for (i = 0; i < this.ncomp - 1; ++i) {
                logger.info("f[" + i + "]: " + f[this.algidx[i]]);
            }
            throw new RuntimeException("Failed to solve for density");
        }
    }

    public void fjacfun(double[] mu, double[][] dmu_drho, double[] f, double[][] jac) {
        double delta_muref = this.mueq[this.refcomp] - mu[this.refcomp];
        double sqrtcref = Math.sqrt(this.ci[this.refcomp]);
        double scale = 1.0 / sqrtcref;
        for (int i = 0; i < this.ncomp; ++i) {
            double sqrtci = Math.sqrt(this.ci[i]);
            f[i] = scale * (sqrtci * delta_muref - sqrtcref * (this.mueq[i] - mu[i]));
            for (int j = 0; j < this.ncomp; ++j) {
                jac[i][j] = scale * (sqrtci * -dmu_drho[this.refcomp][j] - sqrtcref * -dmu_drho[i][j]);
            }
        }
    }
}

