/*
 * Decompiled with CFR 0.152.
 */
package neqsim.physicalproperties.methods.commonphasephysicalproperties.diffusivity;

import neqsim.physicalproperties.methods.commonphasephysicalproperties.CommonPhysicalPropertyMethod;
import neqsim.physicalproperties.methods.methodinterface.DiffusivityInterface;
import neqsim.physicalproperties.system.PhysicalProperties;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Diffusivity
extends CommonPhysicalPropertyMethod
implements DiffusivityInterface {
    private static final long serialVersionUID = 1000L;
    static Logger logger = LogManager.getLogger(Diffusivity.class);
    double[][] binaryDiffusionCoefficients;
    double[][] binaryLennardJonesOmega;
    double[] effectiveDiffusionCoefficient;

    public Diffusivity(PhysicalProperties phase) {
        super(phase);
        this.binaryDiffusionCoefficients = new double[phase.getPhase().getNumberOfComponents()][phase.getPhase().getNumberOfComponents()];
        this.binaryLennardJonesOmega = new double[phase.getPhase().getNumberOfComponents()][phase.getPhase().getNumberOfComponents()];
        this.effectiveDiffusionCoefficient = new double[phase.getPhase().getNumberOfComponents()];
    }

    @Override
    public Diffusivity clone() {
        Diffusivity properties = null;
        try {
            properties = (Diffusivity)super.clone();
        }
        catch (Exception ex) {
            logger.error("Cloning failed.", (Throwable)ex);
        }
        if (this.binaryDiffusionCoefficients != null && this.binaryDiffusionCoefficients.length > 0) {
            properties.binaryDiffusionCoefficients = (double[][])this.binaryDiffusionCoefficients.clone();
            for (int i = 0; i < this.binaryDiffusionCoefficients.length; ++i) {
                if (this.binaryDiffusionCoefficients[i] == null || properties.binaryDiffusionCoefficients[i] == null) continue;
                System.arraycopy(this.binaryDiffusionCoefficients[i], 0, properties.binaryDiffusionCoefficients[i], 0, this.binaryDiffusionCoefficients[i].length);
            }
        }
        if (this.effectiveDiffusionCoefficient != null && this.effectiveDiffusionCoefficient.length > 0) {
            properties.effectiveDiffusionCoefficient = (double[])this.effectiveDiffusionCoefficient.clone();
        }
        return properties;
    }

    @Override
    public double calcBinaryDiffusionCoefficient(int i, int j, int method) {
        return 1.0E-6;
    }

    @Override
    public double[][] calcDiffusionCoefficients(int binaryDiffusionCoefficientMethod, int multicomponentDiffusionMethod) {
        for (int i = 0; i < this.phase.getPhase().getNumberOfComponents(); ++i) {
            for (int j = 0; j < this.phase.getPhase().getNumberOfComponents(); ++j) {
                this.binaryDiffusionCoefficients[i][j] = this.calcBinaryDiffusionCoefficient(i, j, binaryDiffusionCoefficientMethod);
            }
        }
        if (multicomponentDiffusionMethod == 0 || multicomponentDiffusionMethod == 0) {
            // empty if block
        }
        return this.binaryDiffusionCoefficients;
    }

    @Override
    public void calcEffectiveDiffusionCoefficients() {
        double sum = 0.0;
        for (int i = 0; i < this.phase.getPhase().getNumberOfComponents(); ++i) {
            sum = 0.0;
            for (int j = 0; j < this.phase.getPhase().getNumberOfComponents(); ++j) {
                if (i == j) continue;
                sum += this.phase.getPhase().getComponent(j).getx() / this.binaryDiffusionCoefficients[i][j];
            }
            this.effectiveDiffusionCoefficient[i] = (1.0 - this.phase.getPhase().getComponent(i).getx()) / sum;
        }
    }

    @Override
    public double getFickBinaryDiffusionCoefficient(int i, int j) {
        return this.binaryDiffusionCoefficients[i][j];
    }

    @Override
    public double getEffectiveDiffusionCoefficient(int i) {
        return this.effectiveDiffusionCoefficient[i];
    }

    @Override
    public double getMaxwellStefanBinaryDiffusionCoefficient(int i, int j) {
        return this.binaryDiffusionCoefficients[i][j];
    }
}

