/*
 * Decompiled with CFR 0.152.
 */
package neqsim.physicalproperties.methods.commonphasephysicalproperties.viscosity;

import neqsim.physicalproperties.methods.commonphasephysicalproperties.viscosity.Viscosity;
import neqsim.physicalproperties.system.PhysicalProperties;
import neqsim.thermo.ThermodynamicConstantsInterface;
import neqsim.thermo.phase.PhaseEosInterface;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FrictionTheoryViscosityMethod
extends Viscosity
implements ThermodynamicConstantsInterface {
    private static final long serialVersionUID = 1000L;
    static Logger logger = LogManager.getLogger(FrictionTheoryViscosityMethod.class);
    public double[] pureComponentViscosity;
    public double[] Fc;
    public double[] omegaVisc;
    protected double[] chungE = new double[10];
    static double TBPcorrection = 1.0;
    protected double kapac_fconst = -0.165302;
    protected double kaprc_fconst = 0.00699574;
    protected double kaprrc_fconst = 0.00126358;
    protected double[][] kapa_fconst = new double[][]{{-0.114804, 0.246622, -0.0394638}, {0.246622, -1.15648E-4, 4.18863E-5}, {-0.0394638, 4.18863E-5, -5.91999E-9}};
    protected double[][] kapr_fconst = new double[][]{{-0.315903, 0.566713, -0.0729995}, {0.566713, -1.0086E-4, 5.17459E-5}, {-0.0729995, 5.17459E-5, -5.68708E-9}};
    protected double kaprr_fconst = 1.35994E-8;

    public FrictionTheoryViscosityMethod(PhysicalProperties phase) {
        super(phase);
        this.pureComponentViscosity = new double[phase.getPhase().getNumberOfComponents()];
        this.Fc = new double[phase.getPhase().getNumberOfComponents()];
        this.omegaVisc = new double[phase.getPhase().getNumberOfComponents()];
        if (this.getClass().getName().equals("neqsim.thermo.phase.PhasePrEos")) {
            this.kapac_fconst = -0.140464;
            this.kaprc_fconst = 0.0119902;
            this.kaprrc_fconst = 8.55115E-4;
            double[][] kapa_fconst = new double[][]{{-0.0489197, 0.270572, -0.0448111}, {0.270572, -1.10473E-4, 4.08972E-5}, {-0.0448111, 4.08972E-5, -5.79765E-9}};
            this.kapa_fconst = kapa_fconst;
            double[][] kapr_fconst = new double[][]{{-0.357875, 0.637572, -0.079024}, {0.637572, -6.02128E-5, 3.72408E-5}, {-0.079024, 3.72408E-5, -5.6561E-9}};
            this.kapr_fconst = kapr_fconst;
            this.kaprr_fconst = 1.3729E-8;
        }
    }

    @Override
    public double calcViscosity() {
        this.initChungPureComponentViscosity();
        double visk0 = 0.0;
        double visk1 = 0.0;
        double MM = 0.0;
        for (int i = 0; i < this.phase.getPhase().getNumberOfComponents(); ++i) {
            visk0 += this.phase.getPhase().getComponent(i).getx() * Math.log(this.getPureComponentViscosity(i));
            MM += this.phase.getPhase().getComponent(i).getx() / Math.pow(this.phase.getPhase().getComponent(i).getMolarMass(), 0.3);
        }
        visk0 = Math.exp(visk0);
        double Prepulsive = 1.0;
        double Pattractive = 1.0;
        try {
            Prepulsive = ((PhaseEosInterface)this.phase.getPhase()).getPressureRepulsive();
            Pattractive = ((PhaseEosInterface)this.phase.getPhase()).getPressureAttractive();
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
        double kaprmx = 0.0;
        double kapamx = 0.0;
        double kaprrmx = 0.0;
        for (int i = 0; i < this.phase.getPhase().getNumberOfComponents(); ++i) {
            double nci = this.phase.getPhase().getComponent(i).getCriticalViscosity() * 1.0E7;
            if (this.phase.getPhase().getComponent(i).isIsPlusFraction() || this.phase.getPhase().getComponent(i).isIsTBPfraction()) {
                nci *= TBPcorrection;
            }
            double phi = 83.144621 * this.phase.getPhase().getComponent(i).getTC() / this.phase.getPhase().getComponent(i).getPC();
            double bigGam = this.phase.getPhase().getComponent(i).getTC() / this.phase.getPhase().getTemperature();
            double kapri = this.getRedKapr(i, phi, bigGam);
            double kaprri = this.getRedKaprr(i, phi, bigGam);
            double kapai = this.getRedKapa(i, phi, bigGam);
            double zi = this.phase.getPhase().getComponent(i).getx() / (Math.pow(this.phase.getPhase().getComponent(i).getMolarMass(), 0.3) * MM);
            kaprmx += zi * nci * kapri / this.phase.getPhase().getComponent(i).getPC();
            kapamx += zi * nci * kapai / this.phase.getPhase().getComponent(i).getPC();
            kaprrmx += zi * nci * kaprri / (this.phase.getPhase().getComponent(i).getPC() * this.phase.getPhase().getComponent(i).getPC());
        }
        visk1 = kaprmx * Prepulsive + kapamx * Pattractive + kaprrmx * Prepulsive * Prepulsive;
        if (visk0 + visk1 < 1.0E-20) {
            return 1.0E-6;
        }
        return (visk0 + visk1) * 1.0E-7;
    }

    public double getRedKapr(int compNumb, double phi, double bigGamma) {
        return this.kaprc_fconst + this.kapr_fconst[0][0] * (bigGamma - 1.0) + (this.kapr_fconst[1][0] + this.kapr_fconst[1][1] * phi) * (Math.exp(bigGamma - 1.0) - 1.0) + (this.kapr_fconst[2][0] + this.kapr_fconst[2][1] * phi + this.kapr_fconst[2][2] * phi * phi) * (Math.exp(2.0 * bigGamma - 2.0) - 1.0);
    }

    public double getRedKaprr(int compNumb, double phi, double bigGamma) {
        return this.kaprrc_fconst + this.kaprr_fconst * phi * (Math.exp(2.0 * bigGamma) - 1.0) * Math.pow(bigGamma - 1.0, 2.0);
    }

    public double getRedKapa(int compNumb, double phi, double bigGamma) {
        return this.kapac_fconst + this.kapa_fconst[0][0] * (bigGamma - 1.0) + (this.kapa_fconst[1][0] + this.kapa_fconst[1][1] * phi) * (Math.exp(bigGamma - 1.0) - 1.0) + (this.kapa_fconst[2][0] + this.kapa_fconst[2][1] * phi + this.kapa_fconst[2][2] * phi * phi) * (Math.exp(2.0 * bigGamma - 2.0) - 1.0);
    }

    @Override
    public double getPureComponentViscosity(int i) {
        return this.pureComponentViscosity[i];
    }

    public void initChungPureComponentViscosity() {
        double tempVar = 0.0;
        double A = 1.16145;
        double B = 0.14874;
        double C = 0.52487;
        double D = 0.7732;
        double E = 2.16178;
        double F = 2.43787;
        for (int i = 0; i < this.phase.getPhase().getNumberOfComponents(); ++i) {
            this.Fc[i] = 1.0 - 0.2756 * this.phase.getPhase().getComponent(i).getAcentricFactor();
            tempVar = 1.2593 * this.phase.getPhase().getTemperature() / this.phase.getPhase().getComponent(i).getTC();
            double varLast = -6.435E-4 * Math.pow(tempVar, 0.14874) * Math.sin(18.0323 * Math.pow(tempVar, -0.7683) - 7.27371);
            this.omegaVisc[i] = A / Math.pow(tempVar, B) + C / Math.exp(D * tempVar) + E / Math.exp(F * tempVar) + varLast;
            double critVol = this.phase.getPhase().getPhase().getComponent(i).getCriticalVolume();
            this.pureComponentViscosity[i] = 40.785 * Math.sqrt(this.phase.getPhase().getComponent(i).getMolarMass() * 1000.0 * this.phase.getPhase().getTemperature()) / (Math.pow(critVol, 0.6666666666666666) * this.omegaVisc[i]) * this.Fc[i];
        }
    }

    @Override
    public void tuneModel(double val, double temperature, double pressure) {
        double calcVisc = 0.0;
        int iter = 0;
        double err = 0.0;
        double oldTemp = this.phase.getPhase().getTemperature();
        double oldPres = this.phase.getPhase().getPressure();
        this.phase.getPhase().setTemperature(temperature);
        this.phase.getPhase().setPressure(pressure);
        this.phase.getPhase().init();
        do {
            int i;
            ++iter;
            this.phase.getPhase().initPhysicalProperties();
            calcVisc = this.calcViscosity();
            logger.info("visc " + calcVisc);
            err = (calcVisc - val) / calcVisc;
            logger.info("err " + err);
            if (this.phase.getPhase().hasPlusFraction() || this.phase.getPhase().hasTBPFraction()) {
                logger.info("has plus fraction ");
                for (i = 0; i < this.phase.getPhase().getNumberOfComponents(); ++i) {
                    if (!this.phase.getPhase().getComponent(i).isIsPlusFraction() && !this.phase.getPhase().getComponent(i).isIsTBPfraction()) continue;
                    this.phase.getPhase().getComponent(i).setCriticalViscosity(this.phase.getPhase().getComponent(i).getCriticalViscosity() * (1.0 - err));
                }
            } else {
                logger.info("no plus fraction ");
                for (i = 0; i < this.phase.getPhase().getNumberOfComponents(); ++i) {
                    this.phase.getPhase().getComponent(i).setCriticalViscosity(this.phase.getPhase().getComponent(i).getCriticalViscosity() * (1.0 - err));
                }
            }
        } while (Math.abs(err) > 1.0E-4 && iter < 500);
        this.phase.getPhase().setTemperature(oldTemp);
        this.phase.getPhase().setPressure(oldPres);
        this.phase.getPhase().init();
    }

    public void setTBPviscosityCorrection(double correction) {
        TBPcorrection = correction;
    }

    public double getTBPviscosityCorrection() {
        return TBPcorrection;
    }
}

