/*
 * Decompiled with CFR 0.152.
 */
package neqsim.physicalproperties.methods.commonphasephysicalproperties.viscosity;

import neqsim.physicalproperties.methods.commonphasephysicalproperties.viscosity.Viscosity;
import neqsim.physicalproperties.system.PhysicalProperties;

public class KTAViscosityMethod
extends Viscosity {
    private static final long serialVersionUID = 1000L;

    public KTAViscosityMethod(PhysicalProperties phase) {
        super(phase);
    }

    @Override
    public double calcViscosity() {
        if (this.phase.getPhase().getNumberOfComponents() > 1 || !this.phase.getPhase().getComponent(0).getName().equalsIgnoreCase("helium")) {
            throw new Error("This method only supports PURE HELIUM.");
        }
        double T = this.phase.getPhase().getTemperature();
        double visc = 3.674 * Math.pow(10.0, -7.0) * Math.pow(T, 0.7);
        return visc;
    }
}

