/*
 * Decompiled with CFR 0.152.
 */
package neqsim.physicalproperties.methods.commonphasephysicalproperties.viscosity;

import neqsim.physicalproperties.methods.commonphasephysicalproperties.viscosity.Viscosity;
import neqsim.physicalproperties.system.PhysicalProperties;

public class KTAViscosityMethodMod
extends Viscosity {
    private static final long serialVersionUID = 1000L;

    public KTAViscosityMethodMod(PhysicalProperties phase) {
        super(phase);
    }

    @Override
    public double calcViscosity() {
        if (this.phase.getPhase().getNumberOfComponents() > 1 || !this.phase.getPhase().getComponent(0).getName().equalsIgnoreCase("helium")) {
            throw new Error("This method only supports PURE HELIUM.");
        }
        double T = this.phase.getPhase().getTemperature();
        double P = this.phase.getPhase().getPressure();
        double P_crit = 0.22832;
        double A = Math.pow(2.0 - T / 300.0, 5.05);
        double B = Math.pow(2.0 - 300.0 / T, 2.0) - 1.0;
        double C = (1.0 - 0.3 / (1.0 + Math.exp(-0.5 * (T - 450.0)))) / (1.0 + Math.exp(-0.5 * (T - 377.0))) - 1.5 / (1.0 + Math.exp(-0.5 * (T - 572.0)));
        double viscosity = 1.0E-7 * (3.817 * Math.pow(T, 0.6938) + Math.pow(P, A) / (T * P_crit) + Math.exp(-Math.pow(T - 325.0, 2.0) / 1000.0) * (Math.pow(P / 25.0, 2.7) - Math.pow(T, B)) - C);
        return viscosity;
    }
}

