/*
 * Decompiled with CFR 0.152.
 */
package neqsim.physicalproperties.methods.gasphysicalproperties.conductivity;

import neqsim.physicalproperties.methods.gasphysicalproperties.conductivity.Conductivity;
import neqsim.physicalproperties.system.PhysicalProperties;

public class ChungConductivityMethod
extends Conductivity {
    private static final long serialVersionUID = 1000L;
    double conductivity = 0.0;
    public double[] pureComponentConductivity;

    public ChungConductivityMethod(PhysicalProperties gasPhase) {
        super(gasPhase);
        this.pureComponentConductivity = new double[gasPhase.getPhase().getNumberOfComponents()];
    }

    @Override
    public double calcConductivity() {
        this.calcPureComponentConductivity();
        double tempVar = 0.0;
        this.conductivity = 0.0;
        for (int i = 0; i < this.gasPhase.getPhase().getNumberOfComponents(); ++i) {
            tempVar = 0.0;
            for (int j = 0; j < this.gasPhase.getPhase().getNumberOfComponents(); ++j) {
                double Aij = 1.0 * Math.pow(1.0 + Math.sqrt(this.pureComponentConductivity[i] / this.pureComponentConductivity[j]) * Math.pow(this.gasPhase.getPhase().getComponent(i).getMolarMass() / this.gasPhase.getPhase().getComponent(j).getMolarMass(), 0.25), 2.0) / Math.sqrt(8.0 * (1.0 + this.gasPhase.getPhase().getComponent(i).getMolarMass() / this.gasPhase.getPhase().getComponent(j).getMolarMass()));
                tempVar += this.gasPhase.getPhase().getComponent(j).getx() * Aij;
            }
            this.conductivity += this.gasPhase.getPhase().getComponent(i).getx() * this.pureComponentConductivity[i] / tempVar;
        }
        return this.conductivity;
    }

    public void calcPureComponentConductivity() {
        double tempVar2 = 0.0;
        double tempBeta = 0.0;
        double tempAlpha = 0.0;
        double tempZ = 0.0;
        for (int i = 0; i < this.gasPhase.getPhase().getNumberOfComponents(); ++i) {
            tempVar2 = this.gasPhase.getPhase().getComponent(i).getCv0(this.gasPhase.getPhase().getTemperature()) / 8.3144621 - 1.5;
            tempBeta = 0.7862 - 0.7109 * this.gasPhase.getPhase().getComponent(i).getAcentricFactor() + 1.3168 * Math.pow(this.gasPhase.getPhase().getComponent(i).getAcentricFactor(), 2.0);
            tempZ = 2.0 + 10.5 * Math.pow(this.gasPhase.getPhase().getTemperature() / this.gasPhase.getPhase().getComponent(i).getTC(), 2.0);
            tempAlpha = 1.0 + tempVar2 * ((0.215 + 0.28288 * tempVar2 - 1.061 * tempBeta + 0.26665 * tempZ) / (0.6366 + tempBeta * tempZ + 1.061 * tempVar2 * tempBeta));
            this.pureComponentConductivity[i] = 1.0 / this.gasPhase.getPhase().getComponent(i).getMolarMass() * this.gasPhase.getPureComponentViscosity(i) * 1.0E-7 * this.gasPhase.getPhase().getComponent(i).getCv0(this.gasPhase.getPhase().getTemperature()) * 3.75 * tempAlpha / (this.gasPhase.getPhase().getComponent(i).getCv0(this.gasPhase.getPhase().getTemperature()) / 8.3144621);
            if (!(this.pureComponentConductivity[i] < 1.0E-50)) continue;
            this.pureComponentConductivity[i] = 1.0E-50;
        }
    }
}

