/*
 * Decompiled with CFR 0.152.
 */
package neqsim.physicalproperties.methods.gasphysicalproperties.diffusivity;

import neqsim.physicalproperties.methods.gasphysicalproperties.GasPhysicalPropertyMethod;
import neqsim.physicalproperties.methods.methodinterface.DiffusivityInterface;
import neqsim.physicalproperties.system.PhysicalProperties;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Diffusivity
extends GasPhysicalPropertyMethod
implements DiffusivityInterface {
    private static final long serialVersionUID = 1000L;
    static Logger logger = LogManager.getLogger(Diffusivity.class);
    double[][] binaryDiffusionCoefficients;
    double[][] binaryLennardJonesOmega;
    double[] effectiveDiffusionCoefficient;

    public Diffusivity(PhysicalProperties gasPhase) {
        super(gasPhase);
        this.binaryDiffusionCoefficients = new double[gasPhase.getPhase().getNumberOfComponents()][gasPhase.getPhase().getNumberOfComponents()];
        this.binaryLennardJonesOmega = new double[gasPhase.getPhase().getNumberOfComponents()][gasPhase.getPhase().getNumberOfComponents()];
        this.effectiveDiffusionCoefficient = new double[gasPhase.getPhase().getNumberOfComponents()];
    }

    @Override
    public Diffusivity clone() {
        Diffusivity properties = null;
        try {
            properties = (Diffusivity)super.clone();
        }
        catch (Exception ex) {
            logger.error("Cloning failed.", (Throwable)ex);
        }
        if (this.binaryDiffusionCoefficients != null && this.binaryDiffusionCoefficients.length > 0) {
            properties.binaryDiffusionCoefficients = (double[][])this.binaryDiffusionCoefficients.clone();
            for (int i = 0; i < this.binaryDiffusionCoefficients.length; ++i) {
                if (this.binaryDiffusionCoefficients[i] == null || properties.binaryDiffusionCoefficients[i] == null) continue;
                System.arraycopy(this.binaryDiffusionCoefficients[i], 0, properties.binaryDiffusionCoefficients[i], 0, this.binaryDiffusionCoefficients[i].length);
            }
        }
        if (this.effectiveDiffusionCoefficient != null && this.effectiveDiffusionCoefficient.length > 0) {
            properties.effectiveDiffusionCoefficient = (double[])this.effectiveDiffusionCoefficient.clone();
        }
        return properties;
    }

    @Override
    public double calcBinaryDiffusionCoefficient(int i, int j, int method) {
        double A2 = 1.06036;
        double B2 = 0.1561;
        double C2 = 0.193;
        double D2 = 0.47635;
        double E2 = 1.03587;
        double F2 = 1.52996;
        double G2 = 1.76474;
        double H2 = 3.89411;
        double tempVar2 = this.gasPhase.getPhase().getTemperature() / this.binaryEnergyParameter[i][j];
        this.binaryLennardJonesOmega[i][j] = A2 / Math.pow(tempVar2, B2) + C2 / Math.exp(D2 * tempVar2) + E2 / Math.exp(F2 * tempVar2) + G2 / Math.exp(H2 * tempVar2);
        this.binaryDiffusionCoefficients[i][j] = 0.00266 * Math.pow(this.gasPhase.getPhase().getTemperature(), 1.5) / (this.gasPhase.getPhase().getPressure() * Math.sqrt(this.binaryMolecularMass[i][j]) * Math.pow(this.binaryMolecularDiameter[i][j], 2.0) * this.binaryLennardJonesOmega[i][j]);
        double[] dArray = this.binaryDiffusionCoefficients[i];
        int n = j;
        double d = dArray[n] * 1.0E-4;
        dArray[n] = d;
        return d;
    }

    @Override
    public double[][] calcDiffusionCoefficients(int binaryDiffusionCoefficientMethod, int multicomponentDiffusionMethod) {
        for (int i = 0; i < this.gasPhase.getPhase().getNumberOfComponents(); ++i) {
            for (int j = i; j < this.gasPhase.getPhase().getNumberOfComponents(); ++j) {
                this.binaryDiffusionCoefficients[i][j] = this.calcBinaryDiffusionCoefficient(i, j, binaryDiffusionCoefficientMethod);
                this.binaryDiffusionCoefficients[j][i] = this.binaryDiffusionCoefficients[i][j];
            }
        }
        if (multicomponentDiffusionMethod == 0 || multicomponentDiffusionMethod == 0) {
            // empty if block
        }
        return this.binaryDiffusionCoefficients;
    }

    @Override
    public void calcEffectiveDiffusionCoefficients() {
        double sum = 0.0;
        for (int i = 0; i < this.gasPhase.getPhase().getNumberOfComponents(); ++i) {
            sum = 0.0;
            for (int j = 0; j < this.gasPhase.getPhase().getNumberOfComponents(); ++j) {
                if (i == j) continue;
                sum += this.gasPhase.getPhase().getComponent(j).getx() / this.binaryDiffusionCoefficients[i][j];
            }
            this.effectiveDiffusionCoefficient[i] = (1.0 - this.gasPhase.getPhase().getComponent(i).getx()) / sum;
        }
    }

    @Override
    public double getFickBinaryDiffusionCoefficient(int i, int j) {
        return this.binaryDiffusionCoefficients[i][j];
    }

    @Override
    public double getEffectiveDiffusionCoefficient(int i) {
        return this.effectiveDiffusionCoefficient[i];
    }

    @Override
    public double getMaxwellStefanBinaryDiffusionCoefficient(int i, int j) {
        return this.binaryDiffusionCoefficients[i][j];
    }
}

