/*
 * Decompiled with CFR 0.152.
 */
package neqsim.physicalproperties.methods.liquidphysicalproperties.density;

import neqsim.physicalproperties.methods.liquidphysicalproperties.LiquidPhysicalPropertyMethod;
import neqsim.physicalproperties.methods.methodinterface.DensityInterface;
import neqsim.physicalproperties.system.PhysicalProperties;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Density
extends LiquidPhysicalPropertyMethod
implements DensityInterface {
    private static final long serialVersionUID = 1000L;
    static Logger logger = LogManager.getLogger(Density.class);

    public Density(PhysicalProperties liquidPhase) {
        super(liquidPhase);
    }

    @Override
    public Density clone() {
        Density properties = null;
        try {
            properties = (Density)super.clone();
        }
        catch (Exception ex) {
            logger.error("Cloning failed.", (Throwable)ex);
        }
        return properties;
    }

    @Override
    public double calcDensity() {
        double tempVar = 0.0;
        if (this.liquidPhase.getPhase().useVolumeCorrection()) {
            for (int i = 0; i < this.liquidPhase.getPhase().getNumberOfComponents(); ++i) {
                tempVar += this.liquidPhase.getPhase().getComponent(i).getx() * (this.liquidPhase.getPhase().getComponent(i).getVolumeCorrection() + this.liquidPhase.getPhase().getComponent(i).getVolumeCorrectionT() * (this.liquidPhase.getPhase().getTemperature() - 288.15));
            }
        }
        return 1.0 / (this.liquidPhase.getPhase().getMolarVolume() - tempVar) * this.liquidPhase.getPhase().getMolarMass() * 100000.0;
    }
}

