/*
 * Decompiled with CFR 0.152.
 */
package neqsim.physicalproperties.methods.liquidphysicalproperties.density;

import java.util.HashMap;
import java.util.Map;
import neqsim.physicalproperties.methods.liquidphysicalproperties.LiquidPhysicalPropertyMethod;
import neqsim.physicalproperties.methods.methodinterface.DensityInterface;
import neqsim.physicalproperties.system.PhysicalProperties;
import neqsim.thermo.component.ComponentInterface;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Water
extends LiquidPhysicalPropertyMethod
implements DensityInterface {
    private static final long serialVersionUID = 1000L;
    static Logger logger = LogManager.getLogger(Water.class);
    private static final Map<String, double[]> saltParameters = new HashMap<String, double[]>();

    public Water(PhysicalProperties liquidPhase) {
        super(liquidPhase);
    }

    @Override
    public Water clone() {
        Water properties = null;
        try {
            properties = (Water)super.clone();
        }
        catch (Exception ex) {
            logger.error("Cloning failed.", (Throwable)ex);
        }
        return properties;
    }

    @Override
    public double calcDensity() {
        double tempK = this.liquidPhase.getPhase().getTemperature();
        double tempC = tempK - 273.15;
        double wH2O = 0.0;
        double rhoWater = 1000.0;
        double phaseMolarMass = this.liquidPhase.getPhase().getMolarMass();
        int numComps = this.liquidPhase.getPhase().getNumberOfComponents();
        for (int i = 0; i < numComps; ++i) {
            ComponentInterface comp = this.liquidPhase.getPhase().getComponent(i);
            double w = comp.getx() * comp.getMolarMass() / phaseMolarMass;
            if (!comp.getName().equalsIgnoreCase("water")) continue;
            wH2O = w;
            double pureWaterDensity = Water.calculatePureWaterDensity(this.liquidPhase.getPhase().getTemperature(), this.liquidPhase.getPhase().getPressure());
            if (!(pureWaterDensity > 1.0E-8)) break;
            rhoWater = pureWaterDensity;
            break;
        }
        double sumPartialVolumes = wH2O / rhoWater;
        for (int i = 0; i < numComps; ++i) {
            ComponentInterface comp = this.liquidPhase.getPhase().getComponent(i);
            String compName = comp.getName();
            if (compName.equalsIgnoreCase("water") || !saltParameters.containsKey(compName)) continue;
            double wSalt = comp.getx() * comp.getMolarMass() / phaseMolarMass;
            double vSalt = this.calcPartialVolumeSalt(compName, tempC, wSalt);
            sumPartialVolumes += wSalt * vSalt;
        }
        return 1.0 / sumPartialVolumes;
    }

    private double calcPartialVolumeSalt(String saltName, double temperatureC, double wSalt) {
        double[] params = saltParameters.get(saltName);
        double c0 = params[0];
        double c1 = params[1];
        double c2 = params[2];
        double c3 = params[3];
        double c4 = params[4];
        double numerator = wSalt + c2 + c3 * temperatureC;
        double denominator = (c0 * wSalt + c1) * Math.exp(1.0E-6 * Math.pow(temperatureC + c4, 2.0));
        return numerator / denominator;
    }

    public static double calculatePureWaterDensity(double temperatureK, double pressureBar) {
        if (temperatureK <= 0.0 || pressureBar <= 0.0) {
            throw new IllegalArgumentException("Temperature [K] and pressure [bar] must be positive.");
        }
        double RkJ = 0.461526;
        double pStarMPa = 16.53;
        double TStarK = 1386.0;
        int[] I = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 3, 3, 3, 4, 4, 4, 5, 8, 8, 21, 23, 29, 30, 31, 32};
        int[] J = new int[]{-2, -1, 0, 1, 2, 3, 4, 5, -9, -7, -1, 0, 1, 3, -3, 0, 1, 3, 17, -4, 0, 6, -5, -2, 10, -8, -11, -6, -29, -31, -38, -39, -40, -41};
        double[] n = new double[]{0.14632971213167, -0.84548187169114, -3.756360367204, 3.3855169168385, -0.95791963387872, 0.015772038513228, -0.016616417199501, 8.1214629983568E-4, 2.8319080123804E-4, -6.0706301565874E-4, -0.018990068218419, -0.032529748770505, -0.021841717175414, -5.283835796993E-5, -4.7184321073267E-4, -3.0001780793026E-4, 4.7661393906987E-5, -4.4141845330846E-6, -7.2694996297594E-16, -3.1679644845054E-5, -2.8270797985312E-6, -8.5205128120103E-10, -2.2425281908E-6, -6.5171222895601E-7, -1.4341729937924E-13, -4.0516996860117E-7, -1.2734301741641E-9, -1.7424871230634E-10, -6.8762131295531E-19, 1.4478307828521E-20, 2.6335781662795E-23, -1.1947622640071E-23, 1.8228094581404E-24, -9.3537087292458E-26};
        double pMPa = pressureBar * 0.1;
        double pi = pMPa / 16.53;
        double tau = 1386.0 / temperatureK;
        double gamma_pi = 0.0;
        for (int k = 0; k < n.length; ++k) {
            if (I[k] == 0) continue;
            gamma_pi += -n[k] * (double)I[k] * Math.pow(7.1 - pi, I[k] - 1) * Math.pow(tau - 1.222, J[k]);
        }
        double p_kPa = pressureBar * 100.0;
        double v = 0.461526 * temperatureK / p_kPa * (pi * gamma_pi);
        return 1.0 / v;
    }

    static {
        saltParameters.put("NaCl", new double[]{-0.00433, 0.06471, 1.0166, 0.014624, 3315.6});
        saltParameters.put("KCl", new double[]{-0.46782, 4.308, 2.378, 0.022044, 2714.0});
        saltParameters.put("NaBr", new double[]{109.77, 513.04, 1.5454, 0.011019, 1618.1});
        saltParameters.put("CaCl2", new double[]{-0.63254, 0.93995, 4.2785, 0.048319, 3180.9});
        saltParameters.put("HCOONa", new double[]{0.72701, 5.2872, 1.2768, 0.01264, 2554.3});
        saltParameters.put("HCOOK", new double[]{13.5, 5.6764, 0.12357, 0.0055267, 2181.9});
        saltParameters.put("KBr", new double[]{-0.0034507, 0.41086, 3.0836, 0.037482, 3202.1});
        saltParameters.put("HCOOCs", new double[]{30.138, 8.7212, 0.094231, 0.0063516, 2139.9});
    }
}

