/*
 * Decompiled with CFR 0.152.
 */
package neqsim.physicalproperties.methods.liquidphysicalproperties.viscosity;

import neqsim.physicalproperties.methods.liquidphysicalproperties.viscosity.Viscosity;
import neqsim.physicalproperties.system.PhysicalProperties;

public class AmineViscosity
extends Viscosity {
    private static final long serialVersionUID = 1000L;

    public AmineViscosity(PhysicalProperties liquidPhase) {
        super(liquidPhase);
    }

    @Override
    public double calcViscosity() {
        super.calcViscosity();
        double wtFracA = this.liquidPhase.getPhase().getComponent("MDEA").getx() * this.liquidPhase.getPhase().getComponent("MDEA").getMolarMass() / this.liquidPhase.getPhase().getMolarMass();
        double viscA = -12.197 - 8.905 * (wtFracA += this.liquidPhase.getPhase().getComponent("MDEA+").getx() * this.liquidPhase.getPhase().getComponent("MDEA+").getMolarMass() / this.liquidPhase.getPhase().getMolarMass());
        double viscB = 1438.717 + 4218.749 * wtFracA;
        double logviscosity = viscA + viscB / this.liquidPhase.getPhase().getTemperature();
        return Math.exp(logviscosity);
    }
}

