/*
 * Decompiled with CFR 0.152.
 */
package neqsim.physicalproperties.methods.liquidphysicalproperties.viscosity;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import neqsim.physicalproperties.methods.liquidphysicalproperties.viscosity.Viscosity;
import neqsim.physicalproperties.system.PhysicalProperties;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Water
extends Viscosity {
    private static final long serialVersionUID = 1000L;
    static Logger logger = LogManager.getLogger(Water.class);
    private static final Map<String, double[]> LALIBERTE_COEFFS = new HashMap<String, double[]>();

    public Water(PhysicalProperties liquidPhase) {
        super(liquidPhase);
    }

    @Override
    public Water clone() {
        Water properties = null;
        try {
            properties = (Water)super.clone();
        }
        catch (Exception ex) {
            logger.error("Cloning failed.", (Throwable)ex);
        }
        return properties;
    }

    private boolean isAqueousSaltSolution() {
        int n = this.liquidPhase.getPhase().getNumberOfComponents();
        int waterIndex = this.indexOfWater();
        if (waterIndex < 0) {
            return false;
        }
        double ww = this.liquidPhase.getPhase().getWtFrac(waterIndex);
        double ws = 1.0 - ww;
        if (ws <= 1.0E-12) {
            return false;
        }
        double covered = 0.0;
        for (int i = 0; i < n; ++i) {
            String key;
            if (i == waterIndex || (key = this.canonicalSaltKey(this.liquidPhase.getPhase().getComponent(i).getComponentName())) == null) continue;
            covered += this.liquidPhase.getPhase().getWtFrac(i);
        }
        return covered >= 0.98 * ws;
    }

    private int indexOfWater() {
        int n = this.liquidPhase.getPhase().getNumberOfComponents();
        for (int i = 0; i < n; ++i) {
            String nm = this.liquidPhase.getPhase().getComponent(i).getComponentName();
            if (nm != null && nm.trim().equalsIgnoreCase("water")) {
                return i;
            }
            if (nm == null || !nm.trim().equalsIgnoreCase("H2O")) continue;
            return i;
        }
        return -1;
    }

    private String canonicalSaltKey(String name) {
        if (name == null) {
            return null;
        }
        String key = name.replaceAll("[\\s\\-()\\.]", "").toUpperCase(Locale.ROOT);
        if (LALIBERTE_COEFFS.containsKey(key)) {
            return key;
        }
        if ("CAC12".equals(key)) {
            key = "CACL2";
        }
        if (LALIBERTE_COEFFS.containsKey(key)) {
            return key;
        }
        return null;
    }

    private double[] coeffsForSaltOrDefault(String key) {
        if (key == null) {
            return LALIBERTE_COEFFS.get("NACL");
        }
        double[] c = LALIBERTE_COEFFS.get(key);
        return c != null ? c : LALIBERTE_COEFFS.get("NACL");
    }

    private double soluteViscosity_mPaS(double[] v, double tempC, double w_w) {
        double oneMinusWw = Math.max(0.0, 1.0 - w_w);
        double num = v[0] * Math.pow(oneMinusWw, v[1]) + v[2];
        double denTop = v[3] * tempC + 1.0;
        double expo = num / denTop;
        double den = v[4] * Math.pow(oneMinusWw, v[5]) + 1.0;
        return Math.exp(expo) / den;
    }

    @Override
    public double calcViscosity() {
        if (!this.isAqueousSaltSolution()) {
            return super.calcViscosity();
        }
        int n = this.liquidPhase.getPhase().getNumberOfComponents();
        int iw = this.indexOfWater();
        double ww = this.liquidPhase.getPhase().getWtFrac(iw);
        double tempC = this.liquidPhase.getPhase().getTemperature() - 273.15;
        this.calcPureComponentViscosity();
        double etaW_mPaS = this.pureComponentViscosity[iw];
        double etaMix_mPaS = Math.pow(etaW_mPaS, ww);
        for (int i = 0; i < n; ++i) {
            double wi;
            if (i == iw || (wi = this.liquidPhase.getPhase().getWtFrac(i)) <= 0.0) continue;
            String key = this.canonicalSaltKey(this.liquidPhase.getPhase().getComponent(i).getComponentName());
            double[] v = this.coeffsForSaltOrDefault(key);
            if (key == null) {
                logger.debug("Viscosity (Water): component '{}' not recognized as salt \u2013 using NaCl coefficients.", (Object)this.liquidPhase.getPhase().getComponent(i).getComponentName());
            }
            double etaI_mPaS = this.soluteViscosity_mPaS(v, tempC, ww);
            etaMix_mPaS *= Math.pow(etaI_mPaS, wi);
        }
        return etaMix_mPaS / 1000.0;
    }

    static {
        LALIBERTE_COEFFS.put("NACL", new double[]{16.2218, 1.3229, 1.4849, 0.0075, 30.7802, 2.0583});
        LALIBERTE_COEFFS.put("KCL", new double[]{6.4883, 1.3175, -0.7778, 0.0927, -1.3, 2.0811});
        LALIBERTE_COEFFS.put("KCOOH", new double[]{15.0442, 4.5087, 1.5924, 0.0113, 81.0129, 11.8962});
        LALIBERTE_COEFFS.put("NABR", new double[]{13.0291, 1.7478, 0.6041, 0.0108, 17.6807, 2.3831});
        LALIBERTE_COEFFS.put("CACL2", new double[]{32.0276, 0.7879, -1.1495, 0.0027, 780860.75, 5.8442});
        LALIBERTE_COEFFS.put("KBR", new double[]{348.32, -3.0E-4, -349.1532, -0.0043, -1.1044, 0.7632});
        LALIBERTE_COEFFS.put("SODIUMCHLORIDE", LALIBERTE_COEFFS.get("NACL"));
        LALIBERTE_COEFFS.put("POTASSIUMCHLORIDE", LALIBERTE_COEFFS.get("KCL"));
        LALIBERTE_COEFFS.put("POTASSIUMFORMATE", LALIBERTE_COEFFS.get("KCOOH"));
        LALIBERTE_COEFFS.put("HCOOK", LALIBERTE_COEFFS.get("KCOOH"));
        LALIBERTE_COEFFS.put("SODIUMBROMIDE", LALIBERTE_COEFFS.get("NABR"));
        LALIBERTE_COEFFS.put("POTASSIUMBROMIDE", LALIBERTE_COEFFS.get("KBR"));
        LALIBERTE_COEFFS.put("CALCIUMCHLORIDE", LALIBERTE_COEFFS.get("CACL2"));
    }
}

