/*
 * Decompiled with CFR 0.152.
 */
package neqsim.physicalproperties.methods.solidphysicalproperties.density;

import neqsim.physicalproperties.methods.methodinterface.DensityInterface;
import neqsim.physicalproperties.methods.solidphysicalproperties.SolidPhysicalPropertyMethod;
import neqsim.physicalproperties.system.PhysicalProperties;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Density
extends SolidPhysicalPropertyMethod
implements DensityInterface {
    private static final long serialVersionUID = 1000L;
    static Logger logger = LogManager.getLogger(Density.class);

    public Density(PhysicalProperties liquidPhase) {
        super(liquidPhase);
    }

    @Override
    public Density clone() {
        Density properties = null;
        try {
            properties = (Density)super.clone();
        }
        catch (Exception ex) {
            logger.error("Cloning failed.", (Throwable)ex);
        }
        return properties;
    }

    @Override
    public double calcDensity() {
        double tempVar = 0.0;
        if (this.solidPhase.getPhase().useVolumeCorrection()) {
            for (int i = 0; i < this.solidPhase.getPhase().getNumberOfComponents(); ++i) {
                tempVar += this.solidPhase.getPhase().getComponent(i).getx() * (this.solidPhase.getPhase().getComponent(i).getVolumeCorrection() + this.solidPhase.getPhase().getComponent(i).getVolumeCorrectionT() * (this.solidPhase.getPhase().getTemperature() - 288.15));
            }
        }
        return 1.0 / (this.solidPhase.getPhase().getMolarVolume() - tempVar) * this.solidPhase.getPhase().getMolarMass() * 100000.0;
    }
}

