/*
 * Decompiled with CFR 0.152.
 */
package neqsim.physicalproperties.methods.solidphysicalproperties.diffusivity;

import neqsim.physicalproperties.methods.methodinterface.DiffusivityInterface;
import neqsim.physicalproperties.methods.solidphysicalproperties.SolidPhysicalPropertyMethod;
import neqsim.physicalproperties.system.PhysicalProperties;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Diffusivity
extends SolidPhysicalPropertyMethod
implements DiffusivityInterface {
    private static final long serialVersionUID = 1000L;
    static Logger logger = LogManager.getLogger(Diffusivity.class);
    double[][] binaryDiffusionCoefficients;
    double[] effectiveDiffusionCoefficient;

    public Diffusivity(PhysicalProperties solidPhase) {
        super(solidPhase);
        this.binaryDiffusionCoefficients = new double[solidPhase.getPhase().getNumberOfComponents()][solidPhase.getPhase().getNumberOfComponents()];
        this.effectiveDiffusionCoefficient = new double[solidPhase.getPhase().getNumberOfComponents()];
    }

    @Override
    public Diffusivity clone() {
        Diffusivity properties = null;
        try {
            properties = (Diffusivity)super.clone();
        }
        catch (Exception ex) {
            logger.error("Cloning failed.", (Throwable)ex);
        }
        if (this.binaryDiffusionCoefficients != null && this.binaryDiffusionCoefficients.length > 0) {
            properties.binaryDiffusionCoefficients = (double[][])this.binaryDiffusionCoefficients.clone();
            for (int i = 0; i < this.binaryDiffusionCoefficients.length; ++i) {
                if (this.binaryDiffusionCoefficients[i] == null || properties.binaryDiffusionCoefficients[i] == null) continue;
                System.arraycopy(this.binaryDiffusionCoefficients[i], 0, properties.binaryDiffusionCoefficients[i], 0, this.binaryDiffusionCoefficients[i].length);
            }
        }
        if (this.effectiveDiffusionCoefficient != null && this.effectiveDiffusionCoefficient.length > 0) {
            properties.effectiveDiffusionCoefficient = (double[])this.effectiveDiffusionCoefficient.clone();
        }
        return properties;
    }

    @Override
    public double[][] calcDiffusionCoefficients(int binaryDiffusionCoefficientMethod, int multicomponentDiffusionMethod) {
        return this.binaryDiffusionCoefficients;
    }

    @Override
    public void calcEffectiveDiffusionCoefficients() {
    }

    @Override
    public double getMaxwellStefanBinaryDiffusionCoefficient(int i, int j) {
        return this.binaryDiffusionCoefficients[i][j];
    }

    @Override
    public double getEffectiveDiffusionCoefficient(int i) {
        return this.effectiveDiffusionCoefficient[i];
    }

    @Override
    public double getFickBinaryDiffusionCoefficient(int i, int j) {
        double nonIdealCorrection = 1.0;
        return this.binaryDiffusionCoefficients[i][j] * nonIdealCorrection;
    }

    @Override
    public double calcBinaryDiffusionCoefficient(int i, int j, int method) {
        throw new UnsupportedOperationException("Unimplemented method 'calcBinaryDiffusionCoefficient");
    }
}

