/*
 * Decompiled with CFR 0.152.
 */
package neqsim.physicalproperties.system;

import neqsim.util.exception.InvalidInputException;

public enum PhysicalPropertyModel {
    DEFAULT(0),
    WATER(1),
    GLYCOL(2),
    AMINE(3),
    CO2WATER(4),
    BASIC(6),
    SALT_WATER(7);

    private final int value;
    private static final PhysicalPropertyModel[] copyOfValues;

    private PhysicalPropertyModel(int value) {
        this.value = value;
    }

    @Deprecated
    public int getValue() {
        return this.value;
    }

    public static PhysicalPropertyModel byName(String name) {
        for (PhysicalPropertyModel pt : copyOfValues) {
            if (!pt.name().equals(name.toUpperCase())) continue;
            return pt;
        }
        throw new RuntimeException(new InvalidInputException("PhysicalPropertyModel", "byName", "name", "is not valid."));
    }

    public static PhysicalPropertyModel byValue(int value) {
        for (PhysicalPropertyModel pt : copyOfValues) {
            if (pt.getValue() != value) continue;
            return pt;
        }
        throw new RuntimeException(new InvalidInputException("PhysicalPropertyModel", "byValue", "value", "is not valid."));
    }

    static {
        copyOfValues = PhysicalPropertyModel.values();
    }
}

