/*
 * Decompiled with CFR 0.152.
 */
package neqsim.physicalproperties.util.parameterfitting.purecomponentparameterfitting.purecompinterfacetension;

import java.sql.ResultSet;
import java.util.ArrayList;
import neqsim.physicalproperties.util.parameterfitting.purecomponentparameterfitting.purecompinterfacetension.ParachorFunction;
import neqsim.statistics.parameterfitting.SampleSet;
import neqsim.statistics.parameterfitting.SampleValue;
import neqsim.statistics.parameterfitting.nonlinearparameterfitting.LevenbergMarquardt;
import neqsim.thermo.system.SystemSrkCPAstatoil;
import neqsim.util.ExcludeFromJacocoGeneratedReport;
import neqsim.util.database.NeqSimDataBase;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TestParachorFit {
    static Logger logger = LogManager.getLogger(TestParachorFit.class);

    @ExcludeFromJacocoGeneratedReport
    public static void main(String[] args) {
        LevenbergMarquardt optim = new LevenbergMarquardt();
        ArrayList<SampleValue> sampleList = new ArrayList<SampleValue>();
        try (NeqSimDataBase database = new NeqSimDataBase();
             ResultSet dataSet = database.getResultSet("SELECT * FROM purecomponentsurfacetension WHERE ComponentName='MEG'");){
            while (dataSet.next()) {
                ParachorFunction function = new ParachorFunction();
                double[] guess = new double[]{207.2};
                function.setInitialGuess(guess);
                SystemSrkCPAstatoil testSystem = new SystemSrkCPAstatoil(280.0, 0.001);
                testSystem.addComponent(dataSet.getString("ComponentName"), 100.0);
                testSystem.setPressure(Double.parseDouble(dataSet.getString("Pressure")));
                testSystem.setTemperature(Double.parseDouble(dataSet.getString("Temperature")));
                testSystem.getInterphaseProperties().setInterfacialTensionModel(-10);
                testSystem.useVolumeCorrection(true);
                testSystem.setMixingRule(2);
                testSystem.init(0);
                testSystem.setNumberOfPhases(2);
                testSystem.init(3);
                double[] sample1 = new double[]{testSystem.getTemperature(), testSystem.getPressure()};
                double[] standardDeviation1 = new double[]{0.1, 0.1};
                SampleValue sample = new SampleValue(Double.parseDouble(dataSet.getString("SurfaceTension")), Double.parseDouble(dataSet.getString("StandardDeviation")), sample1, standardDeviation1);
                sample.setFunction(function);
                sample.setThermodynamicSystem(testSystem);
                sampleList.add(sample);
            }
        }
        catch (Exception ex) {
            logger.error("database error", (Throwable)ex);
        }
        SampleSet sampleSet = new SampleSet(sampleList);
        optim.setSampleSet(sampleSet);
        optim.solve();
        optim.displayCurveFit();
        optim.displayCurveFit();
    }
}

