/*
 * Decompiled with CFR 0.152.
 */
package neqsim.process.controllerdevice;

import java.util.UUID;
import neqsim.process.controllerdevice.ControllerDeviceInterface;
import neqsim.process.measurementdevice.MeasurementDeviceInterface;
import neqsim.util.NamedBaseClass;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ControllerDeviceBaseClass
extends NamedBaseClass
implements ControllerDeviceInterface {
    private static final long serialVersionUID = 1000L;
    static Logger logger = LogManager.getLogger(ControllerDeviceBaseClass.class);
    protected UUID calcIdentifier;
    private String unit = "[?]";
    private MeasurementDeviceInterface transmitter = null;
    private double controllerSetPoint = 0.0;
    private double oldError = 0.0;
    private double oldoldError = 0.0;
    private double error = 0.0;
    private double response = 30.0;
    int propConstant = 1;
    private boolean reverseActing = false;
    private double Kp = 1.0;
    private double Ti = 300.0;
    private double Td = 0.0;
    private double TintValue = 0.0;
    boolean isActive = true;

    public ControllerDeviceBaseClass() {
        this("controller");
    }

    @Override
    public void setActive(boolean isActive) {
        this.isActive = isActive;
    }

    @Override
    public boolean isActive() {
        return this.isActive;
    }

    public ControllerDeviceBaseClass(String name) {
        super(name);
    }

    @Override
    public void setTransmitter(MeasurementDeviceInterface device) {
        this.transmitter = device;
    }

    @Override
    public double getMeasuredValue() {
        return this.transmitter.getMeasuredValue();
    }

    @Override
    public void runTransient(double initResponse, double dt, UUID id) {
        if (!this.isActive) {
            this.response = initResponse;
            this.calcIdentifier = id;
            return;
        }
        if (this.isReverseActing()) {
            this.propConstant = -1;
        }
        this.oldoldError = this.error;
        this.oldError = this.error;
        this.error = this.transmitter.getMeasuredPercentValue() - (this.controllerSetPoint - this.transmitter.getMinimumValue()) / (this.transmitter.getMaximumValue() - this.transmitter.getMinimumValue()) * 100.0;
        if (this.Ti != 0.0) {
            this.TintValue = this.Kp / this.Ti * this.error;
        }
        double TderivValue = this.Kp * this.Td * ((this.error - 2.0 * this.oldError + this.oldoldError) / (dt * dt));
        this.response = initResponse + (double)this.propConstant * (this.Kp * (this.error - this.oldError) / dt + this.TintValue + TderivValue) * dt;
        this.calcIdentifier = id;
    }

    @Override
    public void setControllerSetPoint(double signal) {
        this.controllerSetPoint = signal;
    }

    @Override
    public String getUnit() {
        return this.unit;
    }

    @Override
    public void setUnit(String unit) {
        this.unit = unit;
    }

    @Override
    public double getResponse() {
        return this.response;
    }

    @Override
    public boolean isReverseActing() {
        return this.reverseActing;
    }

    @Override
    public void setReverseActing(boolean reverseActing) {
        this.reverseActing = reverseActing;
    }

    public double getKp() {
        return this.Kp;
    }

    public void setKp(double Kp) {
        if (Kp >= 0.0) {
            this.Kp = Kp;
        } else {
            logger.warn("Negative Kp is not allowed. Use setReverseActing.");
        }
    }

    @Override
    public void setControllerParameters(double Kp, double Ti, double Td) {
        this.setKp(Kp);
        this.setTi(Ti);
        this.setTd(Td);
    }

    public double getTi() {
        return this.Ti;
    }

    public void setTi(double Ti) {
        if (Ti >= 0.0) {
            this.Ti = Ti;
        } else {
            logger.warn("Negative Ti is not allowed.");
        }
    }

    public double getTd() {
        return this.Td;
    }

    public void setTd(double Td) {
        if (Td >= 0.0) {
            this.Td = Td;
        } else {
            logger.warn("Negative Td is not allowed.");
        }
    }
}

