/*
 * Decompiled with CFR 0.152.
 */
package neqsim.process.equipment.blackoil;

import neqsim.blackoil.BlackOilFlashResult;
import neqsim.blackoil.SystemBlackOil;

public class BlackOilSeparator {
    private final String name;
    private SystemBlackOil inlet;
    private final double P_out;
    private final double T_out;
    private SystemBlackOil oilOut;
    private SystemBlackOil gasOut;
    private SystemBlackOil waterOut;

    public BlackOilSeparator(String name, SystemBlackOil inlet, double P_out, double T_out) {
        this.name = name;
        this.inlet = inlet;
        this.P_out = P_out;
        this.T_out = T_out;
    }

    public String getName() {
        return this.name;
    }

    public void setInlet(SystemBlackOil inlet) {
        this.inlet = inlet;
    }

    public SystemBlackOil getInlet() {
        return this.inlet;
    }

    public SystemBlackOil getOilOut() {
        return this.oilOut;
    }

    public SystemBlackOil getGasOut() {
        return this.gasOut;
    }

    public SystemBlackOil getWaterOut() {
        return this.waterOut;
    }

    public void run() {
        this.inlet.setPressure(this.P_out);
        this.inlet.setTemperature(this.T_out);
        BlackOilFlashResult r = this.inlet.flash();
        this.oilOut = this.inlet.copyShallow();
        this.gasOut = this.inlet.copyShallow();
        this.waterOut = this.inlet.copyShallow();
        double O_oil_std = r.O_std;
        double G_oil_std = r.Rs * r.O_std;
        this.oilOut.setStdTotals(O_oil_std, G_oil_std, 0.0);
        this.oilOut.setPressure(this.P_out);
        this.oilOut.setTemperature(this.T_out);
        double G_gas_std = r.Gf_std;
        double O_gas_std = r.Rv * r.Gf_std;
        this.gasOut.setStdTotals(O_gas_std, G_gas_std, 0.0);
        this.gasOut.setPressure(this.P_out);
        this.gasOut.setTemperature(this.T_out);
        this.waterOut.setStdTotals(0.0, 0.0, r.W_std);
        this.waterOut.setPressure(this.P_out);
        this.waterOut.setTemperature(this.T_out);
    }
}

