/*
 * Decompiled with CFR 0.152.
 */
package neqsim.process.equipment.compressor;

import java.util.Arrays;
import java.util.Objects;
import neqsim.process.equipment.compressor.BoundaryCurveInterface;
import org.apache.commons.math3.analysis.polynomials.PolynomialFunction;
import org.apache.commons.math3.fitting.PolynomialCurveFitter;
import org.apache.commons.math3.fitting.WeightedObservedPoints;

public abstract class BoundaryCurve
implements BoundaryCurveInterface {
    private static final long serialVersionUID = 1000L;
    protected double[] flow;
    protected double[] head;
    protected double[] chartConditions;
    protected boolean isActive = false;
    protected WeightedObservedPoints flowFitter = new WeightedObservedPoints();
    protected PolynomialFunction flowFitterFunc = null;

    protected BoundaryCurve() {
    }

    protected BoundaryCurve(double[] flow, double[] head) {
        this.setCurve(null, flow, head);
    }

    @Override
    public void setCurve(double[] chartConditions, double[] flow, double[] head) {
        this.flow = flow;
        this.head = head;
        this.chartConditions = chartConditions;
        this.flowFitter = new WeightedObservedPoints();
        for (int i = 0; i < flow.length; ++i) {
            this.flowFitter.add(head[i], flow[i]);
        }
        PolynomialCurveFitter fitter = PolynomialCurveFitter.create(2);
        this.flowFitterFunc = new PolynomialFunction(fitter.fit(this.flowFitter.toList()));
        this.isActive = true;
    }

    @Override
    public double getFlow(double head) {
        return this.flowFitterFunc.value(head);
    }

    @Override
    public boolean isActive() {
        return this.isActive;
    }

    @Override
    public void setActive(boolean isActive) {
        this.isActive = isActive;
    }

    public double[] getFlow() {
        return this.flow;
    }

    public double[] getHead() {
        return this.head;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.chartConditions);
        result = 31 * result + Arrays.hashCode(this.flow);
        result = 31 * result + Arrays.hashCode(this.head);
        result = 31 * result + Objects.hash(this.flowFitterFunc, this.isActive);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BoundaryCurve other = (BoundaryCurve)obj;
        return Arrays.equals(this.chartConditions, other.chartConditions) && Arrays.equals(this.flow, other.flow) && Arrays.equals(this.head, other.head) && Objects.equals(this.flowFitterFunc, other.flowFitterFunc) && this.isActive == other.isActive;
    }
}

