/*
 * Decompiled with CFR 0.152.
 */
package neqsim.process.equipment.compressor;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import neqsim.datapresentation.jfreechart.Graph2b;
import neqsim.process.equipment.compressor.CompressorChartInterface;
import neqsim.process.equipment.compressor.CompressorCurve;
import neqsim.process.equipment.compressor.SafeSplineStoneWallCurve;
import neqsim.process.equipment.compressor.SafeSplineSurgeCurve;
import neqsim.process.equipment.compressor.StoneWallCurve;
import neqsim.util.exception.InvalidInputException;
import org.apache.commons.math3.analysis.polynomials.PolynomialFunction;
import org.apache.commons.math3.fitting.PolynomialCurveFitter;
import org.apache.commons.math3.fitting.WeightedObservedPoints;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CompressorChart
implements CompressorChartInterface,
Serializable {
    private static final long serialVersionUID = 1000L;
    static Logger logger = LogManager.getLogger(CompressorChart.class);
    ArrayList<CompressorCurve> chartValues = new ArrayList();
    ArrayList<Double> chartSpeeds = new ArrayList();
    SafeSplineSurgeCurve surgeCurve = new SafeSplineSurgeCurve();
    StoneWallCurve stoneWallCurve = new SafeSplineStoneWallCurve();
    boolean isSurge = false;
    double maxSpeedCurve = 0.0;
    double minSpeedCurve = 1.0E10;
    boolean isStoneWall = false;
    double refMW;
    private String headUnit = "meter";
    private boolean useCompressorChart = false;
    double refTemperature;
    double refPressure;
    double referenceSpeed = 1000.0;
    double refZ;
    private boolean useRealKappa = false;
    double[] chartConditions = null;
    final WeightedObservedPoints reducedHeadFitter = new WeightedObservedPoints();
    final WeightedObservedPoints reducedFlowFitter = new WeightedObservedPoints();
    final WeightedObservedPoints fanLawCorrectionFitter = new WeightedObservedPoints();
    final WeightedObservedPoints reducedPolytropicEfficiencyFitter = new WeightedObservedPoints();
    PolynomialFunction reducedHeadFitterFunc = null;
    PolynomialFunction reducedPolytropicEfficiencyFunc = null;
    PolynomialFunction fanLawCorrectionFunc = null;
    double[] speed;
    double[][] flow;
    double[][] flowPolytropicEfficiency;
    double[][] head;
    double[][] polytropicEfficiency;
    double[][] redflow;
    double[][] redflowPolytropicEfficiency;
    double[][] redhead;
    double[][] redpolytropicEfficiency;

    @Override
    public void generateSurgeCurve() {
        int n = this.chartValues.size();
        TreeMap<Double, Double> uniqueSurgePoints = new TreeMap<Double, Double>();
        for (int i = 0; i < n; ++i) {
            CompressorCurve curve = this.chartValues.get(i);
            int minIdx = 0;
            for (int j = 1; j < curve.flow.length; ++j) {
                if (!(curve.flow[j] < curve.flow[minIdx])) continue;
                minIdx = j;
            }
            double flowVal = curve.flow[minIdx];
            double headVal = curve.head[minIdx];
            if (uniqueSurgePoints.containsKey(flowVal)) continue;
            uniqueSurgePoints.put(flowVal, headVal);
        }
        double[] surgeFlow = new double[uniqueSurgePoints.size()];
        double[] surgeHead = new double[uniqueSurgePoints.size()];
        int idx = 0;
        for (Map.Entry entry : uniqueSurgePoints.entrySet()) {
            surgeFlow[idx] = (Double)entry.getKey();
            surgeHead[idx] = (Double)entry.getValue();
            ++idx;
        }
        this.setSurgeCurve(new SafeSplineSurgeCurve(surgeFlow, surgeHead));
    }

    @Override
    public void generateStoneWallCurve() {
        int n = this.chartValues.size();
        TreeMap<Double, Double> uniqueStoneWallPoints = new TreeMap<Double, Double>();
        for (int i = 0; i < n; ++i) {
            CompressorCurve curve = this.chartValues.get(i);
            int maxIdx = 0;
            for (int j = 1; j < curve.flow.length; ++j) {
                if (!(curve.flow[j] > curve.flow[maxIdx])) continue;
                maxIdx = j;
            }
            double flowVal = curve.flow[maxIdx];
            double headVal = curve.head[maxIdx];
            if (uniqueStoneWallPoints.containsKey(flowVal)) continue;
            uniqueStoneWallPoints.put(flowVal, headVal);
        }
        double[] stoneFlow = new double[uniqueStoneWallPoints.size()];
        double[] stoneHead = new double[uniqueStoneWallPoints.size()];
        int idx = 0;
        for (Map.Entry entry : uniqueStoneWallPoints.entrySet()) {
            stoneFlow[idx] = (Double)entry.getKey();
            stoneHead[idx] = (Double)entry.getValue();
            ++idx;
        }
        this.setStoneWallCurve(new SafeSplineStoneWallCurve(stoneFlow, stoneHead));
    }

    @Override
    public void addCurve(double speed, double[] flow, double[] head, double[] polytropicEfficiency) {
        CompressorCurve curve = new CompressorCurve(speed, flow, head, flow, polytropicEfficiency);
        this.chartValues.add(curve);
    }

    @Override
    public void addCurve(double speed, double[] flow, double[] head, double[] flowPolytropicEfficiency, double[] polytropicEfficiency) {
        CompressorCurve curve = new CompressorCurve(speed, flow, head, flowPolytropicEfficiency, polytropicEfficiency);
        this.chartValues.add(curve);
    }

    @Override
    public void setCurves(double[] chartConditions, double[] speed, double[][] flow, double[][] head, double[][] polyEff) {
        this.setCurves(chartConditions, speed, flow, head, flow, polyEff);
    }

    @Override
    public void setCurves(double[] chartConditions, double[] speed, double[][] flow, double[][] head, double[][] flowPolyEff, double[][] polyEff) {
        this.speed = speed;
        this.head = head;
        this.polytropicEfficiency = polyEff;
        this.flow = flow;
        this.flowPolytropicEfficiency = flowPolyEff;
        int maxLength = 0;
        for (double[] f : flow) {
            if (f.length <= maxLength) continue;
            maxLength = f.length;
        }
        int maxLengthPolyEff = 0;
        for (double[] f : this.flowPolytropicEfficiency) {
            if (f.length <= maxLengthPolyEff) continue;
            maxLengthPolyEff = f.length;
        }
        this.redhead = new double[head.length][maxLength];
        this.redpolytropicEfficiency = new double[polyEff.length][maxLength];
        this.redflow = new double[flow.length][maxLength];
        this.redflowPolytropicEfficiency = new double[polyEff.length][maxLength];
        for (int i = 0; i < speed.length; ++i) {
            int j;
            if (speed[i] > this.maxSpeedCurve) {
                this.maxSpeedCurve = speed[i];
            }
            if (speed[i] < this.minSpeedCurve) {
                this.minSpeedCurve = speed[i];
            }
            CompressorCurve curve = new CompressorCurve(speed[i], flow[i], head[i], flowPolyEff[i], polyEff[i]);
            this.chartValues.add(curve);
            for (j = 0; j < flow[i].length; ++j) {
                this.redflow[i][j] = flow[i][j] / speed[i];
                this.redhead[i][j] = head[i][j] / speed[i] / speed[i];
                this.reducedHeadFitter.add(this.redflow[i][j], this.redhead[i][j]);
                double flowFanLaw = flow[i][j] * speed[i] / speed[0];
                this.fanLawCorrectionFitter.add(speed[i] / speed[0], flow[i][j] / flowFanLaw);
            }
            for (j = 0; j < this.flowPolytropicEfficiency[i].length; ++j) {
                this.redflowPolytropicEfficiency[i][j] = flowPolyEff[i][j] / speed[i];
                this.redpolytropicEfficiency[i][j] = polyEff[i][j];
                this.reducedPolytropicEfficiencyFitter.add(this.redflowPolytropicEfficiency[i][j], this.redpolytropicEfficiency[i][j]);
            }
            for (j = this.flowPolytropicEfficiency[i].length; j < maxLengthPolyEff; ++j) {
                this.redflowPolytropicEfficiency[i][j] = 0.0;
                this.redpolytropicEfficiency[i][j] = 0.0;
            }
        }
        this.referenceSpeed = (this.maxSpeedCurve + this.minSpeedCurve) / 2.0;
        PolynomialCurveFitter fitter = PolynomialCurveFitter.create(2);
        this.reducedHeadFitterFunc = new PolynomialFunction(fitter.fit(this.reducedHeadFitter.toList()));
        this.reducedPolytropicEfficiencyFunc = new PolynomialFunction(fitter.fit(this.reducedPolytropicEfficiencyFitter.toList()));
        this.fanLawCorrectionFunc = new PolynomialFunction(fitter.fit(this.fanLawCorrectionFitter.toList()));
        this.setUseCompressorChart(true);
    }

    public void fitReducedCurve() {
    }

    @Override
    public double getPolytropicHead(double flow, double speed) {
        return this.reducedHeadFitterFunc.value(flow / speed) * speed * speed;
    }

    @Override
    public double getPolytropicEfficiency(double flow, double speed) {
        return this.reducedPolytropicEfficiencyFunc.value(flow / speed);
    }

    @Override
    public int getSpeed(double flow, double head) {
        int iter = 1;
        double error = 1.0;
        double derrordspeed = 1.0;
        double newspeed = this.referenceSpeed;
        double newhead = 0.0;
        double oldspeed = newspeed + 1.0;
        double oldhead = this.getPolytropicHead(flow, oldspeed);
        double olderror = oldhead - head;
        do {
            newhead = this.getPolytropicHead(flow, newspeed);
            error = newhead - head;
            derrordspeed = (error - olderror) / (newspeed - oldspeed);
            newspeed -= error / derrordspeed;
        } while (Math.abs(error) > 1.0E-6 && ++iter < 100);
        return (int)Math.round(newspeed);
    }

    @Override
    public double getFlow(double head, double speed, double guessFlow) {
        int iter = 1;
        double error = 1.0;
        double derrordspeed = 1.0;
        double newflow = guessFlow;
        double newhead = 0.0;
        double oldflow = newflow * 1.1;
        double oldhead = this.getPolytropicHead(oldflow, speed);
        double olderror = oldhead - head;
        do {
            newhead = this.getPolytropicHead(newflow, speed) / (this.getPolytropicEfficiency(newflow, speed) / 100.0);
            error = newhead - head;
            derrordspeed = (error - olderror) / (newflow - oldflow);
            newflow -= error / derrordspeed;
        } while (Math.abs(error) > 1.0E-6 && ++iter < 100);
        return newflow;
    }

    public void addSurgeCurve(double[] flow, double[] head) {
        this.surgeCurve = new SafeSplineSurgeCurve(flow, head);
    }

    public double polytropicEfficiency(double flow, double speed) {
        return 100.0;
    }

    public boolean checkSurge1(double flow, double head) {
        return false;
    }

    public boolean checkSurge2(double flow, double speed) {
        return false;
    }

    public boolean checkStoneWall(double flow, double speed) {
        return false;
    }

    @Override
    public void setReferenceConditions(double refMW, double refTemperature, double refPressure, double refZ) {
        this.refMW = refMW;
        this.refTemperature = refTemperature;
        this.refPressure = refPressure;
        this.refZ = refZ;
    }

    @Override
    public SafeSplineSurgeCurve getSurgeCurve() {
        return this.surgeCurve;
    }

    @Override
    public void setSurgeCurve(SafeSplineSurgeCurve surgeCurve) {
        this.surgeCurve = surgeCurve;
    }

    @Override
    public StoneWallCurve getStoneWallCurve() {
        return this.stoneWallCurve;
    }

    @Override
    public void setStoneWallCurve(StoneWallCurve stoneWallCurve) {
        this.stoneWallCurve = stoneWallCurve;
    }

    @Override
    public boolean isUseCompressorChart() {
        return this.useCompressorChart;
    }

    @Override
    public void setUseCompressorChart(boolean useCompressorChart) {
        this.useCompressorChart = useCompressorChart;
    }

    @Override
    public String getHeadUnit() {
        return this.headUnit;
    }

    @Override
    public void setHeadUnit(String headUnit) {
        if (!headUnit.equals("meter") && !headUnit.equals("kJ/kg")) {
            throw new RuntimeException(new InvalidInputException(this, "setHeadUnit", "headUnit", "does not support value " + headUnit));
        }
        this.headUnit = headUnit;
        this.headUnit = headUnit;
    }

    @Override
    public boolean useRealKappa() {
        return this.useRealKappa;
    }

    @Override
    public void setUseRealKappa(boolean useRealKappa) {
        this.useRealKappa = useRealKappa;
    }

    @Override
    public void plot() {
        Graph2b graph = new Graph2b(this.flow, this.head, (String[])Arrays.stream(this.speed).mapToObj(String::valueOf).toArray(String[]::new), "head vs flow", "flow", "head");
        graph.setVisible(true);
        Graph2b graph2 = new Graph2b(this.flow, this.polytropicEfficiency, (String[])Arrays.stream(this.speed).mapToObj(String::valueOf).toArray(String[]::new), "eff vs flow", "flow", "eff");
        graph2.setVisible(true);
        Graph2b graph3 = new Graph2b(this.redflow, this.redhead, (String[])Arrays.stream(this.speed).mapToObj(String::valueOf).toArray(String[]::new), "red head vs red flow", "red flow", "red head");
        graph3.setVisible(true);
        Graph2b graph4 = new Graph2b(this.redflow, this.polytropicEfficiency, (String[])Arrays.stream(this.speed).mapToObj(String::valueOf).toArray(String[]::new), "red eff vs red dflow", "red flow", "red eff");
        graph4.setVisible(true);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.chartConditions);
        result = 31 * result + Arrays.deepHashCode((Object[])this.flow);
        result = 31 * result + Arrays.deepHashCode((Object[])this.head);
        result = 31 * result + Arrays.deepHashCode((Object[])this.polytropicEfficiency);
        result = 31 * result + Arrays.deepHashCode((Object[])this.redflow);
        result = 31 * result + Arrays.deepHashCode((Object[])this.redhead);
        result = 31 * result + Arrays.deepHashCode((Object[])this.redpolytropicEfficiency);
        result = 31 * result + Arrays.hashCode(this.speed);
        result = 31 * result + Objects.hash(this.chartValues, this.fanLawCorrectionFunc, this.headUnit, this.isStoneWall, this.isSurge, this.maxSpeedCurve, this.minSpeedCurve, this.reducedHeadFitterFunc, this.reducedPolytropicEfficiencyFunc, this.refMW, this.refPressure, this.refTemperature, this.refZ, this.referenceSpeed, this.stoneWallCurve, this.surgeCurve, this.useCompressorChart, this.useRealKappa);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CompressorChart other = (CompressorChart)obj;
        return Arrays.equals(this.chartConditions, other.chartConditions) && Objects.equals(this.chartValues, other.chartValues) && Objects.equals(this.fanLawCorrectionFunc, other.fanLawCorrectionFunc) && Arrays.deepEquals((Object[])this.flow, (Object[])other.flow) && Arrays.deepEquals((Object[])this.head, (Object[])other.head) && Objects.equals(this.headUnit, other.headUnit) && this.isStoneWall == other.isStoneWall && this.isSurge == other.isSurge && Double.doubleToLongBits(this.maxSpeedCurve) == Double.doubleToLongBits(other.maxSpeedCurve) && Double.doubleToLongBits(this.minSpeedCurve) == Double.doubleToLongBits(other.minSpeedCurve) && Arrays.deepEquals((Object[])this.polytropicEfficiency, (Object[])other.polytropicEfficiency) && Arrays.deepEquals((Object[])this.redflow, (Object[])other.redflow) && Arrays.deepEquals((Object[])this.redhead, (Object[])other.redhead) && Arrays.deepEquals((Object[])this.redpolytropicEfficiency, (Object[])other.redpolytropicEfficiency) && Objects.equals(this.reducedHeadFitterFunc, other.reducedHeadFitterFunc) && Objects.equals(this.reducedPolytropicEfficiencyFunc, other.reducedPolytropicEfficiencyFunc) && Double.doubleToLongBits(this.refMW) == Double.doubleToLongBits(other.refMW) && Double.doubleToLongBits(this.refPressure) == Double.doubleToLongBits(other.refPressure) && Double.doubleToLongBits(this.refTemperature) == Double.doubleToLongBits(other.refTemperature) && Double.doubleToLongBits(this.refZ) == Double.doubleToLongBits(other.refZ) && Double.doubleToLongBits(this.referenceSpeed) == Double.doubleToLongBits(other.referenceSpeed) && Arrays.equals(this.speed, other.speed) && Objects.equals(this.stoneWallCurve, other.stoneWallCurve) && Objects.equals(this.surgeCurve, other.surgeCurve) && this.useCompressorChart == other.useCompressorChart && this.useRealKappa == other.useRealKappa;
    }

    public double getMaxSpeedCurve() {
        return this.maxSpeedCurve;
    }

    public void setMaxSpeedCurve(double maxSpeedCurve) {
        this.maxSpeedCurve = maxSpeedCurve;
    }

    @Override
    public double getMinSpeedCurve() {
        return this.minSpeedCurve;
    }

    public void setMinSpeedCurve(double minSpeedCurve) {
        this.minSpeedCurve = minSpeedCurve;
    }
}

