/*
 * Decompiled with CFR 0.152.
 */
package neqsim.process.equipment.compressor;

import java.util.ArrayList;
import neqsim.process.equipment.compressor.CompressorChartAlternativeMapLookup;
import neqsim.process.equipment.compressor.CompressorCurve;
import org.apache.commons.math3.analysis.interpolation.SplineInterpolator;
import org.apache.commons.math3.analysis.polynomials.PolynomialSplineFunction;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CompressorChartAlternativeMapLookupExtrapolate
extends CompressorChartAlternativeMapLookup {
    private static final long serialVersionUID = 1000L;
    static Logger logger = LogManager.getLogger(CompressorChartAlternativeMapLookupExtrapolate.class);

    @Override
    public ArrayList<Double> getClosestRefSpeeds(double speed) {
        ArrayList<Double> closestSpeeds = new ArrayList<Double>();
        for (CompressorCurve curve : this.chartValues) {
            closestSpeeds.add(curve.speed);
        }
        if (closestSpeeds.isEmpty()) {
            throw new IllegalStateException("No reference speeds available. Ensure chartValues is populated.");
        }
        closestSpeeds.sort(Double::compareTo);
        ArrayList<Double> result = new ArrayList<Double>();
        for (int i = 0; i < closestSpeeds.size(); ++i) {
            if (speed == (Double)closestSpeeds.get(i)) {
                result.add(speed);
                return result;
            }
            if (!(speed < (Double)closestSpeeds.get(i))) continue;
            if (i > 0) {
                result.add((Double)closestSpeeds.get(i - 1));
            }
            result.add((Double)closestSpeeds.get(i));
            return result;
        }
        result.add((Double)closestSpeeds.get(closestSpeeds.size() - 1));
        return result;
    }

    @Override
    public double getPolytropicHead(double flow, double speed) {
        if (speed == 0.0) {
            logger.debug("Speed is 0, returning head as 0.");
            return 0.0;
        }
        ArrayList<Double> closestRefSpeeds = this.getClosestRefSpeeds(speed);
        SplineInterpolator interpolator = new SplineInterpolator();
        ArrayList<Double> interpolatedHeads = new ArrayList<Double>();
        ArrayList<Double> speeds = new ArrayList<Double>();
        for (double refSpeed : closestRefSpeeds) {
            CompressorCurve curve = this.getCurveAtRefSpeed(refSpeed);
            PolynomialSplineFunction spline = interpolator.interpolate(curve.flow, curve.head);
            double headValue = this.extrapolateOrInterpolate(flow, curve.flow, curve.head, spline);
            interpolatedHeads.add(headValue);
            speeds.add(refSpeed);
        }
        if (interpolatedHeads.size() == 1) {
            return (Double)interpolatedHeads.get(0) * (speed / (Double)speeds.get(0));
        }
        double speed1 = (Double)speeds.get(0);
        double speed2 = (Double)speeds.get(1);
        double head1 = (Double)interpolatedHeads.get(0);
        double head2 = (Double)interpolatedHeads.get(1);
        double interpolatedHead = this.extrapolateOrInterpolateSpeed(speed, speed1, speed2, head1, head2);
        return interpolatedHead *= speed / Math.max(speed1, speed2);
    }

    @Override
    public double getPolytropicEfficiency(double flow, double speed) {
        ArrayList<Double> closestRefSpeeds = this.getClosestRefSpeeds(speed);
        if (closestRefSpeeds.isEmpty()) {
            throw new IllegalArgumentException("No valid reference speeds found for the given speed: " + speed);
        }
        SplineInterpolator interpolator = new SplineInterpolator();
        ArrayList<Double> interpolatedEfficiencies = new ArrayList<Double>();
        ArrayList<Double> speeds = new ArrayList<Double>();
        for (double refSpeed : closestRefSpeeds) {
            CompressorCurve curve = this.getCurveAtRefSpeed(refSpeed);
            if (curve.flow.length == 0 || curve.polytropicEfficiency.length == 0) {
                throw new IllegalArgumentException("Invalid curve data for speed: " + refSpeed);
            }
            PolynomialSplineFunction spline = interpolator.interpolate(curve.flow, curve.polytropicEfficiency);
            double efficiencyValue = this.extrapolateOrInterpolate(flow, curve.flow, curve.polytropicEfficiency, spline);
            interpolatedEfficiencies.add(efficiencyValue);
            speeds.add(refSpeed);
        }
        if (interpolatedEfficiencies.size() == 1) {
            return (Double)interpolatedEfficiencies.get(0);
        }
        double speed1 = (Double)speeds.get(0);
        double speed2 = (Double)speeds.get(1);
        double eff1 = (Double)interpolatedEfficiencies.get(0);
        double eff2 = (Double)interpolatedEfficiencies.get(1);
        return this.extrapolateOrInterpolateSpeed(speed, speed1, speed2, eff1, eff2);
    }

    private double extrapolateOrInterpolate(double flow, double[] flowData, double[] valueData, PolynomialSplineFunction spline) {
        double[] knots = spline.getKnots();
        if (flow < knots[0]) {
            logger.debug("Extrapolating below range: flow={}, knots[0]={}", (Object)flow, (Object)knots[0]);
            double slope = (valueData[1] - valueData[0]) / (flowData[1] - flowData[0]);
            return valueData[0] + slope * (flow - flowData[0]);
        }
        if (flow > knots[knots.length - 1]) {
            logger.debug("Extrapolating above range: flow={}, knots[last]={}", (Object)flow, (Object)knots[knots.length - 1]);
            int last = flowData.length - 1;
            double slope = (valueData[last] - valueData[last - 1]) / (flowData[last] - flowData[last - 1]);
            return valueData[last] + slope * (flow - flowData[last]);
        }
        logger.debug("Interpolating within range: flow={}", (Object)flow);
        return spline.value(flow);
    }

    private double extrapolateOrInterpolateSpeed(double speed, double speed1, double speed2, double value1, double value2) {
        if (speed < speed1) {
            double slope = (value2 - value1) / (speed2 - speed1);
            return value1 + slope * (speed - speed1);
        }
        if (speed > speed2) {
            double slope = (value2 - value1) / (speed2 - speed1);
            return value2 + slope * (speed - speed2);
        }
        return this.linearInterpolate(speed, speed1, speed2, value1, value2);
    }

    private double linearInterpolate(double x, double x1, double x2, double y1, double y2) {
        return y1 + (y2 - y1) * (x - x1) / (x2 - x1);
    }
}

