/*
 * Decompiled with CFR 0.152.
 */
package neqsim.process.equipment.compressor;

import java.io.BufferedReader;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.TreeMap;
import neqsim.process.equipment.compressor.Compressor;
import neqsim.process.equipment.compressor.SafeSplineStoneWallCurve;
import neqsim.process.equipment.compressor.SafeSplineSurgeCurve;

public class CompressorChartReader {
    private double[] speeds;
    private double[][] flowLines;
    private double[][] headLines;
    private double[][] polyEffLines;
    private double[] stonewallCurve;
    private double[] surgeCurve;
    private double[] surgeFlow;
    private double[] surgeHead;
    private double[] chokeFlow;
    private double[] chokeHead;
    private String headUnit = "kJ/kg";

    public CompressorChartReader(String csvFilePath) throws Exception {
        this.parseCSV(csvFilePath);
    }

    private void parseCSV(String csvFilePath) throws Exception {
        String line;
        BufferedReader reader = new BufferedReader(new FileReader(csvFilePath));
        String headerLine = reader.readLine();
        String[] headers = headerLine.split(";");
        int speedIdx = Arrays.asList(headers).indexOf("speed");
        int flowIdx = Arrays.asList(headers).indexOf("flow");
        int headIdx = Arrays.asList(headers).indexOf("head");
        int polyEffIdx = Arrays.asList(headers).indexOf("polyEff");
        int stonewallIdx = Arrays.asList(headers).indexOf("stonewall");
        int surgeIdx = Arrays.asList(headers).indexOf("surge");
        TreeMap<Double, List> groupedData = new TreeMap<Double, List>();
        ArrayList stonewallList = new ArrayList();
        ArrayList surgeList = new ArrayList();
        while ((line = reader.readLine()) != null) {
            String[] parts = line.split(";");
            Double speedVal = Double.parseDouble(parts[speedIdx]);
            groupedData.computeIfAbsent(speedVal, k -> new ArrayList()).add(parts);
        }
        this.speeds = new double[groupedData.size()];
        this.flowLines = new double[groupedData.size()][];
        this.headLines = new double[groupedData.size()][];
        this.polyEffLines = new double[groupedData.size()][];
        this.surgeFlow = new double[groupedData.size()];
        this.surgeHead = new double[groupedData.size()];
        this.chokeFlow = new double[groupedData.size()];
        this.chokeHead = new double[groupedData.size()];
        int i = 0;
        for (Double speed : groupedData.keySet()) {
            this.speeds[i] = speed;
            List group = (List)groupedData.get(speed);
            int groupSize = group.size();
            this.flowLines[i] = new double[groupSize];
            this.headLines[i] = new double[groupSize];
            this.polyEffLines[i] = new double[groupSize];
            for (int j = 0; j < groupSize; ++j) {
                this.flowLines[i][j] = Double.parseDouble(((String[])group.get(j))[flowIdx]);
                this.headLines[i][j] = Double.parseDouble(((String[])group.get(j))[headIdx]);
                this.polyEffLines[i][j] = Double.parseDouble(((String[])group.get(j))[polyEffIdx]);
            }
            int idxMinFlow = this.minIndex(this.flowLines[i]);
            int idxMaxFlow = this.maxIndex(this.flowLines[i]);
            this.surgeFlow[i] = this.flowLines[i][idxMinFlow];
            this.surgeHead[i] = this.headLines[i][idxMinFlow];
            this.chokeFlow[i] = this.flowLines[i][idxMaxFlow];
            this.chokeHead[i] = this.headLines[i][idxMaxFlow];
            ++i;
        }
        this.stonewallCurve = stonewallList.stream().mapToDouble(Double::doubleValue).toArray();
        this.surgeCurve = surgeList.stream().mapToDouble(Double::doubleValue).toArray();
        reader.close();
    }

    private int minIndex(double[] array) {
        int minIdx = 0;
        for (int i = 1; i < array.length; ++i) {
            if (!(array[i] < array[minIdx])) continue;
            minIdx = i;
        }
        return minIdx;
    }

    private int maxIndex(double[] array) {
        int maxIdx = 0;
        for (int i = 1; i < array.length; ++i) {
            if (!(array[i] > array[maxIdx])) continue;
            maxIdx = i;
        }
        return maxIdx;
    }

    public void setCurvesToCompressor(Compressor compressor) {
        compressor.getCompressorChart().setCurves(new double[0], this.speeds, this.flowLines, this.headLines, this.polyEffLines);
        compressor.getCompressorChart().setStoneWallCurve(new SafeSplineStoneWallCurve(this.chokeFlow, this.chokeHead));
        compressor.getCompressorChart().setSurgeCurve(new SafeSplineSurgeCurve(this.surgeFlow, this.surgeHead));
        compressor.getCompressorChart().setHeadUnit(this.headUnit);
    }

    public void setHeadUnit(String headUnit) {
        this.headUnit = headUnit;
    }

    public double[] getSurgeFlow() {
        return this.surgeFlow;
    }

    public double[] getSurgeHead() {
        return this.surgeHead;
    }

    public double[] getChokeFlow() {
        return this.chokeFlow;
    }

    public double[] getChokeHead() {
        return this.chokeHead;
    }

    public double[] getSpeeds() {
        return this.speeds;
    }

    public double[][] getFlowLines() {
        return this.flowLines;
    }

    public double[][] getHeadLines() {
        return this.headLines;
    }

    public double[][] getPolyEffLines() {
        return this.polyEffLines;
    }

    public double[] getStonewallCurve() {
        return this.stonewallCurve;
    }

    public double[] getSurgeCurve() {
        return this.surgeCurve;
    }
}

