/*
 * Decompiled with CFR 0.152.
 */
package neqsim.process.equipment.diffpressure;

import java.util.UUID;
import neqsim.process.equipment.TwoPortEquipment;
import neqsim.process.equipment.stream.StreamInterface;
import neqsim.thermo.system.SystemInterface;

public class Orifice
extends TwoPortEquipment {
    private static final long serialVersionUID = 1000L;
    private StreamInterface inputstream;
    private StreamInterface outputstream;
    private Double dp;
    private Double diameter;
    private Double diameter_outer;
    private Double C;
    private double orificeDiameter;
    private double pressureUpstream;
    private double pressureDownstream;
    private double dischargeCoefficient;

    public Orifice(String name) {
        super(name);
    }

    public Orifice(String name, double diameter, double orificeDiameter, double pressureUpstream, double pressureDownstream, double dischargeCoefficient) {
        super(name);
        this.diameter = diameter;
        this.orificeDiameter = orificeDiameter;
        this.pressureUpstream = pressureUpstream;
        this.pressureDownstream = pressureDownstream;
        this.dischargeCoefficient = dischargeCoefficient;
    }

    public void setOrificeParameters(Double diameter, Double diameter_outer, Double C) {
        this.diameter = diameter;
        this.diameter_outer = diameter_outer;
        this.C = C;
    }

    public Double calc_dp() {
        double beta = this.orificeDiameter / this.diameter;
        double beta2 = beta * beta;
        double beta4 = beta2 * beta2;
        double dP = this.pressureUpstream - this.pressureDownstream;
        double deltaW = (Math.sqrt(1.0 - beta4 * (1.0 - this.dischargeCoefficient * this.dischargeCoefficient)) - this.dischargeCoefficient * beta2) / (Math.sqrt(1.0 - beta4 * (1.0 - this.dischargeCoefficient * this.dischargeCoefficient)) + this.dischargeCoefficient * beta2) * dP;
        return deltaW;
    }

    public static double calculateDischargeCoefficient(double D, double Do, double rho, double mu, double m, String taps) {
        double L2_prime;
        double L1;
        double A_pipe = 0.7853981633974483 * D * D;
        double v = m / (A_pipe * rho);
        double Re_D = rho * v * D / mu;
        double beta = Do / D;
        double beta2 = beta * beta;
        double beta4 = beta2 * beta2;
        double beta8 = beta4 * beta4;
        if ("corner".equalsIgnoreCase(taps)) {
            L1 = 0.0;
            L2_prime = 0.0;
        } else if ("flange".equalsIgnoreCase(taps)) {
            L1 = L2_prime = 0.0254 / D;
        } else if ("D".equalsIgnoreCase(taps) || "D/2".equalsIgnoreCase(taps)) {
            L1 = 1.0;
            L2_prime = 0.47;
        } else {
            throw new IllegalArgumentException("Unsupported tap type: " + taps);
        }
        double A = Math.pow(19000.0 * beta / Re_D, 0.8);
        double M2_prime = 2.0 * L2_prime / (1.0 - beta);
        double deltaCUpstream = (0.043 + 0.08 * Math.exp(-10.0 * L1) - 0.123 * Math.exp(-7.0 * L1)) * (1.0 - 0.11 * A) * beta4 / (1.0 - beta4);
        double deltaCDownstream = -0.031 * (M2_prime - 0.8 * Math.pow(M2_prime, 1.1)) * Math.pow(beta, 1.3);
        double C_inf_C_s = 0.5961 + 0.0261 * beta2 - 0.216 * beta8 + 5.21E-4 * Math.pow(1000000.0 * beta / Re_D, 0.7) + (0.0188 + 0.0063 * A) * Math.pow(beta, 3.5) * Math.pow(1000000.0 / Re_D, 0.3);
        return C_inf_C_s + deltaCUpstream + deltaCDownstream;
    }

    public static double calculateExpansibility(double D, double Do, double P1, double P2, double k) {
        double beta = Do / D;
        double beta4 = Math.pow(beta, 4.0);
        return 1.0 - (0.351 + beta4 * (0.93 * beta4 + 0.256)) * (1.0 - Math.pow(P2 / P1, 1.0 / k));
    }

    public static double calculatePressureDrop(double D, double Do, double P1, double P2, double C) {
        double beta = Do / D;
        double beta2 = beta * beta;
        double beta4 = beta2 * beta2;
        double dP = P1 - P2;
        double deltaW = (Math.sqrt(1.0 - beta4 * (1.0 - C * C)) - C * beta2) / (Math.sqrt(1.0 - beta4 * (1.0 - C * C)) + C * beta2) * dP;
        return deltaW;
    }

    public static double calculateBetaRatio(double D, double Do) {
        return Do / D;
    }

    public static double calculateMassFlowRate(double D, double Do, double P1, double P2, double rho, double mu, double k, String taps) {
        double beta;
        double beta2;
        double epsilon;
        double C;
        double mCalc;
        int MAX_ITERATIONS = 50;
        double m = 1.0;
        for (int i = 0; i < 50 && !(Math.abs((mCalc = 0.7853981633974483 * Do * Do * (C = Orifice.calculateDischargeCoefficient(D, Do, rho, mu, m, taps)) * (epsilon = Orifice.calculateExpansibility(D, Do, P1, P2, k)) * Math.sqrt(2.0 * rho * (P1 - P2) / (1.0 - (beta2 = (beta = Orifice.calculateBetaRatio(D, Do)) * beta) * beta2))) - m) / m < 1.0E-8); ++i) {
            m = mCalc;
        }
        return m;
    }

    @Override
    public void run(UUID uuid) {
        if (this.inputstream != null && this.outputstream != null) {
            double newPressure = this.inputstream.getPressure("bara") - this.calc_dp();
            SystemInterface outfluid = (SystemInterface)((Object)this.inStream.clone());
            outfluid.setPressure(newPressure);
            this.outStream.setFluid(outfluid);
            this.outStream.run();
        }
    }
}

