/*
 * Decompiled with CFR 0.152.
 */
package neqsim.process.equipment.distillation;

import java.util.UUID;
import neqsim.process.equipment.distillation.SimpleTray;
import neqsim.process.equipment.splitter.Splitter;
import neqsim.process.equipment.stream.Stream;
import neqsim.process.equipment.stream.StreamInterface;
import neqsim.thermo.system.SystemInterface;
import neqsim.thermodynamicoperations.ThermodynamicOperations;

public class Condenser
extends SimpleTray {
    private static final long serialVersionUID = 1000L;
    private double refluxRatio = 0.1;
    boolean refluxIsSet = false;
    double duty = 0.0;
    boolean totalCondenser = false;
    Splitter mixedStreamSplitter = null;
    private boolean separation_with_liquid_reflux = false;
    private double reflux_value;
    private String reflux_unit;

    public Condenser(String name) {
        super(name);
    }

    public boolean isSeparation_with_liquid_reflux() {
        return this.separation_with_liquid_reflux;
    }

    public void setSeparation_with_liquid_reflux(boolean separation_with_liquid_reflux, double value, String unit) {
        this.refluxIsSet = separation_with_liquid_reflux;
        this.separation_with_liquid_reflux = separation_with_liquid_reflux;
        this.reflux_value = value;
        this.reflux_unit = unit;
    }

    public void setTotalCondenser(boolean isTotalCondenser) {
        this.totalCondenser = isTotalCondenser;
    }

    public double getRefluxRatio() {
        return this.refluxRatio;
    }

    public void setRefluxRatio(double refluxRatio) {
        this.refluxRatio = refluxRatio;
        this.refluxIsSet = true;
    }

    public double getDuty() {
        return this.duty;
    }

    @Override
    public StreamInterface getGasOutStream() {
        if (this.totalCondenser) {
            return new Stream("", this.mixedStreamSplitter.getSplitStream(1));
        }
        return super.getGasOutStream();
    }

    public StreamInterface getProductOutStream() {
        return this.getGasOutStream();
    }

    @Override
    public StreamInterface getLiquidOutStream() {
        if (this.totalCondenser || this.separation_with_liquid_reflux) {
            return this.mixedStreamSplitter.getSplitStream(0);
        }
        return super.getLiquidOutStream();
    }

    public StreamInterface getLiquidProductStream() {
        if (this.separation_with_liquid_reflux) {
            return this.mixedStreamSplitter.getSplitStream(1);
        }
        return null;
    }

    @Override
    public void run(UUID id) {
        if (this.refluxIsSet && this.totalCondenser) {
            UUID oldID = this.getCalculationIdentifier();
            SystemInterface thermoSystem2 = ((StreamInterface)this.streams.get(0)).getThermoSystem().clone();
            this.mixedStream.setThermoSystem(thermoSystem2);
            ThermodynamicOperations testOps = new ThermodynamicOperations(thermoSystem2);
            if (this.streams.size() > 0) {
                this.mixedStream.getThermoSystem().setNumberOfPhases(2);
                this.mixedStream.getThermoSystem().init(0);
                this.mixStream();
            }
            double enthalpy = this.calcMixStreamEnthalpy();
            try {
                testOps.bubblePointTemperatureFlash();
            }
            catch (Exception e) {
                logger.error(e.getMessage());
            }
            this.mixedStream.getThermoSystem().init(3);
            this.mixedStreamSplitter = new Splitter("splitter", this.mixedStream, 2);
            this.mixedStreamSplitter.setSplitFactors(new double[]{this.refluxRatio, 1.0 - this.refluxRatio});
            this.mixedStreamSplitter.run();
        } else if (!this.refluxIsSet) {
            UUID oldID = this.getCalculationIdentifier();
            super.run(id);
            this.setCalculationIdentifier(oldID);
        } else if (this.separation_with_liquid_reflux) {
            super.run(id);
            Stream liquidstream = new Stream("temp liq stream", this.mixedStream.getFluid().phaseToSystem(1));
            liquidstream.run();
            if (liquidstream.getFlowRate("kg/hr") < this.reflux_value) {
                liquidstream.setFlowRate(this.reflux_value + 1.0, this.reflux_unit);
                liquidstream.run();
            }
            this.mixedStreamSplitter = new Splitter("splitter", liquidstream, 2);
            this.mixedStreamSplitter.setFlowRates(new double[]{this.reflux_value, -1.0}, this.reflux_unit);
            this.mixedStreamSplitter.run();
        } else {
            SystemInterface thermoSystem2 = ((StreamInterface)this.streams.get(0)).getThermoSystem().clone();
            this.mixedStream.setThermoSystem(thermoSystem2);
            ThermodynamicOperations testOps = new ThermodynamicOperations(thermoSystem2);
            testOps.PVrefluxFlash(this.refluxRatio, 0);
        }
        this.duty = this.mixedStream.getFluid().getEnthalpy() - this.calcMixStreamEnthalpy0();
        this.energyStream.setDuty(this.duty);
        this.setCalculationIdentifier(id);
    }
}

