/*
 * Decompiled with CFR 0.152.
 */
package neqsim.process.equipment.distillation;

import java.util.UUID;
import neqsim.process.equipment.distillation.SimpleTray;
import neqsim.process.equipment.stream.StreamInterface;
import neqsim.thermo.system.SystemInterface;
import neqsim.thermodynamicoperations.ThermodynamicOperations;

public class Reboiler
extends SimpleTray {
    private static final long serialVersionUID = 1000L;
    private double refluxRatio = 0.1;
    boolean refluxIsSet = false;
    double duty = 0.0;

    public Reboiler(String name) {
        super(name);
    }

    public double getRefluxRatio() {
        return this.refluxRatio;
    }

    public void setRefluxRatio(double refluxRatio) {
        this.refluxRatio = refluxRatio;
        this.refluxIsSet = true;
    }

    public double getDuty() {
        return this.duty;
    }

    @Override
    public void run(UUID id) {
        if (!this.refluxIsSet) {
            UUID oldid = this.getCalculationIdentifier();
            super.run(id);
            this.mixedStream.setCalculationIdentifier(oldid);
            this.setCalculationIdentifier(oldid);
        } else {
            SystemInterface thermoSystem2 = ((StreamInterface)this.streams.get(0)).getThermoSystem().clone();
            this.mixedStream.setThermoSystem(thermoSystem2);
            ThermodynamicOperations testOps = new ThermodynamicOperations(thermoSystem2);
            testOps.PVrefluxFlash(this.refluxRatio, 1);
        }
        this.duty = this.mixedStream.getFluid().getEnthalpy() - this.calcMixStreamEnthalpy0();
        this.mixedStream.setCalculationIdentifier(id);
        this.setCalculationIdentifier(id);
    }
}

