/*
 * Decompiled with CFR 0.152.
 */
package neqsim.process.equipment.distillation;

import java.util.UUID;
import neqsim.process.equipment.distillation.TrayInterface;
import neqsim.process.equipment.mixer.Mixer;
import neqsim.process.equipment.stream.Stream;
import neqsim.process.equipment.stream.StreamInterface;
import neqsim.thermo.system.SystemInterface;
import neqsim.thermodynamicoperations.ThermodynamicOperations;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SimpleTray
extends Mixer
implements TrayInterface {
    private static final long serialVersionUID = 1000L;
    static Logger logger = LogManager.getLogger(SimpleTray.class);
    double heatInput = 0.0;
    private double temperature = Double.NaN;
    private double trayPressure = -1.0;

    public SimpleTray(String name) {
        super(name);
    }

    public void init() {
        int pp = 0;
        if (this.streams.size() == 3) {
            pp = 1;
        }
        for (int k = pp; k < this.streams.size(); ++k) {
            ((StreamInterface)this.streams.get(k)).getThermoSystem().setTemperature(this.temperature);
        }
    }

    @Override
    public void setHeatInput(double heatinp) {
        this.heatInput = heatinp;
    }

    public double calcMixStreamEnthalpy0() {
        double enthalpy = 0.0;
        for (int k = 0; k < this.streams.size(); ++k) {
            ((StreamInterface)this.streams.get(k)).getThermoSystem().init(3);
            enthalpy += ((StreamInterface)this.streams.get(k)).getThermoSystem().getEnthalpy();
        }
        return enthalpy;
    }

    @Override
    public double calcMixStreamEnthalpy() {
        double enthalpy = this.heatInput;
        if (this.isSetEnergyStream()) {
            enthalpy -= this.energyStream.getDuty();
        }
        for (int k = 0; k < this.streams.size(); ++k) {
            ((StreamInterface)this.streams.get(k)).getThermoSystem().init(3);
            enthalpy += ((StreamInterface)this.streams.get(k)).getThermoSystem().getEnthalpy();
        }
        return enthalpy;
    }

    public void run2() {
        super.run();
        this.temperature = this.mixedStream.getTemperature();
    }

    public void TPflash() {
    }

    @Override
    public void run(UUID id) {
        double enthalpy = 0.0;
        boolean changeTo2Phase = false;
        SystemInterface thermoSystem2 = ((StreamInterface)this.streams.get(0)).getThermoSystem().clone();
        if (thermoSystem2.doMultiPhaseCheck()) {
            changeTo2Phase = true;
            thermoSystem2.setMultiPhaseCheck(false);
        }
        if (this.trayPressure > 0.0) {
            thermoSystem2.setPressure(this.trayPressure);
        }
        this.mixedStream.setThermoSystem(thermoSystem2);
        ThermodynamicOperations testOps = new ThermodynamicOperations(thermoSystem2);
        if (this.streams.size() > 0) {
            this.mixedStream.getThermoSystem().setNumberOfPhases(2);
            this.mixedStream.getThermoSystem().init(0);
            this.mixStream();
            if (this.trayPressure > 0.0) {
                this.mixedStream.setPressure(this.trayPressure, "bara");
            }
            enthalpy = this.calcMixStreamEnthalpy();
            if (this.isSetOutTemperature()) {
                this.mixedStream.setTemperature(this.getOutTemperature(), "K");
            }
        }
        if (this.isSetOutTemperature()) {
            if (!Double.isNaN(this.getOutTemperature())) {
                this.mixedStream.getThermoSystem().setTemperature(this.getOutTemperature());
            }
            testOps.TPflash();
            this.mixedStream.getThermoSystem().init(2);
        } else {
            try {
                testOps.PHflash(enthalpy, 0);
            }
            catch (Exception ex) {
                if (!Double.isNaN(this.getOutTemperature())) {
                    this.mixedStream.getThermoSystem().setTemperature(this.getOutTemperature());
                }
                testOps.TPflash();
            }
        }
        this.setTemperature(this.mixedStream.getTemperature());
        this.mixedStream.setCalculationIdentifier(id);
        this.setCalculationIdentifier(id);
        if (this.mixedStream.getFluid().getNumberOfPhases() >= 3) {
            System.out.println("error...." + this.mixedStream.getFluid().getNumberOfPhases() + " phases on tray");
            logger.warn("error...." + this.mixedStream.getFluid().getNumberOfPhases() + " phases on tray");
        }
        if (changeTo2Phase) {
            thermoSystem2.setMultiPhaseCheck(true);
        }
    }

    public StreamInterface getGasOutStream() {
        return new Stream("", this.mixedStream.getThermoSystem().phaseToSystem(0));
    }

    public StreamInterface getLiquidOutStream() {
        return new Stream("", this.mixedStream.getThermoSystem().phaseToSystem(1));
    }

    @Override
    public double getTemperature() {
        return this.temperature;
    }

    @Override
    public void setPressure(double pres) {
        this.trayPressure = pres;
    }

    @Override
    public void setTemperature(double temperature) {
        this.temperature = temperature;
    }

    @Override
    public double guessTemperature() {
        if (Double.isNaN(this.temperature)) {
            double gtemp = 0.0;
            for (int k = 0; k < this.streams.size(); ++k) {
                gtemp += ((StreamInterface)this.streams.get(k)).getThermoSystem().getTemperature() * ((StreamInterface)this.streams.get(k)).getThermoSystem().getNumberOfMoles() / this.mixedStream.getThermoSystem().getNumberOfMoles();
            }
            return gtemp;
        }
        return this.temperature;
    }

    public double getVaporFlowRate(String unit) {
        if (this.getFluid().hasPhaseType("gas")) {
            return this.getFluid().getPhase("gas").getFlowRate(unit);
        }
        return 0.0;
    }

    public double getLiquidFlowRate(String unit) {
        if (this.getFluid().hasPhaseType("aqueous") || this.getFluid().hasPhaseType("oil")) {
            return this.getFluid().getPhase(1).getFlowRate(unit);
        }
        return 0.0;
    }

    public double getFeedRate(String unit) {
        double feed = 0.0;
        for (int j = 0; j < this.getNumberOfInputStreams(); ++j) {
            feed += this.getStream(j).getFluid().getFlowRate("kg/hr");
        }
        return feed;
    }

    public double massBalance() {
        double massInput = 0.0;
        double massOutput = 0.0;
        int numberOfInputStreams = this.getNumberOfInputStreams();
        for (int j = 0; j < numberOfInputStreams; ++j) {
            massInput += this.getStream(j).getFluid().getFlowRate("kg/hr");
        }
        massOutput += this.getGasOutStream().getFlowRate("kg/hr");
        return massInput - (massOutput += this.getLiquidOutStream().getFlowRate("kg/hr"));
    }
}

