/*
 * Decompiled with CFR 0.152.
 */
package neqsim.process.equipment.ejector;

import java.util.UUID;
import neqsim.process.equipment.ProcessEquipmentBaseClass;
import neqsim.process.equipment.stream.StreamInterface;

public class Ejector
extends ProcessEquipmentBaseClass {
    private static final long serialVersionUID = 1000L;
    private StreamInterface motiveStream;
    private StreamInterface suctionStream;
    private StreamInterface mixedStream;
    private double dischargePressure;
    private double efficiencyIsentropic = 0.75;
    private double diffuserEfficiency = 0.8;
    private double throatArea = 0.001;

    public Ejector(String name, StreamInterface motiveStream, StreamInterface suctionStream) {
        super(name);
        this.motiveStream = motiveStream;
        this.suctionStream = suctionStream;
        this.mixedStream = motiveStream.clone();
    }

    public void setDischargePressure(double dischargePressure) {
        this.dischargePressure = dischargePressure;
    }

    public void setEfficiencyIsentropic(double efficiencyIsentropic) {
        this.efficiencyIsentropic = efficiencyIsentropic;
    }

    public void setDiffuserEfficiency(double diffuserEfficiency) {
        this.diffuserEfficiency = diffuserEfficiency;
    }

    public void setThroatArea(double throatArea) {
        this.throatArea = throatArea;
    }

    @Override
    public void run(UUID id) {
        this.motiveStream.run();
        this.suctionStream.run();
        this.motiveStream.setPressure(this.dischargePressure);
        this.suctionStream.setPressure(this.dischargePressure);
        double hMotive = this.motiveStream.getFluid().getEnthalpy();
        double hSuction = this.suctionStream.getFluid().getEnthalpy();
        double mDotMotive = this.motiveStream.getFlowRate("kg/s");
        double mDotSuction = this.suctionStream.getFlowRate("kg/s");
        double idealMixedEnthalpy = this.calculateIdealMixedEnthalpy(hMotive, hSuction, mDotMotive, mDotSuction);
        double hMixedActual = this.calculateActualMixedEnthalpy(hMotive, idealMixedEnthalpy);
        this.mixedStream = this.motiveStream.clone();
        this.mixedStream.getFluid().setTotalFlowRate(mDotMotive + mDotSuction, "kg/s");
        this.mixedStream.setPressure(this.dischargePressure);
        this.checkChokedFlow(mDotMotive, mDotSuction);
        double hActualDiffuserOut = this.calculateDiffuserOutput(hMixedActual);
        this.mixedStream.setPressure(this.mixedStream.getFluid().getPressure());
    }

    private double calculateIdealMixedEnthalpy(double hMotive, double hSuction, double mDotMotive, double mDotSuction) {
        return (hMotive * mDotMotive + hSuction * mDotSuction) / (mDotMotive + mDotSuction);
    }

    private double calculateActualMixedEnthalpy(double hMotive, double idealMixedEnthalpy) {
        return hMotive + (idealMixedEnthalpy - hMotive) / this.efficiencyIsentropic;
    }

    private void checkChokedFlow(double mDotMotive, double mDotSuction) {
        double speedOfSound;
        double density = this.mixedStream.getFluid().getDensity("kg/m3");
        double velocity = (mDotMotive + mDotSuction) / (density * this.throatArea);
        double machNumber = velocity / (speedOfSound = this.mixedStream.getFluid().getSoundSpeed());
        if (machNumber >= 1.0) {
            System.out.println("Choked flow detected! Mach number: " + machNumber);
        } else {
            System.out.println("Flow not choked. Mach number: " + machNumber);
        }
    }

    private double calculateDiffuserOutput(double hMixedActual) {
        double vInlet = (this.motiveStream.getFlowRate("kg/s") + this.suctionStream.getFlowRate("kg/s")) / (this.mixedStream.getFluid().getDensity("kg/m3") * this.throatArea);
        double hIdealDiffuserOut = hMixedActual + 0.5 * vInlet * vInlet;
        return hMixedActual + (hIdealDiffuserOut - hMixedActual) / this.diffuserEfficiency;
    }

    public StreamInterface getOutStream() {
        return this.mixedStream;
    }

    public double getEntrainmentRatio() {
        return this.suctionStream.getFlowRate("kg/s") / this.motiveStream.getFlowRate("kg/s");
    }
}

