/*
 * Decompiled with CFR 0.152.
 */
package neqsim.process.equipment.expander;

import com.google.gson.GsonBuilder;
import java.util.Arrays;
import java.util.UUID;
import neqsim.process.equipment.compressor.Compressor;
import neqsim.process.equipment.expander.Expander;
import neqsim.process.equipment.stream.StreamInterface;
import neqsim.process.util.monitor.TurboExpanderCompressorResponse;
import neqsim.thermo.system.SystemInterface;
import neqsim.thermodynamicoperations.ThermodynamicOperations;

public class TurboExpanderCompressor
extends Expander {
    private static final long serialVersionUID = 1001L;
    private double expanderOutPressure = 40.0;
    private double IGVopening = 1.0;
    private double bearingLossPower = 10.0;
    private double expanderSpeed = 1000.0;
    private double compressorSpeed = 1000.0;
    private double gearRatio = 1.0;
    StreamInterface compressorFeedStream = null;
    StreamInterface compressorOutletStream = null;
    StreamInterface expanderFeedStream = null;
    StreamInterface expanderOutletStream = null;
    private double impellerDiameter = 0.424;
    private double designSpeed = 6850.0;
    private double designUC = 0.7;
    private double UCratioexpander = 0.7;
    private double UCratiocompressor = 0.7;
    private double QNratioexpander = 0.7;
    private double QNratiocompressor = 0.7;
    private double designQn = 0.03328;
    private double Qn = 0.03328;
    private double maximumIGVArea = 16370.0;
    private double compressorDesignPolytropicEfficiency = 0.81;
    private double compressorPolytropicEfficiency = 0.81;
    private double compressorDesignPolytropicHead = 20.47;
    private double compressorPolytropicHead = 20.47;
    private double expanderIsentropicEfficiency = 1.0;
    private double expanderDesignIsentropicEfficiency = 1.0;
    private double powerExpander = 0.0;
    private double powerCompressor = 0.0;
    private double ucCurveA = 0.0;
    private double ucCurveH = 1.0;
    private double ucCurveK = 1.0;
    private double qnCurveA = 0.0;
    private double qnCurveH = 1.0;
    private double qnCurveK = 1.0;
    private double qnHeadCurveA = 0.0;
    private double qnHeadCurveH = 1.0;
    private double qnHeadCurveK = 1.0;
    private double[] qnHeadCurveQnValues = null;
    private double[] qnHeadCurveHeadValues = null;
    private double[] qnEffCurveQnValues = null;
    private double[] qnEffCurveEffValues = null;

    public TurboExpanderCompressor(String name, StreamInterface inletStream) {
        super(name, inletStream);
        this.expanderFeedStream = inletStream;
        this.expanderOutletStream = inletStream.clone(name + " exp outlet");
        this.compressorFeedStream = inletStream.clone(name + " comp feed");
        this.outStream = this.compressorOutletStream = inletStream.clone(name + " comp outlet");
    }

    @Override
    public void run(UUID id) {
        double N = this.designSpeed;
        double N_max = 9000.0;
        double N_min = 1000.0;
        double eta_p = 0.0;
        double W_compressor = 0.0;
        double W_expander = 0.0;
        double W_bearing = 0.0;
        double D = this.impellerDiameter;
        double eta_s_design = this.expanderDesignIsentropicEfficiency;
        double Hp_design = this.compressorDesignPolytropicHead;
        double eta_p_design = this.compressorDesignPolytropicEfficiency;
        double N_design = this.designSpeed;
        double m1 = this.expanderFeedStream.getFlowRate("kg/sec");
        double Q_comp = 0.0;
        double m_comp = 0.0;
        double eta_s = 0.0;
        double Hp = 0.0;
        double CF_eff_comp = 1.0;
        double CF_head_comp = 1.0;
        int maxIter = 50;
        int minIter = 3;
        double dN = 10.0;
        int iter = 0;
        double Hp2 = 0.0;
        double eta_p2 = 0.0;
        double eta_s2 = 0.0;
        double uc = 0.0;
        double uc2 = 0.0;
        double qn_ratio = 0.0;
        double qn_ratio2 = 0.0;
        do {
            double outPress = this.expanderOutPressure;
            SystemInterface fluid2 = this.expanderFeedStream.getThermoSystem().clone();
            fluid2.initThermoProperties();
            double s1 = fluid2.getEntropy("kJ/kgK");
            double h_in = fluid2.getEnthalpy("kJ/kg");
            fluid2.setPressure(outPress, "bara");
            ThermodynamicOperations flash = new ThermodynamicOperations(fluid2);
            flash.PSflash(s1, "kJ/kgK");
            fluid2.init(3);
            double h_out = fluid2.getEnthalpy("kJ/kg");
            double h_s = (h_in - h_out) * 1000.0;
            double U = Math.PI * D * N / 60.0;
            double C = Math.sqrt(2.0 * h_s);
            uc = U / C / this.designUC;
            double CF = this.getEfficiencyFromUC(uc);
            eta_s = eta_s_design * CF;
            W_expander = m1 * h_s * eta_s;
            m_comp = this.compressorFeedStream.getFluid().getFlowRate("kg/sec");
            Q_comp = this.compressorFeedStream.getFluid().getFlowRate("m3/sec");
            qn_ratio = Q_comp * 60.0 / N / this.designQn;
            CF_eff_comp = this.getEfficiencyFromQN(qn_ratio);
            CF_head_comp = this.getHeadFromQN(qn_ratio);
            Hp = Hp_design * (N / N_design) * (N / N_design) * CF_head_comp;
            eta_p = CF_eff_comp * eta_p_design;
            W_compressor = m_comp * Hp / eta_p * 1000.0;
            W_bearing = this.bearingLossPower * (N / N_design) * (N / N_design);
            double fN = W_expander - (W_compressor + W_bearing);
            double N2 = N + dN;
            double U2 = Math.PI * D * N2 / 60.0;
            uc2 = U2 / C / this.designUC;
            double CF2 = this.getEfficiencyFromUC(uc2);
            eta_s2 = eta_s_design * CF2;
            double W_expander2 = m1 * h_s * eta_s2;
            qn_ratio2 = Q_comp * 60.0 / N2 / this.designQn;
            double CF_eff_comp2 = this.getEfficiencyFromQN(qn_ratio2);
            Hp2 = Hp_design * (N2 / N_design) * (N2 / N_design) * CF_head_comp;
            eta_p2 = CF_eff_comp2 * eta_p_design;
            double W_compressor2 = m_comp * Hp2 / eta_p2 * 1000.0;
            double W_bearing2 = this.bearingLossPower * (N2 / N_design) * (N2 / N_design);
            double fN2 = W_expander2 - (W_compressor2 + W_bearing2);
            double df_dN = (fN2 - fN) / dN;
            if (Math.abs(df_dN) < 1.0E-8) {
                dN += 10.0;
                N += 10.0;
            } else {
                N -= (1.0 + (double)iter) / (double)(iter + 5) * fN / df_dN;
            }
            if (N > 9000.0) {
                N = 9000.0;
                break;
            }
            if (!(N < 1000.0)) continue;
            N = 1000.0;
            break;
        } while (Math.abs(W_expander - (W_compressor + W_bearing)) * 100.0 > 0.001 && ++iter < maxIter || iter < minIter);
        if (iter >= maxIter) {
            System.out.println("Warning: TurboExpanderCompressor did not converge.");
        }
        this.expanderIsentropicEfficiency = eta_s;
        this.compressorPolytropicHead = Hp;
        this.compressorPolytropicEfficiency = eta_p;
        this.expanderSpeed = N;
        this.setSpeed(N);
        this.setPower(W_expander);
        this.powerExpander = W_expander;
        this.powerCompressor = W_compressor;
        this.setUCratioexpander(uc);
        this.setQNratiocompressor(qn_ratio);
        this.setQn(N / 60.0 * Q_comp / this.designQn);
        Expander expander = new Expander("tempExpander", this.expanderFeedStream);
        expander.setOutletPressure(this.getExpanderOutPressure());
        expander.setIsentropicEfficiency(eta_s);
        expander.run();
        this.expanderOutletStream.setFluid(expander.getOutletStream().getFluid());
        Compressor tempCompressor = new Compressor("tempCompressor", this.compressorFeedStream);
        tempCompressor.setUsePolytropicCalc(true);
        tempCompressor.setPolytropicEfficiency(eta_p);
        tempCompressor.setPower(W_compressor);
        tempCompressor.setCalcPressureOut(true);
        tempCompressor.run();
        this.compressorOutletStream.setFluid(tempCompressor.getOutletStream().getFluid());
        this.setCalculationIdentifier(id);
    }

    public double getCompressorPolytropicHead() {
        return this.compressorPolytropicHead;
    }

    public double getUCratioexpander() {
        return this.UCratioexpander;
    }

    public double getUCratiocompressor() {
        return this.UCratiocompressor;
    }

    public double getQNratioexpander() {
        return this.QNratioexpander;
    }

    public double getQNratiocompressor() {
        return this.QNratiocompressor;
    }

    public double getQn() {
        return this.Qn;
    }

    public void setQn(double qn) {
        this.Qn = qn;
    }

    public double getPowerExpander() {
        return this.powerExpander;
    }

    public double getPowerCompressor() {
        return this.powerCompressor;
    }

    public double getExpanderIsentropicEfficiency() {
        return this.expanderIsentropicEfficiency;
    }

    public void setExpanderIsentropicEfficiency(double expanderIsentropicEfficiency) {
        this.expanderIsentropicEfficiency = expanderIsentropicEfficiency;
    }

    public double getDesignCompressorPolytropicEfficiency() {
        return this.compressorDesignPolytropicEfficiency;
    }

    public void setCompressorDesignPolytropicEfficiency(double compressorPolytropicEfficiency) {
        this.compressorDesignPolytropicEfficiency = compressorPolytropicEfficiency;
    }

    public double getCompressorDesignPolytropicHead() {
        return this.compressorDesignPolytropicHead;
    }

    public void setCompressorDesignPolytropicHead(double compressorDesignPolytropicHead) {
        this.compressorDesignPolytropicHead = compressorDesignPolytropicHead;
    }

    public void setUCcurve(double[] ucValues, double[] efficiencyValues) {
        double h = this.ucCurveH;
        double k = this.ucCurveK;
        int n = ucValues.length;
        if (n < 2) {
            return;
        }
        double num = 0.0;
        double denom = 0.0;
        for (int i = 0; i < n; ++i) {
            double dx = ucValues[i] - h;
            num += (efficiencyValues[i] - k) * dx;
            denom += dx * dx;
        }
        this.ucCurveA = denom != 0.0 ? num / denom : 0.0;
    }

    public double getEfficiencyFromUC(double uc) {
        return -3.56 * (uc - 1.0) * (uc - 1.0) + 1.0;
    }

    public void setQNEfficiencycurve(double[] qnValues, double[] efficiencyValues) {
        int i;
        if (qnValues == null || efficiencyValues == null || qnValues.length < 2 || efficiencyValues.length < 2 || qnValues.length != efficiencyValues.length) {
            this.qnEffCurveQnValues = null;
            this.qnEffCurveEffValues = null;
            return;
        }
        int n = qnValues.length;
        double[][] pairs = new double[n][2];
        for (i = 0; i < n; ++i) {
            pairs[i][0] = qnValues[i];
            pairs[i][1] = efficiencyValues[i];
        }
        Arrays.sort(pairs, (a, b) -> Double.compare(a[0], b[0]));
        this.qnEffCurveQnValues = new double[n];
        this.qnEffCurveEffValues = new double[n];
        for (i = 0; i < n; ++i) {
            this.qnEffCurveQnValues[i] = pairs[i][0];
            this.qnEffCurveEffValues[i] = pairs[i][1];
        }
    }

    public double getEfficiencyFromQN(double qn) {
        if (this.qnEffCurveQnValues == null || this.qnEffCurveEffValues == null || this.qnEffCurveQnValues.length < 2) {
            return 0.0;
        }
        double[] x = this.qnEffCurveQnValues;
        double[] y = this.qnEffCurveEffValues;
        int n = x.length;
        if (qn <= x[0]) {
            double slope = (y[1] - y[0]) / (x[1] - x[0]);
            return y[0] + slope * (qn - x[0]);
        }
        if (qn >= x[n - 1]) {
            double slope = (y[n - 1] - y[n - 2]) / (x[n - 1] - x[n - 2]);
            return y[n - 1] + slope * (qn - x[n - 1]);
        }
        int i = Arrays.binarySearch(x, qn);
        if (i < 0) {
            i = -i - 2;
        }
        if (i < 0) {
            i = 0;
        }
        if (i > n - 2) {
            i = n - 2;
        }
        double x0 = x[i];
        double x1 = x[i + 1];
        double y0 = y[i];
        double y1 = y[i + 1];
        double h = x1 - x0;
        double t = (qn - x0) / h;
        double m0 = i == 0 ? (y1 - y0) / (x1 - x0) : (y1 - y[i - 1]) / (x1 - x[i - 1]);
        double m1 = i == n - 2 ? (y1 - y0) / (x1 - x0) : (y[i + 2] - y0) / (x[i + 2] - x0);
        double h00 = (1.0 + 2.0 * t) * (1.0 - t) * (1.0 - t);
        double h10 = t * (1.0 - t) * (1.0 - t);
        double h01 = t * t * (3.0 - 2.0 * t);
        double h11 = t * t * (t - 1.0);
        return h00 * y0 + h10 * h * m0 + h01 * y1 + h11 * h * m1;
    }

    public void setQNHeadcurve(double[] qnValues, double[] headValues) {
        int i;
        if (qnValues == null || headValues == null || qnValues.length < 2 || headValues.length < 2 || qnValues.length != headValues.length) {
            this.qnHeadCurveQnValues = null;
            this.qnHeadCurveHeadValues = null;
            return;
        }
        int n = qnValues.length;
        double[][] pairs = new double[n][2];
        for (i = 0; i < n; ++i) {
            pairs[i][0] = qnValues[i];
            pairs[i][1] = headValues[i];
        }
        Arrays.sort(pairs, (a, b) -> Double.compare(a[0], b[0]));
        this.qnHeadCurveQnValues = new double[n];
        this.qnHeadCurveHeadValues = new double[n];
        for (i = 0; i < n; ++i) {
            this.qnHeadCurveQnValues[i] = pairs[i][0];
            this.qnHeadCurveHeadValues[i] = pairs[i][1];
        }
    }

    public double getHeadFromQN(double qn) {
        if (this.qnHeadCurveQnValues == null || this.qnHeadCurveHeadValues == null || this.qnHeadCurveQnValues.length < 2) {
            return 0.0;
        }
        double[] x = this.qnHeadCurveQnValues;
        double[] y = this.qnHeadCurveHeadValues;
        int n = x.length;
        if (qn <= x[0]) {
            double slope = (y[1] - y[0]) / (x[1] - x[0]);
            return y[0] + slope * (qn - x[0]);
        }
        if (qn >= x[n - 1]) {
            double slope = (y[n - 1] - y[n - 2]) / (x[n - 1] - x[n - 2]);
            return y[n - 1] + slope * (qn - x[n - 1]);
        }
        int i = Arrays.binarySearch(x, qn);
        if (i < 0) {
            i = -i - 2;
        }
        if (i < 0) {
            i = 0;
        }
        if (i > n - 2) {
            i = n - 2;
        }
        double x0 = x[i];
        double x1 = x[i + 1];
        double y0 = y[i];
        double y1 = y[i + 1];
        double h = x1 - x0;
        double t = (qn - x0) / h;
        double m0 = i == 0 ? (y1 - y0) / (x1 - x0) : (y1 - y[i - 1]) / (x1 - x[i - 1]);
        double m1 = i == n - 2 ? (y1 - y0) / (x1 - x0) : (y[i + 2] - y0) / (x[i + 2] - x0);
        double h00 = (1.0 + 2.0 * t) * (1.0 - t) * (1.0 - t);
        double h10 = t * (1.0 - t) * (1.0 - t);
        double h01 = t * t * (3.0 - 2.0 * t);
        double h11 = t * t * (t - 1.0);
        return h00 * y0 + h10 * h * m0 + h01 * y1 + h11 * h * m1;
    }

    public double calcIGVOpening() {
        return this.IGVopening;
    }

    public double calcIGVOpenArea() {
        return this.IGVopening * this.maximumIGVArea;
    }

    public double calcIGVOpeningFromFlow() {
        double volumetricFlow = this.expanderFeedStream != null ? this.expanderFeedStream.getFluid().getFlowRate("m3/sec") : 0.0;
        double maxArea = this.maximumIGVArea / 1000000.0;
        double referenceVelocity = 1.0;
        double requiredArea = volumetricFlow / referenceVelocity;
        double opening = maxArea > 0.0 ? requiredArea / maxArea : 0.0;
        return Math.min(opening, 1.0);
    }

    public void setImpellerDiameter(double impellerDiameter) {
        this.impellerDiameter = impellerDiameter;
    }

    public void setDesignSpeed(double designSpeed) {
        this.designSpeed = designSpeed;
    }

    public void setDesignUC(double designUC) {
        this.designUC = designUC;
    }

    public void setDesignQn(double designQn) {
        this.designQn = designQn;
    }

    public void setMaximumIGVArea(double maximumIGVArea) {
        this.maximumIGVArea = maximumIGVArea;
    }

    public double getImpellerDiameter() {
        return this.impellerDiameter;
    }

    public double getDesignSpeed() {
        return this.designSpeed;
    }

    public double getDesignUC() {
        return this.designUC;
    }

    public double getDesignQn() {
        return this.designQn;
    }

    public double getMaximumIGVArea() {
        return this.maximumIGVArea;
    }

    public double getCompressorPolytropicEfficieny() {
        return this.compressorPolytropicEfficiency;
    }

    public double getCompressorDesingPolytropicHead() {
        return this.compressorDesignPolytropicHead;
    }

    public double getIGVopening() {
        return this.IGVopening;
    }

    public void setIGVopening(double iGVopening) {
        this.IGVopening = iGVopening;
    }

    public void setExpanderOutPressure(double expanderOutPressure) {
        this.expanderOutPressure = expanderOutPressure;
    }

    public void setCompressorFeedStream(StreamInterface compressorFeedStream) {
        this.compressorFeedStream = compressorFeedStream;
    }

    public StreamInterface getCompressorOutletStream() {
        return this.compressorOutletStream;
    }

    @Override
    public double getSpeed() {
        return this.expanderSpeed;
    }

    @Override
    public StreamInterface getOutletStream() {
        return this.compressorOutletStream;
    }

    public void setUCratioexpander(double UCratioexpander) {
        this.UCratioexpander = UCratioexpander;
    }

    public void setUCratiocompressor(double UCratiocompressor) {
        this.UCratiocompressor = UCratiocompressor;
    }

    public void setQNratioexpander(double QNratioexpander) {
        this.QNratioexpander = QNratioexpander;
    }

    public void setQNratiocompressor(double QNratiocompressor) {
        this.QNratiocompressor = QNratiocompressor;
    }

    public static long getSerialversionuid() {
        return 1001L;
    }

    public double getExpanderOutPressure() {
        return this.expanderOutPressure;
    }

    public double getBearingLossPower() {
        return this.bearingLossPower;
    }

    public double getExpanderSpeed() {
        return this.expanderSpeed;
    }

    public double getCompressorSpeed() {
        return this.compressorSpeed;
    }

    public double getGearRatio() {
        return this.gearRatio;
    }

    public StreamInterface getCompressorFeedStream() {
        return this.compressorFeedStream;
    }

    public StreamInterface getExpanderFeedStream() {
        return this.expanderFeedStream;
    }

    public StreamInterface getExpanderOutletStream() {
        return this.expanderOutletStream;
    }

    public double getUcCurveA() {
        return this.ucCurveA;
    }

    public double getUcCurveH() {
        return this.ucCurveH;
    }

    public double getUcCurveK() {
        return this.ucCurveK;
    }

    public double getQnCurveA() {
        return this.qnCurveA;
    }

    public double getQnCurveH() {
        return this.qnCurveH;
    }

    public double getQnCurveK() {
        return this.qnCurveK;
    }

    public double getQnHeadCurveA() {
        return this.qnHeadCurveA;
    }

    public double getQnHeadCurveH() {
        return this.qnHeadCurveH;
    }

    public double getQnHeadCurveK() {
        return this.qnHeadCurveK;
    }

    @Override
    public String toJson() {
        return new GsonBuilder().create().toJson(new TurboExpanderCompressorResponse(this));
    }

    public double getCompressorDesignPolytropicEfficiency() {
        return this.compressorDesignPolytropicEfficiency;
    }

    public double getCompressorPolytropicEfficiency() {
        return this.compressorPolytropicEfficiency;
    }

    public double getExpanderDesignIsentropicEfficiency() {
        return this.expanderDesignIsentropicEfficiency;
    }

    public void setExpanderDesignIsentropicEfficiency(double expanderDesignIsentropicEfficiency) {
        this.expanderDesignIsentropicEfficiency = expanderDesignIsentropicEfficiency;
    }
}

