/*
 * Decompiled with CFR 0.152.
 */
package neqsim.process.equipment.manifold;

import com.google.gson.GsonBuilder;
import java.util.UUID;
import neqsim.process.equipment.ProcessEquipmentBaseClass;
import neqsim.process.equipment.mixer.Mixer;
import neqsim.process.equipment.splitter.Splitter;
import neqsim.process.equipment.stream.StreamInterface;
import neqsim.process.util.monitor.ManifoldResponse;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Manifold
extends ProcessEquipmentBaseClass {
    private static final long serialVersionUID = 1000L;
    static Logger logger = LogManager.getLogger(Manifold.class);
    protected Mixer localmixer = new Mixer("tmpName");
    protected Splitter localsplitter = new Splitter("tmpName");
    double[] splitFactors = new double[1];

    public Manifold(String name) {
        super(name);
        this.setName(name);
    }

    public void addStream(StreamInterface newStream) {
        this.localmixer.addStream(newStream);
    }

    public void setSplitFactors(double[] splitFact) {
        this.splitFactors = splitFact;
        this.localsplitter.setInletStream(this.localmixer.getOutletStream());
        this.localsplitter.setSplitFactors(this.splitFactors);
    }

    public StreamInterface getSplitStream(int i) {
        return this.localsplitter.getSplitStream(i);
    }

    public StreamInterface getMixedStream() {
        return this.localmixer.getOutletStream();
    }

    @Override
    public void run(UUID id) {
        this.localmixer.run(id);
        this.localsplitter.setInletStream(this.localmixer.getOutletStream());
        this.localsplitter.run();
    }

    @Override
    public void setName(String name) {
        super.setName(name);
        this.localmixer.setName(name + "local mixer");
        this.localsplitter.setName(name + "local splitter");
    }

    public int getNumberOfOutputStreams() {
        return this.localsplitter.getSplitFactors().length;
    }

    @Override
    public String toJson() {
        return new GsonBuilder().create().toJson(new ManifoldResponse(this));
    }
}

