/*
 * Decompiled with CFR 0.152.
 */
package neqsim.process.equipment.membrane;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import neqsim.process.equipment.ProcessEquipmentBaseClass;
import neqsim.process.equipment.stream.Stream;
import neqsim.process.equipment.stream.StreamInterface;
import neqsim.thermodynamicoperations.ThermodynamicOperations;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MembraneSeparator
extends ProcessEquipmentBaseClass {
    private static final long serialVersionUID = 1000L;
    private static final Logger logger = LogManager.getLogger(MembraneSeparator.class);
    private StreamInterface inletStream;
    private StreamInterface permeateStream;
    private StreamInterface retentateStream;
    private final Map<String, Double> permeateFractions = new HashMap<String, Double>();
    private final Map<String, Double> permeabilities = new HashMap<String, Double>();
    private double defaultPermeateFraction = 0.0;
    private double membraneArea = 0.0;

    public MembraneSeparator(String name) {
        super(name);
    }

    public MembraneSeparator(String name, StreamInterface inletStream) {
        this(name);
        this.setInletStream(inletStream);
    }

    public void setInletStream(StreamInterface inletStream) {
        this.inletStream = inletStream;
        this.permeateStream = new Stream(this.getName() + " permeate", inletStream.getThermoSystem().clone());
        this.retentateStream = new Stream(this.getName() + " retentate", inletStream.getThermoSystem().clone());
    }

    public StreamInterface getPermeateStream() {
        return this.permeateStream;
    }

    public StreamInterface getRetentateStream() {
        return this.retentateStream;
    }

    public void setMembraneArea(double area) {
        this.membraneArea = Math.max(0.0, area);
    }

    public void setPermeability(String component, double permeability) {
        this.permeabilities.put(component, Math.max(0.0, permeability));
    }

    public void clearPermeateFractions() {
        this.permeateFractions.clear();
        this.defaultPermeateFraction = 0.0;
    }

    public void setDefaultPermeateFraction(double fraction) {
        this.defaultPermeateFraction = Math.max(0.0, Math.min(1.0, fraction));
    }

    public void setPermeateFraction(String component, double fraction) {
        this.permeateFractions.put(component, Math.max(0.0, Math.min(1.0, fraction)));
    }

    @Override
    public boolean needRecalculation() {
        return true;
    }

    @Override
    public void run(UUID id) {
        try {
            this.retentateStream.setThermoSystem(this.inletStream.getThermoSystem().clone());
            this.permeateStream.setThermoSystem(this.inletStream.getThermoSystem().clone());
            int comps = this.inletStream.getThermoSystem().getPhase(0).getNumberOfComponents();
            for (int i = 0; i < comps; ++i) {
                String name = this.inletStream.getThermoSystem().getPhase(0).getComponent(i).getName();
                double moles = this.inletStream.getThermoSystem().getPhase(0).getComponent(i).getNumberOfmoles();
                double molesPerm = 0.0;
                if (!this.permeabilities.isEmpty() && this.membraneArea > 0.0) {
                    double xFeed;
                    double partialFeed;
                    double perm = this.permeabilities.getOrDefault(name, 0.0);
                    molesPerm = perm * this.membraneArea * (partialFeed = (xFeed = this.inletStream.getThermoSystem().getPhase(0).getComponent(i).getx()) * this.inletStream.getThermoSystem().getPressure());
                    if (molesPerm > moles) {
                        molesPerm = moles;
                    }
                } else {
                    double frac = this.permeateFractions.getOrDefault(name, this.defaultPermeateFraction);
                    molesPerm = moles * frac;
                }
                this.retentateStream.getThermoSystem().addComponent(name, -moles);
                this.retentateStream.getThermoSystem().addComponent(name, moles - molesPerm);
                this.permeateStream.getThermoSystem().addComponent(name, -moles);
                this.permeateStream.getThermoSystem().addComponent(name, molesPerm);
            }
            ThermodynamicOperations opsRet = new ThermodynamicOperations(this.retentateStream.getThermoSystem());
            opsRet.TPflash();
            ThermodynamicOperations opsPerm = new ThermodynamicOperations(this.permeateStream.getThermoSystem());
            opsPerm.TPflash();
            this.retentateStream.setCalculationIdentifier(id);
            this.permeateStream.setCalculationIdentifier(id);
            this.setCalculationIdentifier(id);
        }
        catch (NullPointerException ex) {
            logger.error("Null pointer exception in membrane separator: ", (Throwable)ex);
            throw ex;
        }
        catch (IllegalArgumentException ex) {
            logger.error("Illegal argument exception in membrane separator: ", (Throwable)ex);
            throw ex;
        }
        catch (IllegalStateException ex) {
            logger.error("Illegal state exception in membrane separator: ", (Throwable)ex);
            throw ex;
        }
        catch (Exception ex) {
            logger.error("Unexpected error in membrane separator: ", (Throwable)ex);
            throw ex;
        }
    }

    @Override
    public void runTransient(double dt, UUID id) {
        this.run(id);
        this.increaseTime(dt);
    }
}

