/*
 * Decompiled with CFR 0.152.
 */
package neqsim.process.equipment.reservoir;

import neqsim.process.equipment.stream.StreamInterface;
import neqsim.thermo.system.SystemInterface;
import neqsim.thermodynamicoperations.ThermodynamicOperations;
import neqsim.util.NamedBaseClass;

public class Well
extends NamedBaseClass {
    private static final long serialVersionUID = 1000L;
    private StreamInterface stream = null;
    double x;
    double y;
    double z;

    public Well(String name) {
        super(name);
    }

    public StreamInterface getStream() {
        return this.stream;
    }

    public void setStream(StreamInterface stream) {
        this.stream = stream;
    }

    public double getGOR() {
        SystemInterface locStream = this.stream.getFluid().clone();
        locStream.setTemperature(288.15);
        locStream.setPressure(1.01325);
        ThermodynamicOperations ops = new ThermodynamicOperations(locStream);
        ops.TPflash();
        double GOR2 = Double.NaN;
        if (locStream.hasPhaseType("gas") && locStream.hasPhaseType("oil")) {
            GOR2 = locStream.getPhase("gas").getVolume("m3") / locStream.getPhase("oil").getVolume("m3");
        }
        return GOR2;
    }

    public double getStdGasProduction() {
        SystemInterface locStream = this.stream.getFluid().clone();
        locStream.setTemperature(288.15);
        locStream.setPressure(1.01325);
        ThermodynamicOperations ops = new ThermodynamicOperations(locStream);
        ops.TPflash();
        double volume = 0.0;
        if (locStream.hasPhaseType("gas")) {
            volume = locStream.getPhase("gas").getVolume("m3");
        }
        return volume;
    }

    public double getStdOilProduction() {
        SystemInterface locStream = this.stream.getFluid().clone();
        locStream.setTemperature(288.15);
        locStream.setPressure(1.01325);
        ThermodynamicOperations ops = new ThermodynamicOperations(locStream);
        ops.TPflash();
        double volume = 0.0;
        if (locStream.hasPhaseType("oil")) {
            volume = locStream.getPhase("oil").getVolume("m3");
        }
        return volume;
    }

    public double getStdWaterProduction() {
        SystemInterface locStream = this.stream.getFluid().clone();
        locStream.setTemperature(288.15);
        locStream.setPressure(1.01325);
        ThermodynamicOperations ops = new ThermodynamicOperations(locStream);
        ops.TPflash();
        double volume = 0.0;
        if (locStream.hasPhaseType("aqueous")) {
            volume = locStream.getPhase("aqueous").getVolume("m3");
        }
        return volume;
    }
}

