/*
 * Decompiled with CFR 0.152.
 */
package neqsim.process.equipment.separator;

import java.util.ArrayList;
import java.util.UUID;
import neqsim.process.equipment.separator.Separator;
import neqsim.process.equipment.separator.sectiontype.SeparatorSection;
import neqsim.process.equipment.stream.Stream;
import neqsim.process.equipment.stream.StreamInterface;
import neqsim.process.mechanicaldesign.separator.GasScrubberMechanicalDesign;
import neqsim.thermo.system.SystemInterface;
import neqsim.util.ExcludeFromJacocoGeneratedReport;

public class NeqGasScrubber
extends Separator {
    private static final long serialVersionUID = 1000L;
    SystemInterface thermoSystem;
    SystemInterface gasSystem;
    SystemInterface waterSystem;
    SystemInterface liquidSystem;
    SystemInterface thermoSystemCloned;
    StreamInterface inletStream;
    StreamInterface gasOutStream;
    StreamInterface liquidOutStream;
    ArrayList<SeparatorSection> scrubberSection = null;

    public NeqGasScrubber(String name) {
        super(name);
        this.setOrientation("vertical");
    }

    public NeqGasScrubber(String name, StreamInterface inletStream) {
        super(name, inletStream);
        this.setOrientation("vertical");
    }

    @Override
    public GasScrubberMechanicalDesign getMechanicalDesign() {
        return new GasScrubberMechanicalDesign(this);
    }

    @Override
    public void setInletStream(StreamInterface inletStream) {
        this.inletStream = inletStream;
        this.thermoSystem = inletStream.getThermoSystem().clone();
        this.gasSystem = this.thermoSystem.phaseToSystem(this.thermoSystem.getPhases()[0]);
        this.gasOutStream = new Stream("gasOutStream", this.gasSystem);
        this.thermoSystem = inletStream.getThermoSystem().clone();
        this.liquidSystem = this.thermoSystem.phaseToSystem(this.thermoSystem.getPhases()[1]);
        this.liquidOutStream = new Stream("liquidOutStream", this.liquidSystem);
    }

    public void addScrubberSection(String type) {
        this.scrubberSection.add(new SeparatorSection("section" + this.scrubberSection.size() + 1, type, this));
    }

    @Override
    public StreamInterface getLiquidOutStream() {
        return this.liquidOutStream;
    }

    @Override
    public StreamInterface getGasOutStream() {
        return this.gasOutStream;
    }

    @Override
    public StreamInterface getGas() {
        return this.getGasOutStream();
    }

    @Override
    public StreamInterface getLiquid() {
        return this.getLiquidOutStream();
    }

    @Override
    public void run(UUID id) {
        this.thermoSystem = this.inletStream.getThermoSystem().clone();
        this.gasSystem = this.thermoSystem.phaseToSystem(this.thermoSystem.getPhases()[0]);
        this.gasSystem.setNumberOfPhases(1);
        this.gasSystem.initProperties();
        this.gasOutStream.setThermoSystem(this.gasSystem);
        this.thermoSystem = this.inletStream.getThermoSystem().clone();
        this.liquidSystem = this.thermoSystem.phaseToSystem(this.thermoSystem.getPhases()[1]);
        this.liquidSystem.setNumberOfPhases(1);
        this.liquidSystem.initProperties();
        this.liquidOutStream.setThermoSystem(this.liquidSystem);
        this.setCalculationIdentifier(id);
    }

    @Override
    @ExcludeFromJacocoGeneratedReport
    public void displayResult() {
    }
}

