/*
 * Decompiled with CFR 0.152.
 */
package neqsim.process.equipment.separator;

import com.google.gson.GsonBuilder;
import java.util.ArrayList;
import java.util.Objects;
import java.util.UUID;
import neqsim.physicalproperties.PhysicalPropertyType;
import neqsim.process.equipment.ProcessEquipmentBaseClass;
import neqsim.process.equipment.mixer.Mixer;
import neqsim.process.equipment.separator.SeparatorInterface;
import neqsim.process.equipment.separator.sectiontype.ManwaySection;
import neqsim.process.equipment.separator.sectiontype.MeshSection;
import neqsim.process.equipment.separator.sectiontype.NozzleSection;
import neqsim.process.equipment.separator.sectiontype.SeparatorSection;
import neqsim.process.equipment.separator.sectiontype.ValveSection;
import neqsim.process.equipment.stream.Stream;
import neqsim.process.equipment.stream.StreamInterface;
import neqsim.process.mechanicaldesign.separator.SeparatorMechanicalDesign;
import neqsim.process.util.monitor.SeparatorResponse;
import neqsim.thermo.system.SystemInterface;
import neqsim.thermo.system.SystemSoreideWhitson;
import neqsim.thermodynamicoperations.ThermodynamicOperations;
import neqsim.util.ExcludeFromJacocoGeneratedReport;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Separator
extends ProcessEquipmentBaseClass
implements SeparatorInterface {
    private static final long serialVersionUID = 1000L;
    static Logger logger = LogManager.getLogger(Separator.class);
    SystemInterface thermoSystem;
    SystemInterface gasSystem;
    SystemInterface waterSystem;
    SystemInterface liquidSystem;
    SystemInterface thermoSystemCloned;
    SystemInterface thermoSystem2;
    private String orientation = "horizontal";
    StreamInterface gasOutStream;
    StreamInterface liquidOutStream;
    private double pressureDrop = 0.0;
    public int numberOfInputStreams = 0;
    Mixer inletStreamMixer = new Mixer("Separator Inlet Stream Mixer");
    private double efficiency = 1.0;
    private double liquidCarryoverFraction = 0.0;
    private double gasCarryunderFraction = 0.0;
    private double separatorLength = 5.0;
    private double internalDiameter = 1.0;
    private double liquidLevel = 0.5;
    double liquidVolume = Math.PI * this.internalDiameter * this.internalDiameter / 4.0 * this.separatorLength * this.liquidLevel;
    double gasVolume = Math.PI * this.internalDiameter * this.internalDiameter / 4.0 * this.separatorLength * (1.0 - this.liquidLevel);
    private double designLiquidLevelFraction = 0.8;
    ArrayList<SeparatorSection> separatorSection = new ArrayList();
    SeparatorMechanicalDesign separatorMechanicalDesign;
    private double lastEnthalpy;
    private double lastFlowRate;
    private double lastPressure;

    public Separator(String name) {
        super(name);
        this.setCalculateSteadyState(true);
    }

    public Separator(String name, StreamInterface inletStream) {
        this(name);
        this.setInletStream(inletStream);
        ++this.numberOfInputStreams;
    }

    @Override
    public SeparatorMechanicalDesign getMechanicalDesign() {
        return this.separatorMechanicalDesign;
    }

    @Override
    public void initMechanicalDesign() {
        this.separatorMechanicalDesign = new SeparatorMechanicalDesign(this);
    }

    public void setInletStream(StreamInterface inletStream) {
        this.inletStreamMixer.addStream(inletStream);
        this.thermoSystem = inletStream.getThermoSystem().clone();
        this.gasSystem = this.thermoSystem.phaseToSystem(this.thermoSystem.getPhases()[0]);
        this.gasOutStream = new Stream("gasOutStream", this.gasSystem);
        this.thermoSystem = inletStream.getThermoSystem().clone();
        this.liquidSystem = this.thermoSystem.phaseToSystem(this.thermoSystem.getPhases()[1]);
        this.liquidOutStream = new Stream("liquidOutStream", this.liquidSystem);
    }

    public void addStream(StreamInterface newStream) {
        if (this.numberOfInputStreams == 0) {
            this.setInletStream(newStream);
        } else {
            this.inletStreamMixer.addStream(newStream);
        }
        ++this.numberOfInputStreams;
    }

    public StreamInterface getLiquidOutStream() {
        if (this.liquidOutStream.getFluid().getClass().getName().equals("neqsim.thermo.system.SystemSoreideWhitson") && !this.liquidOutStream.getFluid().hasPhaseType("aqueous")) {
            ((SystemSoreideWhitson)this.liquidOutStream.getFluid()).setSalinity(0.0, "mole/sec");
        }
        return this.liquidOutStream;
    }

    public StreamInterface getGasOutStream() {
        if (this.gasOutStream.getFluid().getClass().getName().equals("neqsim.thermo.system.SystemSoreideWhitson")) {
            ((SystemSoreideWhitson)this.gasOutStream.getFluid()).setSalinity(0.0, "mole/sec");
        }
        return this.gasOutStream;
    }

    public StreamInterface getGas() {
        return this.getGasOutStream();
    }

    public StreamInterface getLiquid() {
        return this.getLiquidOutStream();
    }

    @Override
    public SystemInterface getThermoSystem() {
        return this.thermoSystem;
    }

    @Override
    public void run(UUID id) {
        this.inletStreamMixer.run(id);
        double enthalpy = this.inletStreamMixer.getOutletStream().getFluid().getEnthalpy();
        double flow = this.inletStreamMixer.getOutletStream().getFlowRate("kg/hr");
        double pres = this.inletStreamMixer.getOutletStream().getPressure();
        if (Math.abs((this.lastEnthalpy - enthalpy) / enthalpy) < 1.0E-6 && Math.abs((this.lastFlowRate - flow) / flow) < 1.0E-6 && Math.abs((this.lastPressure - pres) / pres) < 1.0E-6) {
            return;
        }
        this.lastEnthalpy = this.inletStreamMixer.getOutletStream().getFluid().getEnthalpy();
        this.lastFlowRate = this.inletStreamMixer.getOutletStream().getFlowRate("kg/hr");
        this.lastPressure = this.inletStreamMixer.getOutletStream().getPressure();
        this.thermoSystem2 = this.inletStreamMixer.getOutletStream().getThermoSystem().clone();
        this.thermoSystem2.setPressure(this.thermoSystem2.getPressure() - this.pressureDrop);
        if (Math.abs(this.pressureDrop) > 1.0E-6) {
            ThermodynamicOperations ops = new ThermodynamicOperations(this.thermoSystem2);
            ops.TPflash();
            this.thermoSystem2.initProperties();
        }
        if (this.thermoSystem2.hasPhaseType("gas")) {
            this.gasOutStream.setThermoSystemFromPhase(this.thermoSystem2, "gas");
            this.gasOutStream.getFluid().init(2);
        } else {
            this.gasOutStream.setThermoSystem(this.thermoSystem2.getEmptySystemClone());
        }
        if (this.thermoSystem2.hasPhaseType("aqueous") || this.thermoSystem2.hasPhaseType("oil")) {
            this.liquidOutStream.setThermoSystemFromPhase(this.thermoSystem2, "liquid");
            this.liquidOutStream.getFluid().init(2);
        } else {
            this.liquidOutStream.setThermoSystem(this.thermoSystem2.getEmptySystemClone());
        }
        if (this.thermoSystem2.hasPhaseType("gas")) {
            this.gasOutStream.run(id);
        } else {
            this.gasOutStream.getFluid().init(3);
        }
        if (this.thermoSystem2.hasPhaseType("aqueous") || this.thermoSystem2.hasPhaseType("oil")) {
            this.liquidOutStream.run(id);
        } else {
            try {
                this.liquidOutStream.getFluid().init(3);
            }
            catch (Exception e) {
                logger.error(e.getMessage());
            }
        }
        if (this.getCalculateSteadyState()) {
            this.thermoSystem = this.thermoSystem2;
        } else {
            try {
                this.liquidVolume = Math.PI * this.internalDiameter * this.internalDiameter / 4.0 * this.separatorLength * this.liquidLevel;
                this.gasVolume = Math.PI * this.internalDiameter * this.internalDiameter / 4.0 * this.separatorLength * (1.0 - this.liquidLevel);
                this.thermoSystem = this.thermoSystem2.clone();
                this.thermoSystem.init(1);
                this.thermoSystem.initPhysicalProperties(PhysicalPropertyType.MASS_DENSITY);
                this.thermoSystem2.initPhysicalProperties(PhysicalPropertyType.MASS_DENSITY);
                for (int j = 0; j < this.thermoSystem.getNumberOfPhases(); ++j) {
                    double relFact = 1.0;
                    relFact = this.thermoSystem.getPhase(j).getPhaseTypeName().equals("gas") ? this.gasVolume / this.thermoSystem2.getPhase(j).getVolume("m3") : this.liquidVolume / this.thermoSystem2.getPhase(j).getVolume("m3");
                    for (int i = 0; i < this.thermoSystem.getPhase(j).getNumberOfComponents(); ++i) {
                        this.thermoSystem.addComponent(i, (relFact - 1.0) * this.thermoSystem2.getPhase(j).getComponent(i).getNumberOfMolesInPhase(), j);
                    }
                }
                ThermodynamicOperations ops = new ThermodynamicOperations(this.thermoSystem);
                ops.TPflash();
                this.thermoSystem.init(3);
                this.thermoSystem.initPhysicalProperties(PhysicalPropertyType.MASS_DENSITY);
                if (this.thermoSystem.hasPhaseType("oil") || this.thermoSystem.hasPhaseType("aqueous")) {
                    this.liquidLevel = this.thermoSystem.getPhase(1).getVolume("m3") / (this.liquidVolume + this.gasVolume);
                    this.liquidVolume = this.getLiquidLevel() * 3.14 / 4.0 * this.getInternalDiameter() * this.getInternalDiameter() * this.getSeparatorLength();
                } else {
                    this.liquidLevel = 0.0;
                    this.liquidVolume = 0.0;
                }
                this.gasVolume = (1.0 - this.getLiquidLevel()) * 3.14 / 4.0 * this.getInternalDiameter() * this.getInternalDiameter() * this.getSeparatorLength();
            }
            catch (Exception ex) {
                logger.error(ex.getMessage(), (Throwable)ex);
            }
        }
        this.setCalculationIdentifier(id);
    }

    @Override
    @ExcludeFromJacocoGeneratedReport
    public void displayResult() {
        this.thermoSystem.display();
    }

    @Override
    public String[][] getResultTable() {
        return this.thermoSystem.getResultTable();
    }

    @Override
    public void runTransient(double dt, UUID id) {
        if (this.getCalculateSteadyState()) {
            this.run(id);
            this.increaseTime(dt);
            this.setCalculationIdentifier(id);
        } else {
            this.inletStreamMixer.run(id);
            this.thermoSystem.init(3);
            this.thermoSystem.initPhysicalProperties(PhysicalPropertyType.MASS_DENSITY);
            try {
                this.gasOutStream.getThermoSystem().init(3);
                this.liquidOutStream.getThermoSystem().init(3);
            }
            catch (Exception e) {
                logger.error(e.getMessage());
            }
            boolean hasliq = false;
            double deliq = 0.0;
            if (this.thermoSystem.hasPhaseType("oil") || this.thermoSystem.hasPhaseType("aqueous")) {
                hasliq = true;
                deliq = -this.liquidOutStream.getThermoSystem().getEnthalpy();
            }
            double deltaEnergy = this.inletStreamMixer.getOutletStream().getThermoSystem().getEnthalpy() - this.gasOutStream.getThermoSystem().getEnthalpy() + deliq;
            double newEnergy = this.thermoSystem.getInternalEnergy() + dt * deltaEnergy;
            this.thermoSystem.init(0);
            for (int i = 0; i < this.thermoSystem.getPhase(0).getNumberOfComponents(); ++i) {
                double dncomp = 0.0;
                dncomp += this.inletStreamMixer.getOutletStream().getThermoSystem().getComponent(i).getNumberOfmoles();
                double dniliq = 0.0;
                if (hasliq) {
                    dniliq = -this.liquidOutStream.getThermoSystem().getComponent(i).getNumberOfmoles();
                }
                this.thermoSystem.addComponent(i, (dncomp += -this.gasOutStream.getThermoSystem().getComponent(i).getNumberOfmoles() + dniliq) * dt);
            }
            ThermodynamicOperations thermoOps = new ThermodynamicOperations(this.thermoSystem);
            thermoOps.VUflash(this.gasVolume + this.liquidVolume, newEnergy, "m3", "J");
            this.thermoSystem.initPhysicalProperties(PhysicalPropertyType.MASS_DENSITY);
            if (this.thermoSystem.hasPhaseType("gas")) {
                this.gasOutStream.getFluid().setMolarComposition(this.thermoSystem.getPhase("gas").getMolarComposition());
            }
            if ((this.thermoSystem.hasPhaseType("oil") || this.thermoSystem.hasPhaseType("aqueous")) && this.thermoSystem.getNumberOfPhases() > 1) {
                this.liquidOutStream.getFluid().setMolarComposition(this.thermoSystem.getPhase(1).getMolarComposition());
            }
            this.setTempPres(this.thermoSystem.getTemperature(), this.thermoSystem.getPressure());
            this.liquidLevel = 0.0;
            if (this.thermoSystem.hasPhaseType("oil") || this.thermoSystem.hasPhaseType("aqueous")) {
                double volumeLoc = 0.0;
                if (this.thermoSystem.hasPhaseType("oil")) {
                    volumeLoc += this.thermoSystem.getPhase("oil").getVolume("m3");
                }
                if (this.thermoSystem.hasPhaseType("aqueous")) {
                    volumeLoc += this.thermoSystem.getPhase("aqueous").getVolume("m3");
                }
                this.liquidLevel = volumeLoc / (this.liquidVolume + this.gasVolume);
            }
            this.liquidVolume = this.getLiquidLevel() * 3.14 / 4.0 * this.getInternalDiameter() * this.getInternalDiameter() * this.getSeparatorLength();
            this.gasVolume = (1.0 - this.getLiquidLevel()) * 3.14 / 4.0 * this.getInternalDiameter() * this.getInternalDiameter() * this.getSeparatorLength();
            this.setCalculationIdentifier(id);
        }
    }

    public void setTempPres(double temp, double pres) {
        this.gasOutStream.getThermoSystem().setTemperature(temp);
        this.liquidOutStream.getThermoSystem().setTemperature(temp);
        this.inletStreamMixer.setPressure(pres);
        this.gasOutStream.getThermoSystem().setPressure(pres);
        this.liquidOutStream.getThermoSystem().setPressure(pres);
        UUID id = UUID.randomUUID();
        this.inletStreamMixer.run(id);
        this.gasOutStream.run(id);
        this.liquidOutStream.run(id);
    }

    public double getEfficiency() {
        return this.efficiency;
    }

    public void setEfficiency(double efficiency) {
        this.efficiency = efficiency;
    }

    public double getLiquidCarryoverFraction() {
        return this.liquidCarryoverFraction;
    }

    public void setLiquidCarryoverFraction(double liquidCarryoverFraction) {
        this.liquidCarryoverFraction = liquidCarryoverFraction;
    }

    public double getGasCarryunderFraction() {
        return this.gasCarryunderFraction;
    }

    public void setGasCarryunderFraction(double gasCarryunderFraction) {
        this.gasCarryunderFraction = gasCarryunderFraction;
    }

    @Override
    public void setLiquidLevel(double liquidlev) {
        this.liquidLevel = liquidlev;
    }

    public double getLiquidLevel() {
        return this.liquidLevel;
    }

    public double getPressureDrop() {
        return this.pressureDrop;
    }

    public void setPressureDrop(double pressureDrop) {
        this.pressureDrop = pressureDrop;
    }

    public double getInternalDiameter() {
        return this.internalDiameter;
    }

    @Override
    public void setInternalDiameter(double diameter) {
        this.internalDiameter = diameter;
    }

    public double getGasSuperficialVelocity() {
        return this.thermoSystem.getPhase(0).getVolume("m3") / (3.14159265 * this.getInternalDiameter() * this.getInternalDiameter() / 4.0);
    }

    public double getGasLoadFactor() {
        this.thermoSystem.initPhysicalProperties();
        double term1 = (this.thermoSystem.getPhase(1).getPhysicalProperties().getDensity() - this.thermoSystem.getPhase(0).getPhysicalProperties().getDensity()) / this.thermoSystem.getPhase(0).getPhysicalProperties().getDensity();
        return this.getGasSuperficialVelocity() * Math.sqrt(1.0 / term1);
    }

    public double getGasLoadFactor(int phaseNumber) {
        double gasAreaFraction = 1.0;
        if (this.orientation.equals("horizontal")) {
            gasAreaFraction = 1.0 - this.liquidVolume / (this.liquidVolume + this.gasVolume);
        }
        this.thermoSystem.initPhysicalProperties();
        double term1 = 1.0 / gasAreaFraction * (this.thermoSystem.getPhase(2).getPhysicalProperties().getDensity() - this.thermoSystem.getPhase(0).getPhysicalProperties().getDensity()) / this.thermoSystem.getPhase(0).getPhysicalProperties().getDensity();
        return this.getGasSuperficialVelocity() * Math.sqrt(1.0 / term1);
    }

    public double getDeRatedGasLoadFactor() {
        this.thermoSystem.initPhysicalProperties();
        double derating = 1.0;
        double surfaceTension = this.thermoSystem.getInterphaseProperties().getSurfaceTension(0, 1);
        if (surfaceTension < 0.01) {
            derating = 1.0 - 0.5 * (0.01 - surfaceTension) / 0.01;
        }
        double term1 = (this.thermoSystem.getPhase(1).getPhysicalProperties().getDensity() - this.thermoSystem.getPhase(0).getPhysicalProperties().getDensity()) / this.thermoSystem.getPhase(0).getPhysicalProperties().getDensity();
        return derating * this.getGasSuperficialVelocity() * Math.sqrt(1.0 / term1);
    }

    public double getDeRatedGasLoadFactor(int phaseNum) {
        this.thermoSystem.initPhysicalProperties();
        double derating = 1.0;
        double surfaceTension = this.thermoSystem.getInterphaseProperties().getSurfaceTension(phaseNum - 1, phaseNum);
        if (surfaceTension < 0.01) {
            derating = 1.0 - 0.5 * (0.01 - surfaceTension) / 0.01;
        }
        double term1 = (this.thermoSystem.getPhase(phaseNum).getPhysicalProperties().getDensity() - this.thermoSystem.getPhase(0).getPhysicalProperties().getDensity()) / this.thermoSystem.getPhase(0).getPhysicalProperties().getDensity();
        return derating * this.getGasSuperficialVelocity() * Math.sqrt(1.0 / term1);
    }

    public String getOrientation() {
        return this.orientation;
    }

    public void setOrientation(String orientation) {
        this.orientation = orientation;
    }

    public double getSeparatorLength() {
        return this.separatorLength;
    }

    public void setSeparatorLength(double separatorLength) {
        this.separatorLength = separatorLength;
    }

    public SeparatorSection getSeparatorSection(int i) {
        return this.separatorSection.get(i);
    }

    public SeparatorSection getSeparatorSection(String name) {
        for (SeparatorSection sec : this.separatorSection) {
            if (!sec.getName().equals(name)) continue;
            return sec;
        }
        return null;
    }

    public ArrayList<SeparatorSection> getSeparatorSections() {
        return this.separatorSection;
    }

    public void addSeparatorSection(String name, String type) {
        if (type.equalsIgnoreCase("vane")) {
            this.separatorSection.add(new SeparatorSection(name, type, this));
        } else if (type.equalsIgnoreCase("meshpad")) {
            this.separatorSection.add(new MeshSection(name, type, this));
        } else if (type.equalsIgnoreCase("manway")) {
            this.separatorSection.add(new ManwaySection(name, type, this));
        } else if (type.equalsIgnoreCase("valve")) {
            this.separatorSection.add(new ValveSection(name, type, this));
        } else if (type.equalsIgnoreCase("nozzle")) {
            this.separatorSection.add(new NozzleSection(name, type, this));
        } else {
            this.separatorSection.add(new SeparatorSection(name, type, this));
        }
    }

    public double getDesignLiquidLevelFraction() {
        return this.designLiquidLevelFraction;
    }

    public void setDesignLiquidLevelFraction(double designLiquidLevelFraction) {
        this.designLiquidLevelFraction = designLiquidLevelFraction;
    }

    @Override
    public double getPressure() {
        return this.getThermoSystem().getPressure();
    }

    @Override
    public double getEntropyProduction(String unit) {
        double entrop = 0.0;
        for (int i = 0; i < this.numberOfInputStreams; ++i) {
            this.inletStreamMixer.getStream(i).getFluid().init(3);
            entrop += this.inletStreamMixer.getStream(i).getFluid().getEntropy(unit);
        }
        if (this.thermoSystem.hasPhaseType("aqueous") || this.thermoSystem.hasPhaseType("oil")) {
            try {
                this.getLiquidOutStream().getThermoSystem().init(3);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.thermoSystem.hasPhaseType("gas")) {
            this.getGasOutStream().getThermoSystem().init(3);
        }
        return this.getLiquidOutStream().getThermoSystem().getEntropy(unit) + this.getGasOutStream().getThermoSystem().getEntropy(unit) - entrop;
    }

    @Override
    public double getMassBalance(String unit) {
        double flow = 0.0;
        for (int i = 0; i < this.numberOfInputStreams; ++i) {
            this.inletStreamMixer.getStream(i).getFluid().init(3);
            flow += this.inletStreamMixer.getStream(i).getFluid().getFlowRate(unit);
        }
        this.getLiquidOutStream().getThermoSystem().init(3);
        this.getGasOutStream().getThermoSystem().init(3);
        return this.getLiquidOutStream().getThermoSystem().getFlowRate(unit) + this.getGasOutStream().getThermoSystem().getFlowRate(unit) - flow;
    }

    @Override
    public double getExergyChange(String unit, double surroundingTemperature) {
        double exergy = 0.0;
        for (int i = 0; i < this.numberOfInputStreams; ++i) {
            this.inletStreamMixer.getStream(i).getFluid().init(3);
            exergy += this.inletStreamMixer.getStream(i).getFluid().getExergy(surroundingTemperature, unit);
        }
        this.getLiquidOutStream().getThermoSystem().init(3);
        this.getGasOutStream().getThermoSystem().init(3);
        return this.getLiquidOutStream().getThermoSystem().getExergy(surroundingTemperature, unit) + this.getGasOutStream().getThermoSystem().getExergy(surroundingTemperature, unit) - exergy;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + Objects.hash(this.designLiquidLevelFraction, this.efficiency, this.gasCarryunderFraction, this.gasOutStream, this.gasSystem, this.gasVolume, this.inletStreamMixer, this.internalDiameter, this.liquidCarryoverFraction, this.liquidLevel, this.liquidOutStream, this.liquidSystem, this.liquidVolume, this.numberOfInputStreams, this.orientation, this.pressureDrop, this.separatorLength, this.separatorSection, this.thermoSystem, this.thermoSystem2, this.thermoSystemCloned, this.waterSystem);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Separator other = (Separator)obj;
        return Double.doubleToLongBits(this.designLiquidLevelFraction) == Double.doubleToLongBits(other.designLiquidLevelFraction) && Double.doubleToLongBits(this.efficiency) == Double.doubleToLongBits(other.efficiency) && Double.doubleToLongBits(this.gasCarryunderFraction) == Double.doubleToLongBits(other.gasCarryunderFraction) && Objects.equals(this.gasOutStream, other.gasOutStream) && Objects.equals(this.gasSystem, other.gasSystem) && Double.doubleToLongBits(this.gasVolume) == Double.doubleToLongBits(other.gasVolume) && Objects.equals(this.inletStreamMixer, other.inletStreamMixer) && Double.doubleToLongBits(this.internalDiameter) == Double.doubleToLongBits(other.internalDiameter) && Double.doubleToLongBits(this.liquidCarryoverFraction) == Double.doubleToLongBits(other.liquidCarryoverFraction) && Double.doubleToLongBits(this.liquidLevel) == Double.doubleToLongBits(other.liquidLevel) && Objects.equals(this.liquidOutStream, other.liquidOutStream) && Objects.equals(this.liquidSystem, other.liquidSystem) && Double.doubleToLongBits(this.liquidVolume) == Double.doubleToLongBits(other.liquidVolume) && this.numberOfInputStreams == other.numberOfInputStreams && Objects.equals(this.orientation, other.orientation) && Double.doubleToLongBits(this.pressureDrop) == Double.doubleToLongBits(other.pressureDrop) && Double.doubleToLongBits(this.separatorLength) == Double.doubleToLongBits(other.separatorLength) && Objects.equals(this.separatorSection, other.separatorSection) && Objects.equals(this.thermoSystem, other.thermoSystem) && Objects.equals(this.thermoSystem2, other.thermoSystem2) && Objects.equals(this.thermoSystemCloned, other.thermoSystemCloned) && Objects.equals(this.waterSystem, other.waterSystem);
    }

    public StreamInterface getFeedStream() {
        return this.inletStreamMixer.getOutletStream();
    }

    @Override
    public String toJson() {
        return new GsonBuilder().create().toJson(new SeparatorResponse(this));
    }
}

