/*
 * Decompiled with CFR 0.152.
 */
package neqsim.process.equipment.splitter;

import java.util.Arrays;
import java.util.UUID;
import neqsim.process.equipment.ProcessEquipmentBaseClass;
import neqsim.process.equipment.mixer.Mixer;
import neqsim.process.equipment.splitter.SplitterInterface;
import neqsim.process.equipment.stream.Stream;
import neqsim.process.equipment.stream.StreamInterface;
import neqsim.thermo.system.SystemInterface;
import neqsim.thermodynamicoperations.ThermodynamicOperations;
import neqsim.util.ExcludeFromJacocoGeneratedReport;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Splitter
extends ProcessEquipmentBaseClass
implements SplitterInterface {
    private static final long serialVersionUID = 1000L;
    static Logger logger = LogManager.getLogger(Splitter.class);
    SystemInterface thermoSystem;
    SystemInterface gasSystem;
    SystemInterface waterSystem;
    SystemInterface liquidSystem;
    SystemInterface thermoSystemCloned;
    StreamInterface inletStream;
    StreamInterface[] splitStream;
    protected int splitNumber = 1;
    double[] splitFactor = new double[1];
    double[] flowRates;
    String flowUnit = "mole/sec";
    protected double[] oldSplitFactor = null;
    protected double lastTemperature = 0.0;
    protected double lastPressure = 0.0;
    protected double lastFlowRate = 0.0;
    protected double[] lastComposition = null;

    public Splitter(String name) {
        super(name);
    }

    public Splitter(String name, StreamInterface inStream) {
        this(name);
        this.setInletStream(inStream);
    }

    public StreamInterface getInletStream() {
        return this.inletStream;
    }

    public Splitter(String name, StreamInterface inletStream, int number_of_splits) {
        this(name);
        this.setSplitNumber(number_of_splits);
        this.setInletStream(inletStream);
    }

    @Override
    public void setSplitNumber(int number_of_splits) {
        this.splitNumber = number_of_splits;
        this.splitFactor = new double[this.splitNumber];
        this.splitFactor[0] = 1.0;
        if (this.inletStream != null) {
            this.setInletStream(this.inletStream);
        }
    }

    public void setSplitFactors(double[] splitFact) {
        int i;
        double sum = 0.0;
        for (i = 0; i < splitFact.length; ++i) {
            if (splitFact[i] < 0.0) {
                splitFact[i] = 0.0;
            }
            sum += splitFact[i];
        }
        this.splitFactor = new double[splitFact.length];
        for (i = 0; i < splitFact.length; ++i) {
            this.splitFactor[i] = splitFact[i] / sum;
        }
        this.splitNumber = splitFact.length;
        this.flowRates = null;
        this.setInletStream(this.inletStream);
    }

    public void setFlowRates(double[] flowRates, String flowUnit) {
        if (flowRates.length != this.splitNumber) {
            this.setInletStream(this.inletStream);
        }
        this.flowRates = flowRates;
        this.flowUnit = flowUnit;
        this.splitNumber = flowRates.length;
        this.splitFactor = new double[flowRates.length];
        this.splitFactor[0] = 1.0;
        this.setInletStream(this.inletStream);
    }

    public void calcSplitFactors() {
        int i;
        double sum = 0.0;
        for (int i2 = 0; i2 < this.flowRates.length; ++i2) {
            if (!(this.flowRates[i2] > 0.0)) continue;
            sum += this.flowRates[i2];
        }
        double missingFlowRate = 0.0;
        for (i = 0; i < this.flowRates.length; ++i) {
            if (!(this.flowRates[i] < -0.1)) continue;
            missingFlowRate = this.inletStream.getFlowRate(this.flowUnit) - sum;
            sum += missingFlowRate;
        }
        this.splitFactor = new double[this.flowRates.length];
        for (i = 0; i < this.flowRates.length; ++i) {
            this.splitFactor[i] = this.flowRates[i] / sum;
            if (!(this.flowRates[i] < -0.1)) continue;
            this.splitFactor[i] = missingFlowRate / sum;
        }
    }

    @Override
    public void setInletStream(StreamInterface inletStream) {
        this.inletStream = inletStream;
        if (this.splitStream == null || this.splitStream.length != this.splitNumber) {
            this.splitStream = new Stream[this.splitNumber];
            try {
                for (int i = 0; i < this.splitNumber; ++i) {
                    this.splitStream[i] = new Stream("Split Stream_" + i, inletStream.getThermoSystem().clone());
                }
            }
            catch (Exception ex) {
                logger.error(ex.getMessage(), (Throwable)ex);
            }
        }
    }

    @Override
    public StreamInterface getSplitStream(int i) {
        return this.splitStream[i];
    }

    @Override
    public boolean needRecalculation() {
        return this.inletStream.getFluid().getTemperature() != this.lastTemperature || this.inletStream.getFluid().getPressure() != this.lastPressure || !(Math.abs(this.inletStream.getFluid().getFlowRate("kg/hr") - this.lastFlowRate) / this.inletStream.getFluid().getFlowRate("kg/hr") < 1.0E-6) || !Arrays.equals(this.splitFactor, this.oldSplitFactor);
    }

    @Override
    public void run(UUID id) {
        int i;
        double totSplit = 0.0;
        if (this.flowRates != null) {
            this.calcSplitFactors();
        }
        for (i = 0; i < this.splitNumber; ++i) {
            if (this.splitFactor[i] < 0.0) {
                logger.debug("split factor negative = " + this.splitFactor[i]);
                this.splitFactor[i] = 0.0;
            }
            totSplit += this.splitFactor[i];
        }
        if (Math.abs(totSplit - 1.0) > 1.0E-10) {
            logger.debug("total split factor different from 0 in splitter - totsplit = " + totSplit);
            logger.debug("setting first split to = " + (1.0 - totSplit));
            this.splitFactor[0] = 1.0 - totSplit;
        }
        for (i = 0; i < this.splitNumber; ++i) {
            this.thermoSystem = this.inletStream.getThermoSystem().clone();
            this.thermoSystem.init(0);
            this.splitStream[i].setThermoSystem(this.thermoSystem);
            for (int j = 0; j < this.inletStream.getThermoSystem().getPhase(0).getNumberOfComponents(); ++j) {
                int index = this.inletStream.getThermoSystem().getPhase(0).getComponent(j).getComponentNumber();
                double moles = this.inletStream.getThermoSystem().getPhase(0).getComponent(j).getNumberOfmoles();
                double change = moles * this.splitFactor[i] - moles > 0.0 ? 0.0 : moles * this.splitFactor[i] - moles;
                this.splitStream[i].getThermoSystem().addComponent(index, change);
            }
            ThermodynamicOperations thermoOps = new ThermodynamicOperations(this.splitStream[i].getThermoSystem());
            thermoOps.TPflash();
        }
        this.lastFlowRate = this.thermoSystem.getFlowRate("kg/hr");
        this.lastTemperature = this.thermoSystem.getTemperature();
        this.lastPressure = this.thermoSystem.getPressure();
        this.lastComposition = this.thermoSystem.getMolarComposition();
        this.oldSplitFactor = Arrays.copyOf(this.splitFactor, this.splitFactor.length);
        this.setCalculationIdentifier(id);
    }

    @Override
    public void runTransient(double dt, UUID id) {
        if (this.getCalculateSteadyState()) {
            this.run(id);
            this.increaseTime(dt);
        } else {
            Mixer mixer = new Mixer("tmpMixer");
            for (int i = 0; i < this.splitStream.length; ++i) {
                this.splitStream[i].setPressure(this.inletStream.getPressure());
                this.splitStream[i].setTemperature(this.inletStream.getTemperature("C"), "C");
                this.splitStream[i].run();
                mixer.addStream(this.splitStream[i]);
            }
            mixer.run();
            this.inletStream.setThermoSystem(mixer.getThermoSystem());
            this.inletStream.run();
            this.lastFlowRate = this.thermoSystem.getFlowRate("kg/hr");
            this.lastTemperature = this.thermoSystem.getTemperature();
            this.lastPressure = this.thermoSystem.getPressure();
            this.lastComposition = this.thermoSystem.getMolarComposition();
            this.oldSplitFactor = Arrays.copyOf(this.splitFactor, this.splitFactor.length);
            this.setCalculationIdentifier(id);
        }
    }

    public double getSplitFactor(int i) {
        return this.splitFactor[i];
    }

    public double[] getSplitFactors() {
        return this.splitFactor;
    }

    @Override
    @ExcludeFromJacocoGeneratedReport
    public void displayResult() {
    }
}

