/*
 * Decompiled with CFR 0.152.
 */
package neqsim.process.equipment.subsea;

import java.util.UUID;
import neqsim.process.equipment.TwoPortEquipment;
import neqsim.process.equipment.pipeline.AdiabaticTwoPhasePipe;
import neqsim.process.equipment.stream.StreamInterface;
import neqsim.thermo.system.SystemInterface;

public class SimpleFlowLine
extends TwoPortEquipment {
    private static final long serialVersionUID = 1000L;
    private double height = 100.0;
    public double length = 520.0;
    double outletTemperature = 313.15;
    AdiabaticTwoPhasePipe pipeline;

    public SimpleFlowLine(String name, StreamInterface inStream) {
        super(name);
        this.setInletStream(inStream);
        this.pipeline = new AdiabaticTwoPhasePipe("pipeline", inStream);
    }

    public AdiabaticTwoPhasePipe getPipeline() {
        return this.pipeline;
    }

    @Override
    public SystemInterface getThermoSystem() {
        return this.getOutletStream().getThermoSystem();
    }

    @Override
    public void run(UUID id) {
        this.pipeline.run(id);
        this.getOutletStream().setFluid(this.pipeline.getOutletStream().getFluid());
        this.setCalculationIdentifier(id);
    }

    public double getHeight() {
        return this.height;
    }

    public void setHeight(double height) {
        this.height = height;
    }
}

