/*
 * Decompiled with CFR 0.152.
 */
package neqsim.process.equipment.util;

import java.util.UUID;
import neqsim.process.equipment.ProcessEquipmentInterface;
import neqsim.process.equipment.TwoPortEquipment;
import neqsim.process.equipment.mixer.StaticMixer;
import neqsim.process.equipment.stream.Stream;
import neqsim.process.equipment.stream.StreamInterface;
import neqsim.thermo.system.SystemInterface;
import neqsim.thermodynamicoperations.ThermodynamicOperations;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FlowRateAdjuster
extends TwoPortEquipment {
    private static final long serialVersionUID = 1000L;
    static Logger logger = LogManager.getLogger(FlowRateAdjuster.class);
    String name = "Flow Rate Adjuster";
    public double desiredGasFlow;
    public double desiredOilFlow;
    public double desiredWaterFlow;
    private String unit;
    ProcessEquipmentInterface adjustedEquipment = null;
    ProcessEquipmentInterface targetEquipment = null;
    String adjustedVariable = "";
    String adjustedVariableUnit = "";
    double maxAdjustedValue = 1.0E10;
    double minAdjustedValue = -1.0E10;
    String targetVariable = "";
    String targetPhase = "";
    String targetComponent = "";
    double targetValue = 0.0;
    String targetUnit = "";
    private double tolerance = 1.0E-6;
    double inputValue = 0.0;
    double oldInputValue = 0.0;
    private double error = 1000000.0;
    private double oldError = 1000000.0;
    int iterations = 0;
    private boolean activateWhenLess = false;
    Stream waterStream;
    double waterDensity;

    public FlowRateAdjuster(String name) {
        super(name);
    }

    public FlowRateAdjuster(String name, StreamInterface inStream) {
        super(name, inStream);
    }

    public void setAdjustedFlowRates(Double desiredGasFlow, Double desiredOilFlow, Double desiredWaterFlow, String unit) {
        this.desiredGasFlow = desiredGasFlow;
        this.desiredOilFlow = desiredOilFlow;
        this.desiredWaterFlow = desiredWaterFlow;
        this.unit = unit;
    }

    public void setAdjustedFlowRates(Double desiredGasFlow, Double desiredOilFlow, String unit) {
        this.setAdjustedFlowRates(desiredGasFlow, desiredOilFlow, 0.0, unit);
    }

    @Override
    public void run(UUID id) {
        SystemInterface adjustedFluid = this.inStream.getFluid();
        ThermodynamicOperations thermoOps = new ThermodynamicOperations(adjustedFluid);
        try {
            thermoOps.TPflash();
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
        SystemInterface gasFluid = adjustedFluid.phaseToSystem(0).clone();
        SystemInterface oilFluid = adjustedFluid.phaseToSystem(1).clone();
        double temperature = this.inStream.getTemperature("C");
        double pressure = this.inStream.getPressure("bara");
        if (this.desiredWaterFlow > 0.0) {
            SystemInterface waterFluid = adjustedFluid.phaseToSystem(2).clone();
            waterFluid.initPhysicalProperties();
            this.waterDensity = waterFluid.getDensity("kg/m3");
            this.waterStream = new Stream("Water Stream", waterFluid);
            this.waterStream.setTemperature(temperature, "C");
            this.waterStream.setPressure(pressure, "bara");
        }
        gasFluid.initPhysicalProperties();
        oilFluid.initPhysicalProperties();
        double oilDensity = oilFluid.getDensity("kg/m3");
        Stream gasStream = new Stream("Gas Stream", gasFluid);
        gasStream.setTemperature(temperature, "C");
        gasStream.setPressure(pressure, "bara");
        Stream oilStream = new Stream("Oil Stream", oilFluid);
        oilStream.setTemperature(temperature, "C");
        oilStream.setPressure(pressure, "bara");
        if (this.unit.equals("Sm3/hr")) {
            gasStream.setFlowRate(this.desiredGasFlow, this.unit);
            oilStream.setFlowRate(this.desiredOilFlow * oilDensity, "kg/hr");
            if (this.desiredWaterFlow > 0.0) {
                this.waterStream.setFlowRate(this.desiredWaterFlow * this.waterDensity, "kg/hr");
            }
        } else {
            gasStream.setFlowRate(this.desiredGasFlow, this.unit);
            oilStream.setFlowRate(this.desiredOilFlow, this.unit);
            if (this.desiredWaterFlow > 0.0) {
                this.waterStream.setFlowRate(this.desiredWaterFlow, this.unit);
            }
        }
        gasStream.run();
        oilStream.run();
        if (this.desiredWaterFlow > 0.0) {
            this.waterStream.run();
        }
        StaticMixer wellStramMixer = new StaticMixer("Stream mixer");
        wellStramMixer.addStream(gasStream);
        wellStramMixer.addStream(oilStream);
        if (this.desiredWaterFlow > 0.0) {
            wellStramMixer.addStream(this.waterStream);
        }
        wellStramMixer.run();
        this.outStream.setThermoSystem(wellStramMixer.getOutletStream().getFluid());
        this.outStream.run();
        this.outStream.setCalculationIdentifier(id);
    }
}

