/*
 * Decompiled with CFR 0.152.
 */
package neqsim.process.equipment.util;

import com.google.gson.GsonBuilder;
import java.util.ArrayList;
import java.util.UUID;
import neqsim.process.equipment.ProcessEquipmentBaseClass;
import neqsim.process.equipment.mixer.MixerInterface;
import neqsim.process.equipment.stream.StreamInterface;
import neqsim.process.util.monitor.RecycleResponse;
import neqsim.thermo.system.SystemInterface;
import neqsim.thermodynamicoperations.ThermodynamicOperations;
import neqsim.util.ExcludeFromJacocoGeneratedReport;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Recycle
extends ProcessEquipmentBaseClass
implements MixerInterface {
    private static final long serialVersionUID = 1000L;
    static Logger logger = LogManager.getLogger(Recycle.class);
    protected ArrayList<StreamInterface> streams = new ArrayList(0);
    private ArrayList<String> downstreamProperty = new ArrayList(0);
    protected int numberOfInputStreams = 0;
    protected StreamInterface mixedStream;
    StreamInterface lastIterationStream = null;
    private StreamInterface outletStream = null;
    private int priority = 100;
    boolean firstTime = true;
    int iterations = 0;
    int maxIterations = 10;
    private double errorComposition = 1.0E10;
    private double errorFlow = 1.0E10;
    private double errorTemperature = 1.0E10;
    private double errorPressure = 1.0E10;
    private double flowTolerance = 0.01;
    private double compositionTolerance = 0.01;
    private double temperatureTolerance = 0.01;
    private double pressureTolerance = 0.01;
    private double minimumFlow = 1.0E-20;

    public Recycle(String name) {
        super(name);
    }

    public void setCompositionTolerance(double compositionTolerance) {
        this.compositionTolerance = compositionTolerance;
    }

    public double getCompositionTolerance() {
        return this.compositionTolerance;
    }

    public void setTemperatureTolerance(double temperatureTolerance) {
        this.temperatureTolerance = temperatureTolerance;
    }

    public double getTemperatureTolerance() {
        return this.temperatureTolerance;
    }

    public void setFlowTolerance(double flowTolerance) {
        this.flowTolerance = flowTolerance;
    }

    public double getFlowTolerance() {
        return this.flowTolerance;
    }

    public void resetIterations() {
        this.iterations = 0;
    }

    @Override
    public SystemInterface getThermoSystem() {
        return this.mixedStream.getThermoSystem();
    }

    public void setDownstreamProperty(ArrayList<String> property) {
        this.downstreamProperty = property;
    }

    public void setDownstreamProperty(String property) {
        this.downstreamProperty.add(property);
    }

    @Override
    public void replaceStream(int i, StreamInterface newStream) {
        this.streams.set(i, newStream);
    }

    @Override
    public void addStream(StreamInterface newStream) {
        this.streams.add(newStream);
        if (this.numberOfInputStreams == 0) {
            this.mixedStream = this.streams.get(0).clone(this.getName() + " mixed stream");
        }
        this.mixedStream.setEmptyThermoSystem(this.streams.get(0).getThermoSystem());
        ++this.numberOfInputStreams;
        this.lastIterationStream = this.mixedStream.clone(this.getName() + " last iteration stream");
    }

    public StreamInterface getStream(int i) {
        return this.streams.get(i);
    }

    public void mixStream() {
        int index = 0;
        for (int k = 1; k < this.streams.size(); ++k) {
            for (int i = 0; i < this.streams.get(k).getThermoSystem().getPhase(0).getNumberOfComponents(); ++i) {
                boolean gotComponent = false;
                String componentName = this.streams.get(k).getThermoSystem().getPhase(0).getComponent(i).getName();
                double moles = this.streams.get(k).getThermoSystem().getPhase(0).getComponent(i).getNumberOfmoles();
                for (int p = 0; p < this.mixedStream.getThermoSystem().getPhase(0).getNumberOfComponents(); ++p) {
                    if (!this.mixedStream.getThermoSystem().getPhase(0).getComponent(p).getName().equals(componentName)) continue;
                    gotComponent = true;
                    index = this.streams.get(0).getThermoSystem().getPhase(0).getComponent(p).getComponentNumber();
                }
                if (gotComponent) {
                    this.mixedStream.getThermoSystem().addComponent(index, moles);
                    continue;
                }
                logger.warn("ikke gaa hit");
                this.mixedStream.getThermoSystem().addComponent(index, moles);
            }
        }
    }

    public double guessTemperature() {
        double gtemp = 0.0;
        for (int k = 0; k < this.streams.size(); ++k) {
            gtemp += this.streams.get(k).getThermoSystem().getTemperature() * this.streams.get(k).getThermoSystem().getNumberOfMoles() / this.mixedStream.getThermoSystem().getNumberOfMoles();
        }
        return gtemp;
    }

    public double calcMixStreamEnthalpy() {
        double enthalpy = 0.0;
        for (int k = 0; k < this.streams.size(); ++k) {
            this.streams.get(k).getThermoSystem().init(3);
            enthalpy += this.streams.get(k).getThermoSystem().getEnthalpy();
        }
        return enthalpy;
    }

    @Override
    @Deprecated
    public StreamInterface getOutStream() {
        return this.mixedStream;
    }

    public void initiateDownstreamProperties(StreamInterface outstream) {
        this.lastIterationStream = outstream.clone();
    }

    public void setDownstreamProperties() {
        if (this.downstreamProperty.size() > 0) {
            for (int i = 0; i < this.downstreamProperty.size(); ++i) {
                if (!this.downstreamProperty.get(i).equals("flow rate")) continue;
                this.mixedStream.setFlowRate(this.outletStream.getFlowRate("kg/hr"), "kg/hr");
            }
        }
    }

    @Override
    public void run(UUID id) {
        ++this.iterations;
        this.isActive(true);
        double enthalpy = 0.0;
        SystemInterface thermoSystem2 = this.streams.get(0).getThermoSystem().clone();
        if (this.numberOfInputStreams == 1 && thermoSystem2.getFlowRate("kg/hr") < this.minimumFlow) {
            this.isActive(false);
            this.mixedStream.setThermoSystem(thermoSystem2);
            this.setErrorCompositon(0.0);
            this.setErrorFlow(this.flowBalanceCheck());
            this.setErrorTemperature(this.temperatureBalanceCheck());
            this.setErrorPressure(this.pressureBalanceCheck());
            this.outletStream.setThermoSystem(this.mixedStream.getThermoSystem());
            this.outletStream.setCalculationIdentifier(id);
            return;
        }
        this.mixedStream.setThermoSystem(thermoSystem2);
        ThermodynamicOperations testOps = new ThermodynamicOperations(thermoSystem2);
        if (this.streams.size() > 1) {
            this.mixedStream.getThermoSystem().setNumberOfPhases(2);
            this.mixedStream.getThermoSystem().reInitPhaseType();
            this.mixedStream.getThermoSystem().init(0);
            this.mixStream();
            if (this.mixedStream.getFlowRate("kg/hr") < this.minimumFlow) {
                this.isActive(false);
                this.mixedStream.setThermoSystem(thermoSystem2);
                this.setErrorCompositon(0.0);
                this.setErrorFlow(this.flowBalanceCheck());
                this.setErrorTemperature(this.temperatureBalanceCheck());
                this.setErrorPressure(this.pressureBalanceCheck());
                this.outletStream.setThermoSystem(this.mixedStream.getThermoSystem());
                this.outletStream.setCalculationIdentifier(id);
                return;
            }
            this.setDownstreamProperties();
            try {
                enthalpy = this.calcMixStreamEnthalpy();
            }
            catch (Exception ex) {
                logger.error(ex.getMessage(), (Throwable)ex);
                return;
            }
            this.mixedStream.getThermoSystem().setTemperature(this.guessTemperature());
            testOps.PHflash(enthalpy, 0);
        } else {
            this.setDownstreamProperties();
            testOps.TPflash();
        }
        this.mixedStream.setCalculationIdentifier(id);
        this.setErrorCompositon(this.compositionBalanceCheck());
        this.setErrorFlow(this.flowBalanceCheck());
        this.setErrorTemperature(this.temperatureBalanceCheck());
        this.setErrorPressure(this.pressureBalanceCheck());
        this.lastIterationStream = this.mixedStream.clone();
        this.outletStream.setThermoSystem(this.mixedStream.getThermoSystem());
        this.outletStream.setCalculationIdentifier(id);
        this.setCalculationIdentifier(id);
    }

    public double flowBalanceCheck() {
        double abs_sum_errorFlow = 0.0;
        abs_sum_errorFlow = this.mixedStream.getFlowRate("kg/sec") < 1.0 ? (abs_sum_errorFlow += Math.abs(this.mixedStream.getFlowRate("kg/sec") - this.lastIterationStream.getFlowRate("kg/sec"))) : (abs_sum_errorFlow += Math.abs(this.mixedStream.getFlowRate("kg/sec") - this.lastIterationStream.getFlowRate("kg/sec")) / this.mixedStream.getFlowRate("kg/sec") * 100.0);
        return abs_sum_errorFlow;
    }

    public double compositionBalanceCheck() {
        if (this.lastIterationStream.getFluid().getNumberOfComponents() != this.mixedStream.getFluid().getNumberOfComponents()) {
            return 10.0;
        }
        double abs_sum_error = 0.0;
        for (int i = 0; i < this.mixedStream.getThermoSystem().getPhase(0).getNumberOfComponents(); ++i) {
            abs_sum_error += Math.abs(this.mixedStream.getThermoSystem().getPhase(0).getComponent(i).getx() - this.lastIterationStream.getThermoSystem().getPhase(0).getComponent(i).getx());
        }
        return abs_sum_error;
    }

    public double temperatureBalanceCheck() {
        double error = 0.0;
        for (int i = 0; i < this.mixedStream.getThermoSystem().getNumberOfPhases(); ++i) {
            error += Math.abs((this.mixedStream.getThermoSystem().getPhase(i).getTemperature() - this.lastIterationStream.getThermoSystem().getPhase(i).getTemperature()) / this.lastIterationStream.getThermoSystem().getPhase(i).getTemperature()) * 100.0;
        }
        return error;
    }

    public double pressureBalanceCheck() {
        double error = 0.0;
        for (int i = 0; i < this.mixedStream.getThermoSystem().getNumberOfPhases(); ++i) {
            error += Math.abs((this.mixedStream.getThermoSystem().getPhase(i).getPressure() - this.lastIterationStream.getThermoSystem().getPhase(i).getPressure()) / this.lastIterationStream.getThermoSystem().getPhase(i).getPressure()) * 100.0;
        }
        return error;
    }

    @Override
    @ExcludeFromJacocoGeneratedReport
    public void displayResult() {
    }

    @Override
    public void setPressure(double pres) {
        for (int k = 0; k < this.streams.size(); ++k) {
            this.streams.get(k).getThermoSystem().setPressure(pres);
        }
        this.mixedStream.getThermoSystem().setPressure(pres);
    }

    @Override
    public void setTemperature(double temp) {
        for (int k = 0; k < this.streams.size(); ++k) {
            this.streams.get(k).getThermoSystem().setTemperature(temp);
        }
        this.mixedStream.getThermoSystem().setTemperature(temp);
    }

    public void setTolerance(double tolerance) {
        this.flowTolerance = tolerance;
        this.temperatureTolerance = tolerance;
        this.compositionTolerance = tolerance;
    }

    public void setErrorTemperature(double errorTemperature) {
        this.errorTemperature = errorTemperature;
    }

    public void setErrorPressure(double errorPressure) {
        this.errorPressure = errorPressure;
    }

    public void setErrorFlow(double errorFlow) {
        this.errorFlow = errorFlow;
    }

    public double getErrorFlow() {
        return this.errorFlow;
    }

    public double getErrorTemperature() {
        return this.errorTemperature;
    }

    public double getErrorPressure() {
        return this.errorPressure;
    }

    public void setErrorCompositon(double errorComposition) {
        this.errorComposition = errorComposition;
    }

    public double getErrorComposition() {
        return this.errorComposition;
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    @Override
    public boolean solved() {
        if (this.getOutletStream().getFlowRate("kg/hr") < 1.0E-20 && this.iterations > 1) {
            return true;
        }
        return Math.abs(this.errorComposition) < this.compositionTolerance && Math.abs(this.errorFlow) < this.flowTolerance && Math.abs(this.errorTemperature) < this.temperatureTolerance && Math.abs(this.errorPressure) < this.pressureTolerance && this.iterations > 1;
    }

    public ArrayList<String> getDownstreamProperty() {
        return this.downstreamProperty;
    }

    @Override
    public StreamInterface getOutletStream() {
        return this.outletStream;
    }

    public void setOutletStream(StreamInterface outletStream) {
        this.outletStream = outletStream;
        this.lastIterationStream = this.outletStream.clone();
    }

    @Override
    public void removeInputStream(int i) {
        this.streams.remove(i);
    }

    @Override
    public double getMinimumFlow() {
        return this.minimumFlow;
    }

    @Override
    public void setMinimumFlow(double minimumFlow) {
        this.minimumFlow = minimumFlow;
    }

    @Override
    public String toJson() {
        return new GsonBuilder().create().toJson(new RecycleResponse(this));
    }
}

