/*
 * Decompiled with CFR 0.152.
 */
package neqsim.process.equipment.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import neqsim.process.equipment.ProcessEquipmentBaseClass;
import neqsim.process.equipment.ProcessEquipmentInterface;
import neqsim.process.equipment.compressor.Compressor;
import neqsim.process.equipment.heatexchanger.Cooler;
import neqsim.process.equipment.heatexchanger.Heater;
import neqsim.process.equipment.pump.Pump;
import neqsim.process.equipment.stream.Stream;
import neqsim.process.equipment.valve.ThrottlingValve;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Setter
extends ProcessEquipmentBaseClass {
    private static final long serialVersionUID = 1000L;
    static Logger logger = LogManager.getLogger(Setter.class);
    private List<ProcessEquipmentInterface> targetEquipment = new ArrayList<ProcessEquipmentInterface>();
    private List<Map<String, Object>> parameters = new ArrayList<Map<String, Object>>();

    @Deprecated
    public Setter() {
        this("Setter");
    }

    public Setter(String name) {
        super(name);
    }

    public void addTargetEquipment(ProcessEquipmentInterface equipment) {
        this.targetEquipment.add(equipment);
    }

    public void addTargetEquipment(List<ProcessEquipmentInterface> equipmentList) {
        this.targetEquipment.addAll(equipmentList);
    }

    public void addParameter(String type, String unit, double value) {
        HashMap<String, Object> parameter = new HashMap<String, Object>();
        parameter.put("type", type);
        parameter.put("unit", unit);
        parameter.put("value", value);
        this.parameters.add(parameter);
    }

    public List<Map<String, Object>> getParameters() {
        return this.parameters;
    }

    @Override
    public void run(UUID id) {
        this.setCalculationIdentifier(id);
        for (ProcessEquipmentInterface equipment : this.targetEquipment) {
            try {
                logger.info("Running equipment: " + equipment.getName());
                for (Map<String, Object> parameter : this.parameters) {
                    String type = (String)parameter.get("type");
                    String unit = (String)parameter.get("unit");
                    double value = (Double)parameter.get("value");
                    if (equipment instanceof Stream) {
                        Stream stream = (Stream)equipment;
                        switch (type.toLowerCase()) {
                            case "pressure": {
                                stream.setPressure(value, unit);
                                logger.info("Set pressure to " + value + " " + unit + " for stream: " + stream.getName());
                                break;
                            }
                            case "temperature": {
                                stream.setTemperature(value, unit);
                                logger.info("Set temperature to " + value + " " + unit + " for stream: " + stream.getName());
                                break;
                            }
                            default: {
                                logger.warn("Unknown specification type: " + type + " for stream: " + stream.getName());
                                break;
                            }
                        }
                        continue;
                    }
                    if (equipment instanceof Compressor) {
                        Compressor comp1 = (Compressor)equipment;
                        if ("pressure".equalsIgnoreCase(type)) {
                            comp1.setOutletPressure(value, unit);
                            logger.info("Set outlet pressure to " + value + " " + unit + " for compressor: " + comp1.getName());
                            continue;
                        }
                        logger.warn("Unknown specification type: " + type + " for compressor: " + comp1.getName());
                        continue;
                    }
                    if (equipment instanceof Pump) {
                        Pump pump1 = (Pump)equipment;
                        if ("pressure".equalsIgnoreCase(type)) {
                            pump1.setOutletPressure(value, unit);
                            logger.info("Set outlet pressure to " + value + " " + unit + " for compressor: " + pump1.getName());
                            continue;
                        }
                        logger.warn("Unknown specification type: " + type + " for pump1: " + pump1.getName());
                        continue;
                    }
                    if (equipment instanceof ThrottlingValve) {
                        ThrottlingValve valve = (ThrottlingValve)equipment;
                        if ("pressure".equalsIgnoreCase(type)) {
                            valve.setOutletPressure(value, unit);
                            logger.info("Set outlet pressure to " + value + " " + unit + " for throttling valve: " + valve.getName());
                            continue;
                        }
                        logger.warn("Unknown specification type: " + type + " for throttling valve: " + valve.getName());
                        continue;
                    }
                    if (equipment instanceof Heater) {
                        Heater heater = (Heater)equipment;
                        if ("temperature".equalsIgnoreCase(type)) {
                            heater.setOutTemperature(value, unit);
                            logger.info("Set outlet temperature to " + value + " " + unit + " for heater: " + heater.getName());
                            continue;
                        }
                        logger.warn("Unknown specification type: " + type + " for heater: " + heater.getName());
                        continue;
                    }
                    if (equipment instanceof Cooler) {
                        Cooler cooler = (Cooler)equipment;
                        if ("temperature".equalsIgnoreCase(type)) {
                            cooler.setOutTemperature(value, unit);
                            logger.info("Set outlet temperature to " + value + " " + unit + " for cooler: " + cooler.getName());
                            continue;
                        }
                        if ("pressure".equalsIgnoreCase(type)) {
                            cooler.setOutPressure(value, unit);
                            logger.info("Set outlet pressure to " + value + " " + unit + " for cooler: " + cooler.getName());
                            continue;
                        }
                        logger.warn("Unknown specification type: " + type + " for cooler: " + cooler.getName());
                        continue;
                    }
                    logger.warn("Unsupported equipment type: " + equipment.getClass().getSimpleName() + " for equipment: " + equipment.getName());
                }
            }
            catch (Exception ex) {
                logger.error("Error setting specification for equipment: " + equipment.getName(), (Throwable)ex);
            }
        }
    }

    public static void main(String[] args) {
        Setter setter = new Setter("Test Setter");
        setter.addParameter("temperature", "C", 150.0);
        setter.addParameter("pressure", "bar", 5.0);
        Stream stream = new Stream("Test Stream");
        setter.addTargetEquipment(stream);
        setter.run(UUID.randomUUID());
    }
}

