/*
 * Decompiled with CFR 0.152.
 */
package neqsim.process.equipment.valve;

import java.io.Serializable;
import neqsim.process.equipment.stream.StreamInterface;
import neqsim.process.equipment.valve.ThrottlingValve;

public class SafetyReliefValve
extends ThrottlingValve
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final double EPS = 1.0E-9;
    private static final double LARGE_TIME_SEC = 1.0E9;
    private static final double ATM_PRESSURE_BAR = 1.01325;
    private double setPressureBar = 10.0;
    private double overpressureFrac = 0.1;
    private double blowdownFrac = 0.07;
    private double ratedCv = 100.0;
    private double kd = 0.975;
    private double kbMax = 1.0;
    private double backpressureSensitivity = 0.15;
    private double minStableOpenFrac = 0.0;
    private ValveType valveType = ValveType.CONVENTIONAL;
    private OpeningLaw openingLaw = OpeningLaw.SNAP;
    private double openFraction = 0.0;
    private boolean wasOpenLastStep = false;
    private double timeSinceOpenSec = 1.0E9;
    private double timeSinceCloseSec = 1.0E9;
    private double tauOpenSec = 0.15;
    private double tauCloseSec = 0.4;
    private double minOpenTimeSec = 0.5;
    private double minCloseTimeSec = 0.2;
    private double maxLiftRatePerSec = 3.0;

    public SafetyReliefValve() {
        super("SafetyReliefValve");
    }

    public SafetyReliefValve(String name, StreamInterface inletStream) {
        super(name, inletStream);
    }

    public double getSetPressureBar() {
        return this.setPressureBar;
    }

    public void setSetPressureBar(double v) {
        this.setPressureBar = v;
    }

    public double getOverpressureFrac() {
        return this.overpressureFrac;
    }

    public void setOverpressureFrac(double v) {
        this.overpressureFrac = Math.max(0.0, v);
    }

    public double getBlowdownFrac() {
        return this.blowdownFrac;
    }

    public void setBlowdownFrac(double v) {
        this.blowdownFrac = Math.max(0.0, v);
    }

    public double getRatedCv() {
        return this.ratedCv;
    }

    public void setRatedCv(double v) {
        this.ratedCv = Math.max(0.0, v);
    }

    public double getKd() {
        return this.kd;
    }

    public void setKd(double v) {
        this.kd = Math.max(0.0, v);
    }

    public double getKbMax() {
        return this.kbMax;
    }

    public void setKbMax(double v) {
        this.kbMax = Math.max(0.0, v);
    }

    public double getBackpressureSensitivity() {
        return this.backpressureSensitivity;
    }

    public void setBackpressureSensitivity(double v) {
        this.backpressureSensitivity = Math.max(0.0, v);
    }

    public double getMinStableOpenFrac() {
        return this.minStableOpenFrac;
    }

    public void setMinStableOpenFrac(double v) {
        this.minStableOpenFrac = Math.max(0.0, Math.min(1.0, v));
    }

    public ValveType getValveType() {
        return this.valveType;
    }

    public void setValveType(ValveType t) {
        this.valveType = t;
    }

    public OpeningLaw getOpeningLaw() {
        return this.openingLaw;
    }

    public void setOpeningLaw(OpeningLaw law) {
        this.openingLaw = law;
    }

    public double getOpenFraction() {
        return this.openFraction;
    }

    public void setTauOpenSec(double v) {
        this.tauOpenSec = Math.max(0.0, v);
    }

    public void setTauCloseSec(double v) {
        this.tauCloseSec = Math.max(0.0, v);
    }

    public void setMinOpenTimeSec(double v) {
        this.minOpenTimeSec = Math.max(0.0, v);
    }

    public void setMinCloseTimeSec(double v) {
        this.minCloseTimeSec = Math.max(0.0, v);
    }

    public void setMaxLiftRatePerSec(double v) {
        this.maxLiftRatePerSec = Math.max(0.0, v);
    }

    private double relievingPressureBar() {
        return this.setPressureBar * (1.0 + this.overpressureFrac);
    }

    private double reseatPressureBar() {
        return this.setPressureBar * (1.0 - this.blowdownFrac);
    }

    private double computeOpeningFraction(double pUpBar) {
        double frac;
        double pRel = this.relievingPressureBar();
        double pReseat = this.reseatPressureBar();
        switch (this.openingLaw) {
            case SNAP: {
                if (pUpBar >= pRel) {
                    frac = 1.0;
                    break;
                }
                if (this.wasOpenLastStep && pUpBar > pReseat) {
                    frac = (pUpBar - this.setPressureBar) / Math.max(1.0E-9, pRel - this.setPressureBar);
                    frac = Math.max(frac, this.minStableOpenFrac);
                    break;
                }
                if (pUpBar <= pReseat) {
                    frac = 0.0;
                    break;
                }
                frac = 0.0;
                break;
            }
            default: {
                if (this.wasOpenLastStep && pUpBar <= pReseat) {
                    return 0.0;
                }
                if (pUpBar <= this.setPressureBar) {
                    return 0.0;
                }
                if (pUpBar >= pRel) {
                    return 1.0;
                }
                frac = (pUpBar - this.setPressureBar) / Math.max(1.0E-9, pRel - this.setPressureBar);
            }
        }
        return Math.max(0.0, Math.min(1.0, frac));
    }

    private double capacityBackpressureFactor(double pUpBar, double pDownBar) {
        double kb;
        if (pUpBar <= 0.0) {
            return 1.0;
        }
        double ratio = Math.max(0.0, Math.min(1.0, pDownBar / pUpBar));
        switch (this.valveType) {
            case CONVENTIONAL: {
                kb = 1.0 - this.backpressureSensitivity * ratio;
                break;
            }
            case BALANCED_BELLOWS: {
                kb = 1.0 - 0.05 * this.backpressureSensitivity * ratio;
                break;
            }
            default: {
                kb = 1.0 - 0.5 * this.backpressureSensitivity * ratio;
            }
        }
        kb = Math.max(0.0, Math.min(this.kbMax, kb));
        return kb;
    }

    private void applyOpeningToCv(double openFrac, double kb) {
        double effectiveCv = this.ratedCv * openFrac * this.kd * kb;
        if (effectiveCv <= 0.0) {
            this.setCv(0.0);
            this.setPercentValveOpening(0.0);
        } else {
            this.setCv(effectiveCv);
            this.setPercentValveOpening(Math.max(0.0, Math.min(100.0, openFrac * 100.0)));
        }
    }

    @Override
    public void run() {
        StreamInterface in = this.getInletStream();
        StreamInterface out = this.getOutletStream();
        double pUpBar = this.ensureBar(in.getThermoSystem().getPressure());
        double pDownBar = out != null ? this.ensureBar(out.getThermoSystem().getPressure()) : 1.01325;
        double newCmd = this.computeOpeningFraction(pUpBar);
        if (newCmd > 0.0) {
            newCmd = Math.max(newCmd, this.minStableOpenFrac);
        }
        double kb = this.capacityBackpressureFactor(pUpBar, pDownBar);
        this.applyOpeningToCv(newCmd, kb);
        super.run();
        this.wasOpenLastStep = newCmd > 0.0;
        this.openFraction = newCmd;
        this.timeSinceOpenSec = this.wasOpenLastStep ? 1.0E9 : 0.0;
        this.timeSinceCloseSec = this.wasOpenLastStep ? 0.0 : 1.0E9;
    }

    private double ensureBar(double pressure) {
        return pressure > 1000.0 ? pressure / 100000.0 : pressure;
    }

    @Override
    public void runTransient(double dt) {
        boolean newOpen;
        boolean currentlyOpen;
        StreamInterface in = this.getInletStream();
        StreamInterface out = this.getOutletStream();
        double pUpBar = this.ensureBar(in.getThermoSystem().getPressure());
        double pDownBar = out != null ? this.ensureBar(out.getThermoSystem().getPressure()) : 1.01325;
        double cmd = this.computeOpeningFraction(pUpBar);
        boolean bl = currentlyOpen = this.openFraction > 0.0;
        if (currentlyOpen) {
            if (this.timeSinceOpenSec < this.minOpenTimeSec) {
                cmd = Math.max(cmd, Math.max(this.minStableOpenFrac, 1.0E-6));
            }
        } else if (this.timeSinceCloseSec < this.minCloseTimeSec) {
            cmd = 0.0;
        }
        double kb = this.capacityBackpressureFactor(pUpBar, pDownBar);
        double tau = cmd >= this.openFraction ? this.tauOpenSec : this.tauCloseSec;
        double alpha = tau <= 1.0E-9 ? 1.0 : 1.0 - Math.exp(-dt / tau);
        double liftProposed = this.openFraction + alpha * (cmd - this.openFraction);
        if (this.maxLiftRatePerSec > 0.0) {
            double maxDelta = this.maxLiftRatePerSec * dt;
            double delta = liftProposed - this.openFraction;
            if (Math.abs(delta) > maxDelta) {
                liftProposed = this.openFraction + Math.copySign(maxDelta, delta);
            }
        }
        if ((liftProposed = Math.max(0.0, Math.min(1.0, liftProposed))) > 0.0) {
            liftProposed = Math.max(liftProposed, this.minStableOpenFrac);
        }
        this.applyOpeningToCv(liftProposed, kb);
        super.runTransient(dt);
        boolean bl2 = newOpen = liftProposed > 0.0;
        if (newOpen) {
            this.timeSinceOpenSec += dt;
            if (!this.wasOpenLastStep) {
                this.timeSinceOpenSec = 0.0;
            }
            this.timeSinceCloseSec = 0.0;
        } else {
            this.timeSinceCloseSec += dt;
            if (this.wasOpenLastStep) {
                this.timeSinceCloseSec = 0.0;
            }
            this.timeSinceOpenSec = 0.0;
        }
        this.wasOpenLastStep = newOpen;
        this.openFraction = liftProposed;
    }

    public SafetyReliefValve configureConventionalSnap(double psetBar, double overFrac, double blowFrac, double cvRated) {
        this.setValveType(ValveType.CONVENTIONAL);
        this.setOpeningLaw(OpeningLaw.SNAP);
        this.setSetPressureBar(psetBar);
        this.setOverpressureFrac(overFrac);
        this.setBlowdownFrac(blowFrac);
        this.setRatedCv(cvRated);
        this.setMinStableOpenFrac(0.03);
        this.setBackpressureSensitivity(0.15);
        return this;
    }

    public SafetyReliefValve configureBalancedModulating(double psetBar, double overFrac, double blowFrac, double cvRated) {
        this.setValveType(ValveType.BALANCED_BELLOWS);
        this.setOpeningLaw(OpeningLaw.MODULATING);
        this.setSetPressureBar(psetBar);
        this.setOverpressureFrac(overFrac);
        this.setBlowdownFrac(blowFrac);
        this.setRatedCv(cvRated);
        this.setMinStableOpenFrac(0.02);
        this.setKbMax(1.0);
        this.setBackpressureSensitivity(0.02);
        return this;
    }

    public double getRelievingPressureBar() {
        return this.relievingPressureBar();
    }

    public double getReseatPressureBar() {
        return this.reseatPressureBar();
    }

    public static enum OpeningLaw {
        SNAP,
        MODULATING;

    }

    public static enum ValveType {
        CONVENTIONAL,
        BALANCED_BELLOWS,
        PILOT_MODULATING;

    }
}

